# Документация
## Содержание
1. [Системные требования](#системные-требования)
2. [Установка](#установка)
3. [Запуск](#запуск)
4. [Авторизация](#авторизация)
5. [Обновление](#обновление)
6. [Интеграция с СУБД](#интеграция-с-субд)
7. [Удаление](#удаление)

## Системные требования
### Сервер 
- Процессор: 64-разрядный с тактовой частотой 1 ГГц или выше.
- Свободное место на жестком диске: не менее 1ГБ.
- Оперативная память: не менее 2ГБ.
- Операционная система:
    - Windows:
        - Windows 10 и выше.
        - Windows Server 2012 (с расширенными обновлениями безопасности) и выше.
    - Linux:
        - Debian 12 и выше.
        - Ubuntu 20.04 и выше.
        - Fedora 39 и выше.
        - Производные от них.

### СУБД:
- SQLite 3 (используется по умолчанию). 
- PostgreSQL 11 и выше.
- Microsoft SQL Server 2017 и выше.
- MariaDB 10.3 и выше.

### Клиент
- Браузер на основе Chromium последней версии: Google Chrome, Microsoft Edge, Яндекс Браузер и т.д.
- Браузер Mozilla Firefox последней версии.

## Установка
Для установки необходимо выполнить следующие шаги:
1. Создать любую директорию, например, `SMS-Automation`.
2. Распаковать архив `ТехноДок` в созданную директорию.

#### Linux
```sh
sudo mkdir -p /opt/SMS-Automation/TechnoDoc \
&& sudo unzip "[Путь до архива ТехноДок]" -d "/opt/SMS-Automation/TechnoDoc" \
&& sudo chown -R $USER: /opt/SMS-Automation/TechnoDoc
```

#### Windows
```batch
mkdir -p "C:\Program Files\SMS-Automation\TechnoDoc" && tar -xf [Путь до архива ТехноДок] -C "C:\Program Files\SMS-Automation\TechnoDoc"
```

## Запуск
### Запуск из терминала
Для запуска из терминала необходимо выполнить следующие шаги:
1. Перейти в директорию `scripts`.
2. Выполнить скрипт `run`.

#### Linux
```sh
cd /opt/SMS-Automation/TechnoDoc/scripts && sh run.sh
```

#### Windows
```batch
cd "C:\Program Files\SMS-Automation\scripts" && start "run.bat"
```

### Запуск в качестве сервиса
Для запуска в качестве сервиса необходимо выполнить следующие шаги:
1. Перейти в директорию `scripts/service`.
2. Выполнить скрипт `create`.
3. Выполнить скрипт `start`.

#### Linux
```sh
# Перейти в директорию "scripts/service"
cd /opt/SMS-Automation/TechnoDoc/scripts

# Выполнить скрипт "create"
sh create.sh

# Выполнить скрипт "start"
sh start.sh
```

:::warning предупреждение
Для создания и запуска сервиса требуется наличие прав суперпользователя.
:::

#### Windows
```batch
rem Перейти в директорию "scripts/service"
cd "C:\Program Files\SMS-Automation\TechnoDoc\scripts\service"

rem Выполнить скрипт "create"
create.bat

rem Выполнить скрипт "start"
start.bat
```

:::warning предупреждение
Для создания и запуска сервиса требуется наличие прав администратора.
:::

:::note примечание
- Для останова сервиса необходимо выполнить скрипт `stop`.
- Для удаления сервиса необходимо выполнить скрипт `delete`.
- Перед запуском `ТехноДок` в качестве сервиса необходимо остановить `ТехноДок`, запущенный из терминала.
:::

## Авторизация
Для авторизации необходимо выполнить следующие шаги:
1. Открыть в браузере страницу `http://127.0.0.1:8003`.
2. Ввести лицензионный ключ и нажать кнопку `Активировать` в появившемся модальном окне `Активация лицензии`. 
3. Ввести логин/пароль - `admin/admin` и нажать кнопку "Войти".

:::note примечание
- Демо-лицензию можно получить, нажав на кнопку `Запросить демо-лицензию`.
- Долгосрочную лицензию можно запросить по адресу `technodoc@sms-a.ru`.
:::

## Обновление

:::warning предупреждение
- Перед обновлением рекомендуется создать резервную копию директории, в которой установлен и запущен `ТехноДок`.
- Перед обновлением, в случае интеграции с внешней СУБД, рекомендуется сделать резервную копию БД.
- Совместимость между мажорными релизами не гарантируется.
- В случае интеграции с внешними SCADA системами (КАСКАД, АСОКУ, Alpha) необходимо заменить файлы `ТехноДок` в проекте SCADA на новые версии файлов из директории `components`.
:::

### Обновление внутри одной мажорной версии (например, с 7.1.0 на 7.2.5)

Для обновления необходимо выполнить следующие шаги:
1. Остановить сервер текущей версии `ТехноДок`.
2. Распаковать новую версию `ТехноДок` в директорию отличную от той, в которой установлена и запущена текущая версия `ТехноДок`.
3. Скопировать директорию `data`, в которой установлена текущая версия `ТехноДок`, в директорию куда была распакована новая версия `ТехноДок` с опцией замены файлов.
Следующие шаги выполняются из директории новой версии `ТехноДок`.
4. Перейти в директорию `scripts`.
5. Выполнить скрипт `run-migrator`.
6. Запустить сервер `ТехноДок` согласно разделу [Запуск](#Запуск).

### Обновление на новую мажорную версию (например, с 7.2.0 на 8.1.1)

:::warning предупреждение
- Мы **не гарантируем полную совместимость** шаблонов и отчётов между мажорными версиями.
- Встроенный механизм миграции старается поддерживать совместимость, но для всех сценариев это не работает.
- При обновлении может потребоваться ручная доработка отчётов.
- Если вы столкнулись с проблемой перехода на новую мажорную версию, пожалуйста, свяжитесь с нами по электронной почте: **technodoc@sms-a.ru**. Мы предоставим инструкции и поможем провести обновление в индивидуальном порядке.
:::

Если необходимо выполнить обновление на новую мажорную версию, то рекомендуется выполнить следующие шаги:
1. Выполнить шаги из раздела выше, но не запускать `ТехноДок` (последний пункт).
2. Перейти в папку `bin`.
3. Запустить `ТехноДок` из терминала, добавив аргумент `content-database-update`
    - Linux:  `./Sms.TechnoDoc content-database-update`
    - Windows: `Sms.TechnoDoc.exe content-database-update`
4. ТехноДок запустит процесс обновления существующих шаблонов отчетов и экземпляров отчетов.
5. После завершения обновления в консоли должно появиться сообщение вида: `Сервер ... успешно запущен`. После чего можно остановить процесс, закрыв консоль, или комбинацией клавиш `Ctrl+C`.
6. Запустить `ТехноДок` согласно последнему пункту из предыдущего раздела.
7. Проверить работоспособность отчётов. При необходимости поправить формулы параметров и верстку в шаблонах отчетов.

## Интеграция с СУБД
Для интеграции с СУБД необходимо выполнить следующие шаги:
1. Остановить сервер `ТехноДок`.
2. Открыть файл `application.conf`.
3. Раскомментировать ключи `Type` и `ConnectionString` в секции `[Database:Connections:Primary]` необходимой СУБД.
4. Указать корректное имя пользователя, пароль и имя базы данных в строке соединения с СУБД (ключ `ConnectionString`).
5. Сохранить изменения в файле `application.conf`.
6. Запустить скрипт `run-migrator`, расположенный в директории `scripts`. 
7. Запустить сервер `ТехноДок`.

:::warning предупреждение
Для СУБД `MariaDB` перед выполнением скрипта `run-migrator` необходимо добавить настройку `sql-mode="ANSI_QUOTES"` в секцию `[mysqld]` конфигурационного файл `my.cnf` и перезапустить сервер `MariaDB`.
:::

:::note примечание
- После успешного завершения выполнения скрипта `run-migrator` должна быть создана БД.
- Рекомендуется использовать одну из внешних СУБД для средних и крупных проектов.
:::

## Удаление
Для удаления необходимо выполнить следующие шаги:
1. Остановить сервер `ТехноДок`.
2. Удалить директорию, в которую был распакован архив `ТехноДок`.

:::note примечание
- Если `ТехноДок` был запущен в качестве сервиса, то необходимо удалить сервис при помощи скрипта `delete`.
- Если `ТехноДок` был интегрирован с внешними СУБД, то необходимо вручную удалить БД `ТехноДок`.
:::