var InvalidLicenseInterceptor = (function () {
    function InvalidLicenseInterceptor($q, $rootScope, $injector) {
        var _this = this;
        this.$q = $q;
        this.$rootScope = $rootScope;
        this.$injector = $injector;
        this.responseError = function (response) {
            if (response.status !== 403) {
                return _this.$q.reject(response);
            }
            var forbiddenReason = response.data[dto.reasonProblemResponseFieldName];
            if (!forbiddenReason || forbiddenReason !== dto.licenseInvalidReason) {
                return _this.$q.reject(response);
            }
            if (!_this.$rootScope.modalLicenseWindowOpened) {
                _this.$rootScope.modalLicenseWindowOpened = true;
                var modal = _this.$injector.get('$modal');
                modal
                    .open({
                    templateUrl: 'ng1/dist/src/Core/License/LicenseWindow/ActivationLicenseWindow.html',
                    controller: 'licenseWindowController',
                    backdrop: 'static',
                    keyboard: false,
                    resolve: {
                        canBeClosed: function () { return false; },
                        licenseState: function () { return response.data[dto.licenseStateHeader]; },
                        missingModules: function () { return response.data[dto.licenseMissingModuleHeader]; },
                        errorMessage: function () { return response.data[dto.licenseErrorMessage]; }
                    },
                })
                    .result.then(function () {
                    _this.$rootScope.modalLicenseWindowOpened = false;
                }, function () { });
            }
            return _this.$q.reject(response);
        };
    }
    InvalidLicenseInterceptor.Factory = function ($q, $rootScope, $injector) {
        return new InvalidLicenseInterceptor($q, $rootScope, $injector);
    };
    InvalidLicenseInterceptor.$inject = ['$q', '$rootScope', '$injector'];
    return InvalidLicenseInterceptor;
}());
