var UserPreferencesService = (function () {
    function UserPreferencesService(coreConfiguration) {
        this.coreConfiguration = coreConfiguration;
        this.brandType = coreConfiguration.brandType;
    }
    UserPreferencesService.prototype.getPreferences = function () {
        if (this.userPreferences) {
            return this.userPreferences;
        }
        var userPreferencesString = localStorage.getItem(UserPreferencesService.UserPreferencesStorageKey);
        if (userPreferencesString) {
            this.userPreferences = new UserPreferences(this.brandType, JSON.parse(userPreferencesString));
            return this.userPreferences;
        }
        return new UserPreferences(this.brandType);
    };
    UserPreferencesService.prototype.setPreferences = function (preferences) {
        this.userPreferences = preferences;
        localStorage.setItem(UserPreferencesService.UserPreferencesStorageKey, JSON.stringify(preferences));
    };
    UserPreferencesService.$inject = [
        'coreConfiguration'
    ];
    UserPreferencesService.UserPreferencesStorageKey = 'userPreferences';
    return UserPreferencesService;
}());
angular.module('kamhpp').service('userPreferencesService', UserPreferencesService);
