var CommonUserPreferences = (function () {
    function CommonUserPreferences(preferences) {
        var _a, _b, _c;
        this.mailRecipients = [];
        this.mailRecipients = (_a = preferences === null || preferences === void 0 ? void 0 : preferences.mailRecipients) !== null && _a !== void 0 ? _a : [];
        this.homeModulesCollapse = (_b = preferences === null || preferences === void 0 ? void 0 : preferences.homeModulesCollapse) !== null && _b !== void 0 ? _b : new HomeUserPreferences();
        this.tagsTreeSearchText = (_c = preferences === null || preferences === void 0 ? void 0 : preferences.tagsTreeSearchText) !== null && _c !== void 0 ? _c : {};
    }
    CommonUserPreferences.prototype.updateMailRecipientsPreferences = function (addresses) {
        var _this = this;
        _.forEach(addresses, function (address) {
            if (!_.any(_this.mailRecipients, function (resipient) { return resipient === address; })) {
                _this.mailRecipients.push(address);
            }
        });
    };
    return CommonUserPreferences;
}());
var AuthenticationUserPreference = (function () {
    function AuthenticationUserPreference(preference) {
        this.authenticationType = preference === null || preference === void 0 ? void 0 : preference.authenticationType;
    }
    return AuthenticationUserPreference;
}());
var ReportUserPreferences = (function () {
    function ReportUserPreferences(brandType, preferences) {
        var _a, _b, _c, _d;
        this.reportTemplateChapter = preferences === null || preferences === void 0 ? void 0 : preferences.reportTemplateChapter;
        this.reportParameterSource = (_a = preferences === null || preferences === void 0 ? void 0 : preferences.reportParameterSource) !== null && _a !== void 0 ? _a : (brandType === 1 ? 'alpha' : 'winccoa');
        this.reportParameterCalcType = (_b = preferences === null || preferences === void 0 ? void 0 : preferences.reportParameterCalcType) !== null && _b !== void 0 ? _b : 'double';
        this.reportTimestampFormat = preferences === null || preferences === void 0 ? void 0 : preferences.reportTimestampFormat;
        this.reportViewsScale = (_c = preferences === null || preferences === void 0 ? void 0 : preferences.reportViewsScale) !== null && _c !== void 0 ? _c : {};
        this.reportAutoUpdateTime = (_d = preferences === null || preferences === void 0 ? void 0 : preferences.reportAutoUpdateTime) !== null && _d !== void 0 ? _d : {};
    }
    return ReportUserPreferences;
}());
var SwitchoverFormUserPreferences = (function () {
    function SwitchoverFormUserPreferences(preferences) {
        this.lastSelectedTemplateId = preferences === null || preferences === void 0 ? void 0 : preferences.lastSelectedTemplateId;
    }
    return SwitchoverFormUserPreferences;
}());
var HomeUserPreferences = (function () {
    function HomeUserPreferences(preferences) {
        this.reportChapterOpen = true;
        this.operationTimeChapterOpen = true;
        this.switchoverFormsChapterOpen = true;
        if (!preferences)
            return;
        this.reportChapterOpen = preferences.reportChapterOpen;
        this.operationTimeChapterOpen = preferences.operationTimeChapterOpen;
        this.switchoverFormsChapterOpen = preferences.switchoverFormsChapterOpen;
    }
    return HomeUserPreferences;
}());
var ReportParamtersTableColumnVisibiliyPreferences = (function () {
    function ReportParamtersTableColumnVisibiliyPreferences(preferences) {
        this.isReportSourceDataColumnVisible = false;
        this.isReportSourceGroupColumnVisible = false;
        this.isReportManualInputColumnVisible = false;
        this.isReportPlannedValueColumnVisible = false;
        this.isReportPredefinedValueColumnVisible = false;
        this.isReportTagNameColumnVisible = false;
        if (!preferences) {
            return;
        }
        this.isReportManualInputColumnVisible = preferences.isReportManualInputColumnVisible;
        this.isReportPlannedValueColumnVisible = preferences.isReportPlannedValueColumnVisible;
        this.isReportPredefinedValueColumnVisible = preferences.isReportPredefinedValueColumnVisible;
        this.isReportSourceDataColumnVisible = preferences.isReportSourceDataColumnVisible;
        this.isReportSourceGroupColumnVisible = preferences.isReportSourceGroupColumnVisible;
        this.isReportTagNameColumnVisible = preferences.isReportTagNameColumnVisible;
    }
    return ReportParamtersTableColumnVisibiliyPreferences;
}());
var UserPreferences = (function () {
    function UserPreferences(brandType, preferences) {
        this.common = preferences
            ? new CommonUserPreferences(preferences.common)
            : new CommonUserPreferences();
        this.switchoverForm = preferences
            ? new SwitchoverFormUserPreferences(preferences.switchoverForm)
            : new SwitchoverFormUserPreferences();
        this.report = preferences
            ? new ReportUserPreferences(brandType, preferences.report)
            : new ReportUserPreferences(brandType);
        this.reportParameterColumn = preferences
            ? new ReportParamtersTableColumnVisibiliyPreferences(preferences.reportParameterColumn)
            : new ReportParamtersTableColumnVisibiliyPreferences();
        this.home = new HomeUserPreferences(preferences === null || preferences === void 0 ? void 0 : preferences.home);
    }
    return UserPreferences;
}());
