var OperatingSystemType;
(function (OperatingSystemType) {
    OperatingSystemType["Windows"] = "Windows";
    OperatingSystemType["Linux"] = "Linux";
    OperatingSystemType["Mac"] = "Mac";
})(OperatingSystemType || (OperatingSystemType = {}));
var OperatingSystemProvider = (function () {
    function OperatingSystemProvider() {
    }
    OperatingSystemProvider.prototype.getCurrent = function () {
        var userAgent = window.navigator.userAgent;
        if (userAgent.indexOf(OperatingSystemType.Windows) !== -1) {
            return OperatingSystemType.Windows;
        }
        if (userAgent.indexOf(OperatingSystemType.Linux) !== -1) {
            return OperatingSystemType.Linux;
        }
        if (userAgent.indexOf(OperatingSystemType.Mac) !== -1) {
            return OperatingSystemType.Mac;
        }
    };
    OperatingSystemProvider.prototype.isWindows = function () {
        return this.getCurrent() === OperatingSystemType.Windows;
    };
    OperatingSystemProvider.prototype.isLinux = function () {
        return this.getCurrent() === OperatingSystemType.Linux;
    };
    OperatingSystemProvider.prototype.isMac = function () {
        return this.getCurrent() === OperatingSystemType.Mac;
    };
    return OperatingSystemProvider;
}());
app.service('operatingSystemProvider', OperatingSystemProvider);
