var SmsNg2HandlerService = (function () {
    function SmsNg2HandlerService($rootScope, $injector) {
        this.$rootScope = $rootScope;
        this.$injector = $injector;
    }
    SmsNg2HandlerService.prototype.run = function () {
        var _this = this;
        this.$rootScope.$on('invalidLicenseFromNg2', function (e, licenseState, missingModules, errorMessage) {
            if (!_this.$rootScope.modalLicenseWindowOpened) {
                _this.$rootScope.modalLicenseWindowOpened = true;
                var modal = _this.$injector.get('$modal');
                modal
                    .open({
                    templateUrl: 'ng1/dist/src/Core/License/LicenseWindow/ActivationLicenseWindow.html',
                    controller: 'licenseWindowController',
                    backdrop: 'static',
                    keyboard: false,
                    resolve: {
                        canBeClosed: function () { return false; },
                        licenseState: function () { return licenseState; },
                        missingModules: function () { return missingModules; },
                        errorMessage: function () { return errorMessage; }
                    },
                })
                    .result.then(function () {
                    _this.$rootScope.modalLicenseWindowOpened = false;
                }, function () { });
            }
        });
        this.$rootScope.$on('refreshTokensFromNg2', function () {
            var authentication = _this.$injector.get('authentication');
            authentication.refreshToken().then(function (accessToken) {
                _this.$rootScope.$broadcast('RefreshTokensToNg2', accessToken);
            });
        });
        this.$rootScope.$on('serviceUnavailable', function (event, statusCode) {
            if (!_this.$rootScope.isServerUnavailableModalOpened) {
                _this.$rootScope.isServerUnavailableModalOpened = true;
                var modal = _this.$injector.get('$modal');
                modal.open({
                    templateUrl: 'ng1/dist/src/ErrorPages/ServiceUnavailable/ServiceUnavailableView.html',
                    controller: 'serviceUnavailableViewCtrl',
                    windowClass: 'full-screen-diagnostic-modal',
                    backdrop: 'static',
                    keyboard: false,
                    resolve: {
                        statusCode: function () { return statusCode; }
                    },
                })
                    .result.finally(function () {
                    _this.$rootScope.isServerUnavailableModalOpened = false;
                });
            }
        });
        this.$rootScope.$on('permissionsMissingFromNg2', function (e, message) {
            if (!_this.$rootScope.isAccessDeniedModalOpened) {
                _this.$rootScope.isAccessDeniedModalOpened = true;
                var modal = _this.$injector.get('$modal');
                modal.open({
                    templateUrl: 'ng1/dist/src/ErrorPages/AccessDenied/AccessDeniedView.html',
                    controller: 'accessDeniedViewCtrl',
                    windowClass: 'full-screen-diagnostic-modal',
                    backdrop: 'static',
                    keyboard: false,
                    resolve: {
                        message: function () { return message; }
                    },
                })
                    .result.finally(function () {
                    _this.$rootScope.isAccessDeniedModalOpened = false;
                });
            }
        });
        this.$rootScope.$on('serverFailoverFromNg2', function (e, date) {
            var notificationService = _this.$injector.get('notificationService');
            var language = _this.$injector.get('language');
            var dateFilter = _this.$injector.get('dateFilter');
            ;
            notificationService.warnMessage(language.getElementValue('clusterServerFailoverMsg'), String.Format(language.getElementValue('clusterServerFailoverMoreMsg'), dateFilter(date, Date.masks.fullDateTime)), undefined, undefined, true);
        });
        this.$rootScope.$on('deviceLimitExceedFromNg2', function () {
            var modal = _this.$injector.get('$modal');
            if (!_this.$rootScope.modalDeviceLimitExceedOpened) {
                _this.$rootScope.modalDeviceLimitExceedOpened = true;
                modal
                    .open({
                    templateUrl: 'ng1/dist/src/Core/License/DeviceLimitExceedWindow/DeviceLimitExceedWindow.html',
                    controller: 'deviceLimitExceedWindowController',
                    backdrop: 'static',
                    windowClass: 'modal-medium',
                    keyboard: false
                })
                    .result
                    .then()
                    .finally(function () {
                    _this.$rootScope.modalDeviceLimitExceedOpened = false;
                });
            }
        });
    };
    SmsNg2HandlerService.$inject = [
        '$rootScope',
        '$injector'
    ];
    return SmsNg2HandlerService;
}());
angular.module('kamhpp').service('smsNg2HandlerService', SmsNg2HandlerService);
