app.directive('smsDynamicList', function ($rootScope, $compile) {
    return {
        restrict: 'E',
        scope: {
            id: '@',
            items: '=',
            options: '=',
            template: '@',
            headers: '@',
            type: '@',
            add: '&',
            onChange: '&',
            remove: '=',
            filter: '@',
            disabled: '=',
        },
        link: function (scope, element, attrs) {
            scope.watchFunctions = [];
            var defaultListElement = '<input type="text" ng-model="item.name" style="width:100%; border: none; padding-left:10px; height:100%;"/>';
            switch (scope.type) {
                case 'input':
                    {
                        scope.element = defaultListElement;
                    }
                    break;
                case 'custom':
                    {
                        scope.element = scope.template;
                    }
                    break;
                default: {
                    scope.element = defaultListElement;
                }
            }
            scope.defaultRemove = function (item, index) {
                scope.items.splice(index, 1);
            };
            var funcName = _.isUndefined(scope.remove) ? 'defaultRemove' : 'remove';
            scope.insert = function () {
                if (attrs.add) {
                    scope.add();
                }
                else {
                    scope.items.push('');
                }
            };
            var getTemplate = function (template) {
                return '<div class="dynamic-list" style="width: 100%;">' +
                    (scope.headers == undefined ? '' : scope.headers) +
                    '<div class="dynamic-list-item" ng-repeat="item in items' +
                    (scope.filter == undefined ? '' : '|' + scope.filter) +
                    ' track by $index" ng-mouseenter="showRemoveButton($index)" ng-mouseleave="hideRemoveButton($index)">' +
                    template +
                    '<div class="btn-remove" style="background-color: transparent;" id="{{id + $index}}" ng-click="' +
                    funcName +
                    '(item, $index)">' +
                    '<i class="fa fa-close"></i>' +
                    '</div>' +
                    '</div>' +
                    '<div class="btn btn-default btn-insert" ng-click="insert()" ng-disabled="disabled"><i class="fa fa-plus"></i>{{ \'addBtn\' | lng }}</div>' +
                    '</div>';
            };
            var template = getTemplate(scope.element);
            element.html(template);
            $compile(element.contents())(scope);
            scope.showRemoveButton = function (index) {
                if (scope.disabled) {
                    return;
                }
                $('#' + scope.id + index).css('display', 'inline-block');
            };
            scope.hideRemoveButton = function (index) {
                $('#' + scope.id + index).css('display', 'none');
            };
            scope.watchFunctions.push(scope.$watch(function () {
                return scope.template;
            }, function (after, before) {
                if (_.isUndefined(before) || after === before)
                    return;
                var template = getTemplate(after);
                element.html(template);
                $compile(element.contents())(scope);
            }));
            scope.watchFunctions.push(scope.$watch(function () {
                return scope.items;
            }, function (after, before) {
                if (_.isUndefined(before) || after === before)
                    return;
                if (scope.onChange) {
                    scope.onChange();
                }
            }, true));
            scope.watchFunctions.push(scope.$on('$destroy', function () {
                _.forEach(scope.watchFunctions, function (func) {
                    if (!_.isUndefined(func)) {
                        func();
                    }
                });
            }));
        },
    };
});
