var ReportUserFileDirective = (function () {
    function ReportUserFileDirective($rootScope, $timeout, notificationService, language) {
        var _this = this;
        this.$rootScope = $rootScope;
        this.$timeout = $timeout;
        this.notificationService = notificationService;
        this.language = language;
        this.restrict = 'E';
        this.templateUrl = 'ng1/dist/src/_angular/_directives/_displayingReportElements/TdReportUserFile.html';
        this.replace = true;
        this.scope = {
            data: '@?',
            fileName: '@?',
            type: '@?',
            ts: '@?',
            ident: '@?',
            editable: '=?',
            extension: '@?'
        };
        this.link = function (scope, element, attrs, ctrl) {
            scope.value = new ReportFileValue(scope.fileName, scope.type, scope.data);
            scope.$watch(function () {
                return scope.value;
            }, function (after, before) {
                if (after && !_.isEqual(after, before)) {
                    var change = {
                        newValue: JSON.stringify(after),
                        oldValue: JSON.stringify(before),
                        timestamp: scope.ts,
                        ident: scope.ident
                    };
                    _this.$rootScope.$broadcast('reportValueEdited', change);
                }
            });
            scope.onClick = function () {
                _this.$rootScope.$broadcast('reportValueStartEdit');
            };
            scope.uploadUserFile = function ($files) {
                if ($files && $files[0]) {
                    var reader_1 = new FileReader();
                    reader_1.readAsDataURL($files[0]);
                    var self_1 = _this;
                    reader_1.onload = function () {
                        self_1.$timeout(function () {
                            var data = reader_1.result.toString().split(',')[1];
                            var name = $files[0].name;
                            scope.value = new ReportFileValue(name, name.split('.').pop(), data);
                        });
                    };
                    reader_1.onerror = function (error) {
                        self_1.notificationService.errorMessage(self_1.language.getElementValue('reportUserFileUploadErrorMsg'), error);
                    };
                }
            };
        };
    }
    ReportUserFileDirective.factory = function () {
        var directive = function ($rootScope, $timeout, notificationService, language) { return new ReportUserFileDirective($rootScope, $timeout, notificationService, language); };
        directive.$inject = ['$rootScope', '$timeout', 'notificationService', 'language'];
        return directive;
    };
    return ReportUserFileDirective;
}());
app.directive('smsReportUserFile', ReportUserFileDirective.factory());
