var ReportTimeSpanDirective = (function () {
    function ReportTimeSpanDirective($rootScope) {
        var _this = this;
        this.$rootScope = $rootScope;
        this.restrict = 'E';
        this.templateUrl = 'ng1/dist/src/_angular/_directives/_displayingReportElements/TdReportTimeSpan.html';
        this.replace = true;
        this.scope = {
            value: '@?',
            ts: '@?',
            ident: '@?',
            edited: '=?',
            editable: '=?',
            backlight: '@',
        };
        this.link = function (scope, element, attrs, ctrl) {
            scope.inputVisible = false;
            scope.lostFocus = function () {
                scope.inputVisible = false;
            };
            scope.$watch(function () {
                return scope.value;
            }, function (after, before) {
                if (after && before !== after) {
                    var change = {
                        newValue: after,
                        oldValue: before,
                        timestamp: scope.ts,
                        ident: scope.ident
                    };
                    scope.edited = true;
                    _this.$rootScope.$broadcast('reportValueEdited', change);
                }
            });
            var inputElement = element.children('input');
            scope.onValueClick = function () {
                if (!scope.editable) {
                    return;
                }
                _this.$rootScope.$broadcast('reportValueStartEdit');
                scope.inputVisible = true;
                if (scope.inputVisible) {
                    setTimeout(function () {
                        inputElement.focus();
                    });
                }
            };
            element.bind('keydown keypress', function (event) {
                if (event.which === 13) {
                    scope.lostFocus();
                    scope.inputVisible = false;
                    scope.$apply();
                    event.preventDefault();
                }
                if (event.which === 27) {
                    scope.inputVisible = false;
                    if (scope.lastValue) {
                        scope.value = scope.lastValue;
                    }
                    scope.$apply();
                    event.preventDefault();
                }
            });
        };
    }
    ReportTimeSpanDirective.factory = function () {
        var directive = function ($rootScope) { return new ReportTimeSpanDirective($rootScope); };
        directive.$inject = ['$rootScope'];
        return directive;
    };
    return ReportTimeSpanDirective;
}());
app.directive('smsReportTimeSpan', ReportTimeSpanDirective.factory());
