var SignatureController = (function () {
    function SignatureController(scope, rootScope, authentication, notificationService, reportSigningChecker, guid, reportTemplateService, language, userProvider) {
        var _this = this;
        var _a, _b;
        this.scope = scope;
        this.rootScope = rootScope;
        this.notificationService = notificationService;
        this.reportSigningChecker = reportSigningChecker;
        this.reportTemplateService = reportTemplateService;
        this.userProvider = userProvider;
        this.pngPrefix = 'data:image/png;base64,';
        this.watchFunctions = [];
        this.guid = guid.new();
        this.signed = this.scope.value != undefined && this.scope.value != '' && this.scope.value != '-';
        this.userId = (_a = authentication.user) === null || _a === void 0 ? void 0 : _a.id;
        this.usersForSignature = (_b = this.scope.signingauthorities) !== null && _b !== void 0 ? _b : [];
        this.language = language;
        this.userProvider.get(this.userId).then(function (user) {
            var extendUser = _.deepclone(user);
            extendUser.signatureImage = _this.getViewImage(extendUser.signature);
            _this.user = extendUser;
        }, function (error) { _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error); });
        this.watchFunctions.push(this.rootScope.$on('reportValueEdited', function (event, change) {
            if (change.source === 'smsReportSignature' || !_this.signed)
                return;
        }));
        this.watchFunctions.push(scope.$on('$destroy', function () {
            _this.reportSigningChecker.deleteReportSignatureChecker(scope.$id);
            _this.watchFunctions.forEach(function (listener) { return listener(); });
        }));
        this.reportSigningChecker.addReportSignatureChecker(scope.$id, this.checkSigningFunc());
    }
    SignatureController.prototype.isEmptyImage = function (image) {
        return image === null || image === '';
    };
    SignatureController.prototype.getViewImage = function (image) {
        if (!this.isEmptyImage(image)) {
            image = this.pngPrefix + image;
        }
        return image;
    };
    SignatureController.prototype.canSign = function () {
        var _this = this;
        return _.any(this.usersForSignature, function (userId) { return userId === _this.userId; });
    };
    SignatureController.prototype.canEditReport = function () {
        if (!this.reportTemplateService.checkEditCurrentReportPermission()) {
            this.notificationService.warnMessage(this.language.getElementValue('smsReportSignatureNeedRightToEditReportMsg'));
            return false;
        }
        return true;
    };
    SignatureController.prototype.sign = function () {
        if (!this.canEditReport() || !this.canSign()) {
            return;
        }
        if (this.isEmptyImage(this.user.signatureImage)) {
            this.notificationService.warnMessage(this.language.getElementValue('smsReportSignatureUserNotHaveImageSignatureMsg'));
            return;
        }
        this.updateValue(this.user.id);
        this.signed = true;
    };
    SignatureController.prototype.removeSign = function () {
        if (!this.canEditReport() || !this.canSign()) {
            return;
        }
        this.signed = false;
        this.updateValue('');
        this.rootScope.$broadcast('smsReportSignature.singatureRemoved', this.guid);
    };
    SignatureController.prototype.getLineHeight = function () {
        var minHeight = 50;
        var img = new Image();
        if (this.user.signatureImage == null) {
            return minHeight;
        }
        img.src = this.user.signatureImage;
        var paddingValue = 5;
        var lineHeight = img.naturalHeight + 2 * paddingValue;
        return lineHeight > minHeight ? lineHeight : minHeight;
    };
    SignatureController.prototype.checkSigningFunc = function () {
        var _this = this;
        return function () { return _this.signed; };
    };
    SignatureController.prototype.updateValue = function (newValue) {
        var change = {
            newValue: newValue,
            oldValue: this.scope.value,
            timestamp: this.scope.ts,
            ident: this.scope.ident,
            source: 'smsReportSignature',
        };
        this.scope.value = newValue;
        this.rootScope.$broadcast('reportValueStartEdit');
        this.rootScope.$broadcast('reportValueEdited', change);
    };
    return SignatureController;
}());
app.directive('smsReportSignature', function ($rootScope, notificationService, guid, reportSigningChecker, authentication, reportTemplateService, language, userProvider) { return ({
    restrict: 'E',
    priority: 1000,
    scope: {
        value: '@?',
        signingauthorities: '=',
        ts: '=?',
        ident: '=?',
        backlight: '@',
    },
    templateUrl: 'ng1/dist/src/_angular/_directives/_displayingReportElements/TdReportSignature.html',
    link: function (scope) {
        scope.ctrl = new SignatureController(scope, $rootScope, authentication, notificationService, reportSigningChecker, guid, reportTemplateService, language, userProvider);
    },
}); });
