var TemplateParametersCtrl = (function () {
    function TemplateParametersCtrl($timeout, language, markupCtrl, userPreferencesService, templateParameterService, externalConnectionsProvider) {
        var _this = this;
        this.$timeout = $timeout;
        this.language = language;
        this.markupCtrl = markupCtrl;
        this.userPreferencesService = userPreferencesService;
        this.templateParameterService = templateParameterService;
        this.externalConnectionsProvider = externalConnectionsProvider;
        this.sort = {
            columnName: 'Ident',
            descending: false,
        };
        TemplateParametersCtrl.parameterSourcesWithGroups = [
            new ParameterSourceWithGroup('winccoa', this.language.getElementValue('reportParameterWinccoaXmlrpcHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('calc', this.language.getElementValue('reportParameterSettingsCalcHdr'), this.language.getElementValue('groupCalculatedParametersHdr')),
            new ParameterSourceWithGroup('winccOaInflux', this.language.getElementValue('winccoaInfluxHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('aggregation', this.language.getElementValue('reportParameterSettingsAggregationHdr'), this.language.getElementValue('groupCalculatedParametersHdr')),
            new ParameterSourceWithGroup('dropdown', this.language.getElementValue('reportParameterSettingsDropdownHdr'), this.language.getElementValue('groupComponentsHdr')),
            new ParameterSourceWithGroup('log', this.language.getElementValue('reportParameterSettingsLogHdr'), this.language.getElementValue('groupComponentsHdr')),
            new ParameterSourceWithGroup('chart', this.language.getElementValue('reportParameterSettingsChartHdr'), this.language.getElementValue('groupComponentsHdr')),
            new ParameterSourceWithGroup('signature', this.language.getElementValue('reportParameterSettingsSignatureHdr'), this.language.getElementValue('groupComponentsHdr')),
            new ParameterSourceWithGroup('dictionary', this.language.getElementValue('reportParameterSettingsDictionaryHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('operationTime', this.language.getElementValue('reportParameterSettingsOperationTimeHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('operationTimeDiagram', this.language.getElementValue('reportParameterSettingsOperationTimeDiagramHdr'), this.language.getElementValue('groupComponentsHdr')),
            new ParameterSourceWithGroup('msSql', this.language.getElementValue('reportParameterDbmsSqLServerHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('mySql', this.language.getElementValue('reportParameterDbmsMysqlHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('influx', this.language.getElementValue('reportParameterDbmsInfluxHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('oracle', this.language.getElementValue('reportParameterDbmsOracleHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('excel', this.language.getElementValue('reportParameterFileExcelHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('specificDate', this.language.getElementValue('dateHdr'), this.language.getElementValue('groupComponentsHdr')),
            new ParameterSourceWithGroup('randomValue', this.language.getElementValue('reportParameterSettingsRandomHdr'), this.language.getElementValue('groupCalculatedParametersHdr')),
            new ParameterSourceWithGroup('navigation', this.language.getElementValue('reportParameterNavigationHdr'), this.language.getElementValue('groupComponentsHdr')),
            new ParameterSourceWithGroup('odbc', 'ODBC', this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('opc', 'OPC', this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('wincc', this.language.getElementValue('winccHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('userNumber', this.language.getElementValue('reportParameterUserNumberHdr'), this.language.getElementValue('groupCalculatedParametersHdr')),
            new ParameterSourceWithGroup('report', this.language.getElementValue('reportParameterSettingsReportHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('piramida', this.language.getElementValue('reportParameterSettingsPiramidaHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('http', 'HTTP', this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('postgreSql', this.language.getElementValue('reportParameterDbmsPostgreSqlHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('oleDb', 'OLE DB', this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup('file', this.language.getElementValue('reportParameterFileTextHdr'), this.language.getElementValue('groupDataSourcesHdr')),
            new ParameterSourceWithGroup(UserFileSettings.UserFileParameterTypeName, this.language.getElementValue('reportParameterUserFileHdr'), this.language.getElementValue('groupDataSourcesHdr'))
        ];
        this.externalConnectionsProvider.hasAlphaPlatformProvider()
            .then(function (hasAlphaPlatformProvider) {
            if (hasAlphaPlatformProvider) {
                TemplateParametersCtrl.parameterSourcesWithGroups.push(new ParameterSourceWithGroup(AlphaSettings.AlphaParameterTypeName, _this.language.getElementValue('reportParameterAlphaPlatformHdr'), _this.language.getElementValue('groupDataSourcesHdr')));
            }
        });
        this.userPreferences = userPreferencesService.getPreferences();
    }
    TemplateParametersCtrl.prototype.changeSorting = function (columnName) {
        if (this.sort.columnName === columnName) {
            this.sort.descending = !this.sort.descending;
        }
        else {
            this.sort.columnName = columnName;
            this.sort.descending = false;
        }
    };
    TemplateParametersCtrl.prototype.onColumnVisibilityChanged = function () {
        this.userPreferencesService.setPreferences(this.userPreferences);
    };
    TemplateParametersCtrl.prototype.setSelectedTemplate = function (template) {
        this.template = template;
    };
    TemplateParametersCtrl.prototype.createParameter = function () {
        this.templateParameterService.createParameter(this.template).then(function () { }, function () { });
    };
    TemplateParametersCtrl.prototype.renameParameter = function (parameter) {
        var _this = this;
        var oldValue = parameter.Ident;
        this.$timeout(function () {
            _this.markupCtrl.renameParameter(oldValue, parameter.Ident);
        });
    };
    TemplateParametersCtrl.prototype.copyParameter = function (parameter) {
        if (_.isUndefined(parameter)) {
            return;
        }
        this.templateParameterService.copyParameter(this.template, parameter);
    };
    TemplateParametersCtrl.prototype.deleteParameter = function (parameter) {
        var _this = this;
        if (_.isUndefined(parameter)) {
            return;
        }
        this.templateParameterService.deleteParameter(this.template, parameter).then(function () {
            _this.markupCtrl.removeParameter(parameter.Ident);
        }, function () { });
    };
    TemplateParametersCtrl.prototype.editParameter = function (template, parameterIdent) {
        var _this = this;
        var parameter = _.find(template.Parameters, function (p) {
            return p.Ident === parameterIdent;
        });
        if (_.isUndefined(parameter)) {
            return;
        }
        this.selectedParameterIdent = parameter.Ident;
        this.templateParameterService.editParameter(template, parameter).then(function (updatedParameter) {
            _this.markupCtrl.renameParameter(_this.selectedParameterIdent, updatedParameter.Ident);
            _this.selectedParameterIdent = updatedParameter.Ident;
        }, function () { });
    };
    return TemplateParametersCtrl;
}());
