var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var ParameterSourceSettingCtrl = (function () {
    function ParameterSourceSettingCtrl(parentScope, rootScope, httpService, userProvider, reportTemplateService, clientSettings, notificationService, modalService, opcConnectionProvider, language, qService, operationTimeParameterProvider, authentication, permissionService, winccOaService, formulaFactory, $timeout, alphaConnectionProvider, reportCompletionsProvider) {
        this.parentScope = parentScope;
        this.rootScope = rootScope;
        this.httpService = httpService;
        this.userProvider = userProvider;
        this.reportTemplateService = reportTemplateService;
        this.clientSettings = clientSettings;
        this.notificationService = notificationService;
        this.modalService = modalService;
        this.opcConnectionProvider = opcConnectionProvider;
        this.language = language;
        this.qService = qService;
        this.operationTimeParameterProvider = operationTimeParameterProvider;
        this.authentication = authentication;
        this.winccOaService = winccOaService;
        this.formulaFactory = formulaFactory;
        this.$timeout = $timeout;
        this.alphaConnectionProvider = alphaConnectionProvider;
        this.parameterNameIsCorrect = true;
        this.watchFunctions = [];
        this.parameterSettingDisplayMode = 'settings';
        this.sources = [];
        this.timestamps = [];
        this.reportStartTimestamp = new UiSelectItem('StartDate', this.language.getElementValue('reportTimestampsStartDateHdr'));
        this.reportEndTimestamp = new UiSelectItem('EndDate', this.language.getElementValue('reportTimestampsEndDateHdr'));
        this.stepStartTimestamp = new UiSelectItem('StepStart', this.language.getElementValue('stepStartHdr'));
        this.stepEndTimestamp = new UiSelectItem('StepEnd', this.language.getElementValue('stepEndHdr'));
        this.orientations = [];
        this.viewModes = [];
        this.formulaCtrl = new ParameterFormulaCtrl(parentScope, httpService, clientSettings, notificationService, modalService, language, reportCompletionsProvider);
        this.permissions = permissionService.getAll();
    }
    ParameterSourceSettingCtrl.prototype.init = function () {
        var _this = this;
        var _a, _b;
        _.forEach(TemplateParametersCtrl.parameterSourcesWithGroups, function (sourceWithGroup) {
            switch (sourceWithGroup.ident) {
                case 'winccoa':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new WinccoaSettingsCtrl(_this.parentScope, _this.language, _this.modalService, _this.winccOaService, _this.notificationService)));
                    break;
                case 'calc':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new CalcSettingsCtrl(_this.parentScope)));
                    break;
                case 'aggregation':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new AggregationSettingsCtrl(_this.parentScope, _this.language)));
                    break;
                case 'dropdown':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new DropdownSettingsCtrl(_this.parentScope, _this.notificationService, _this.language, _this.httpService, _this.clientSettings, _this.authentication)));
                    break;
                case 'log':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new LogSettingsCtrl(_this.parentScope, _this.modalService, _this.language, _this.notificationService)));
                    break;
                case 'chart':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new ChartSettingsCtrl(_this.parentScope, _this.language, _this.modalService, _this.formulaFactory)));
                    break;
                case 'signature':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new SignatureSettingsCtrl(_this.parentScope, _this.userProvider, _this.notificationService, _this.language)));
                    break;
                case 'piramida':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new PiramidaSettingsCtrl(_this.parentScope, _this.language)));
                    break;
                case 'dictionary':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new DictionarySettinsCtrl(_this.parentScope, _this.httpService, _this.clientSettings, _this.notificationService, _this.language, _this.qService, _this.authentication)));
                    break;
                case 'operationTime':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new OperationTimeSettingsCtrl(_this.parentScope, _this.operationTimeParameterProvider, _this.language, _this.notificationService)));
                    break;
                case 'operationTimeDiagram':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new OperationTimeDiagramSettingsCtrl(_this.parentScope, _this.operationTimeParameterProvider, _this.language, _this.notificationService)));
                    break;
                case 'msSql':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new MsSqlSettingsCtrl(_this.codeEditor, _this.modalService, _this.parentScope, _this.language)));
                    break;
                case 'mySql':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new MySqlSettingsCtrl(_this.codeEditor, _this.modalService, _this.parentScope, _this.language)));
                    break;
                case 'influx':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new InfluxSettingsCtrl(_this.codeEditor, _this.modalService, _this.parentScope, _this.language)));
                    break;
                case 'oracle':
                    _this.httpService.get(_this.clientSettings.getServerInstance() + '/ExternalConnections/HasOracleProvider')
                        .then(function (response) {
                        if (response.data) {
                            _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new OracleSettingsCtrl(_this.codeEditor, _this.modalService, _this.parentScope, _this.language)));
                        }
                    })
                        .catch(function (error) {
                        _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
                    });
                    break;
                case 'excel':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new ExcelSettingsCtrl(_this.parentScope, _this.language)));
                    break;
                case 'specificDate':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new SpecificDateSettingsCtrl(_this.parentScope, _this.language)));
                    break;
                case 'randomValue':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new RandomSettingsCtrl(_this.parentScope)));
                    break;
                case 'navigation':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new NavigationSettingsCtrl(_this.httpService, _this.clientSettings, _this.parentScope, _this.reportTemplateService, _this.notificationService, _this.language)));
                    break;
                case 'odbc':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new OdbcSettingsCtrl(_this.parentScope, _this.language)));
                    break;
                case 'opc':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new OpcSettingsCtrl(_this.parentScope, _this.modalService, _this.notificationService, _this.opcConnectionProvider, _this.language)));
                    break;
                case 'wincc':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new WinccSettingsCtrl(_this.parentScope, _this.language)));
                    break;
                case 'userNumber':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new UserNumberSettingsCtrl(_this.parentScope)));
                    break;
                case 'report':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new ReportLinkSettingsCtrl(_this.parentScope, _this.language, _this.reportTemplateService, _this.httpService, _this.clientSettings, _this.qService, _this.notificationService)));
                    break;
                case 'http':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new HttpSettingsCtrl(_this.parentScope)));
                    break;
                case 'winccOaInflux':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new WinccOaInfluxSettingsCtrl(_this.parentScope, _this.language)));
                    break;
                case 'postgreSql':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new PostgreSqlSettingsCtrl(_this.codeEditor, _this.modalService, _this.parentScope, _this.language)));
                    break;
                case 'oleDb':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new OleDbSettingsCtrl(_this.parentScope, _this.language)));
                    break;
                case 'file':
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new FileSettingsCtrl(_this.parentScope)));
                    break;
                case UserFileSettings.UserFileParameterTypeName:
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new UserFileSettingsCtrl(_this.parentScope)));
                    break;
                case AlphaSettings.AlphaParameterTypeName:
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, new AlphaSettingsCtrl(_this.parentScope, _this.modalService, _this.alphaConnectionProvider, _this.notificationService, _this.language)));
                    break;
                default:
                    _this.sources.push(new UiSelectReportParameterSource(sourceWithGroup, null));
                    break;
            }
        });
        this.sources.selected = _.find(this.sources, function (i) {
            return i.ident === _this.parentScope.param.Source;
        });
        this.sourceCtrl = this.sources.selected.ctrl;
        this.timestamps = __spreadArray([
            { name: this.language.getElementValue('reportTimestampsStartDateHdr'), ident: 0 },
            { name: this.language.getElementValue('reportTimestampsEndDateHdr'), ident: 1 }
        ], this.parentScope.reportTemplate.ReportType === 1 && this.parentScope.reportTemplate.HasStep
            ? [
                { name: this.language.getElementValue('reportTimestampsStepStartHdr'), ident: 2 },
                { name: this.language.getElementValue('reportTimestampsStepEndHdr'), ident: 3 },
            ]
            : [], true);
        this.orientations = [
            { name: this.language.getElementValue('reportParameterCopyOrientationVerticalHdr'), ident: 0 },
            { name: this.language.getElementValue('reportParameterCopyOrientationHorizontalHdr'), ident: 1 },
        ];
        this.viewModes = [
            { name: this.language.getElementValue('reportParameterDropdownStandardViewMode'), ident: 0 },
            { name: this.language.getElementValue('reportParameterDropdownLightweightViewMode'), ident: 1 },
        ];
        this.timestamp = (_a = _.find(this.timestamps, function (timestamp) { return timestamp.ident === _this.parentScope.param.Timestamp; })) !== null && _a !== void 0 ? _a : this.timestamps[0];
        this.orientation = (_b = _.find(this.orientations, function (orientation) { return orientation.ident === _this.parentScope.param.CopyOrientation; })) !== null && _b !== void 0 ? _b : this.orientations[0];
        this.viewMode = this.viewModes[0];
        this.formulaCtrl.init();
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.sources.selected;
        }, function (after, before, scope) {
            var _a;
            if (after === before) {
                return;
            }
            (_a = before === null || before === void 0 ? void 0 : before.ctrl) === null || _a === void 0 ? void 0 : _a.destroy();
            scope.param.setSource(after.ident, _this.parentScope.reportTemplate.UniqueGuid, _this.parentScope.reportTemplate.ReportType, _this.parentScope.reportTemplate.HasStep, _this.language, _this.parameterSettingDisplayMode === 'settings');
            _this.updateParameterTimestamps();
            _this.sourceCtrl = after.ctrl;
            after.ctrl.init();
            _this.parameterSettingDisplayMode = after.ident === 'calc'
                ? 'formula'
                : 'settings';
        }));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.Ident;
        }, function (after, before) {
            if (after === before)
                return;
            if (!after) {
                _this.parameterNameIsCorrect = false;
            }
            else if (after.search(/\s{2,}/g) !== -1 && _this.parameterNameIsCorrect) {
                _this.parameterNameIsCorrect = false;
                _this.notificationService.warnMessage(_this.language.getElementValue('dublicateSpacesMessage'));
            }
            else if (after.search(/\s{2,}/g) === -1 && !_this.parameterNameIsCorrect) {
                _this.parameterNameIsCorrect = true;
            }
        }));
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return _this.parentScope.param.Predefined;
        }, function (after, before) {
            if (after === before)
                return;
            if (after) {
                _this.parentScope.param.Editable = false;
            }
        }));
        this.sources.selected.ctrl.init();
    };
    ParameterSourceSettingCtrl.prototype.onTimestampChanged = function () {
        this.parentScope.param.Timestamp = this.timestamp.ident;
        this.parentScope.param.CopyOrientation = this.orientation.ident;
        this.formulaCtrl.setFormula(this.sourceCtrl.getFormula());
    };
    ParameterSourceSettingCtrl.prototype.getTimestamps = function () {
        var standardGroup = this.language.getElementValue('reportTimestampStandardGroupHdr');
        var tenplateGroup = this.language.getElementValue('reportTimestampTemplateGroupHdr');
        var timestamps = Number(this.parentScope.reportTemplate.ReportType) === 1
            && this.parentScope.reportTemplate.HasStep
            ? [
                new UiSelectGroup(new ParameterSourceWithGroup(this.reportStartTimestamp.ident, this.reportStartTimestamp.name, standardGroup)),
                new UiSelectGroup(new ParameterSourceWithGroup(this.reportEndTimestamp.ident, this.reportEndTimestamp.name, standardGroup)),
                new UiSelectGroup(new ParameterSourceWithGroup(this.stepStartTimestamp.ident, this.stepStartTimestamp.name, standardGroup)),
                new UiSelectGroup(new ParameterSourceWithGroup(this.stepEndTimestamp.ident, this.stepEndTimestamp.name, standardGroup)),
                new UiSelectGroup(new ParameterSourceWithGroup('ReportCreationDate', this.language.getElementValue('reportDataCreateDateHdr'), standardGroup)),
                new UiSelectGroup(new ParameterSourceWithGroup('ReportUpdateDate', this.language.getElementValue('reportDataUpdateHdr'), standardGroup)),
            ]
            : [
                new UiSelectGroup(new ParameterSourceWithGroup(this.reportStartTimestamp.ident, this.reportStartTimestamp.name, standardGroup)),
                new UiSelectGroup(new ParameterSourceWithGroup(this.reportEndTimestamp.ident, this.reportEndTimestamp.name, standardGroup)),
                new UiSelectGroup(new ParameterSourceWithGroup('ReportCreationDate', this.language.getElementValue('reportDataCreateDateHdr'), standardGroup)),
                new UiSelectGroup(new ParameterSourceWithGroup('ReportUpdateDate', this.language.getElementValue('reportDataUpdateHdr'), standardGroup)),
            ];
        var dateTimeParameters = _.where(this.parentScope.reportTemplate.Parameters, function (p) {
            return !_.isUndefined(p.ParameterType) && (p.ParameterType === 'DateTime' || p.Source === 'specificDate');
        });
        timestamps = timestamps.concat(_.map(dateTimeParameters, function (p) {
            return new UiSelectGroup(new ParameterSourceWithGroup("%".concat(p.Ident, "%"), p.Ident, tenplateGroup));
        }));
        timestamps = timestamps.concat([
            new UiSelectGroup(new ParameterSourceWithGroup('ReportDay', this.language.getElementValue('reportTimestampsBeginDayHdr'), standardGroup)),
            new UiSelectGroup(new ParameterSourceWithGroup('ReportWeek', this.language.getElementValue('reportTimestampsBeginWeekHdr'), standardGroup)),
            new UiSelectGroup(new ParameterSourceWithGroup('ReportMonth', this.language.getElementValue('reportTimestampsBeginMonthHdr'), standardGroup)),
            new UiSelectGroup(new ParameterSourceWithGroup('ReportYear', this.language.getElementValue('reportTimestampsBeginYearHdr'), standardGroup)),
        ]);
        return timestamps;
    };
    ParameterSourceSettingCtrl.prototype.getStartTimestamp = function () {
        return this.parentScope.reportTemplate.HasStep
            ? this.stepStartTimestamp
            : this.reportStartTimestamp;
    };
    ParameterSourceSettingCtrl.prototype.getEndTimestamp = function () {
        return this.parentScope.reportTemplate.HasStep
            ? this.stepEndTimestamp
            : this.reportEndTimestamp;
    };
    ParameterSourceSettingCtrl.prototype.isAnyDisplaySettings = function () {
        return this.formulaCtrl.isSplittable
            || this.parentScope.param.Source === 'dropdown'
            || this.parentScope.param.ParameterType === 'string'
            || this.formulaCtrl.isRounded
            || this.isPeriodicReport();
    };
    ParameterSourceSettingCtrl.prototype.isIncorrectParameterName = function () {
        return !this.parameterNameIsCorrect;
    };
    ParameterSourceSettingCtrl.prototype.isStepParameter = function () {
        return this.timestamp.ident === 3
            || this.timestamp.ident === 2;
    };
    ParameterSourceSettingCtrl.prototype.isPeriodicReport = function () {
        return this.parentScope.reportTemplate.ReportType === 1;
    };
    ParameterSourceSettingCtrl.prototype.switchTab = function (tab) {
        var _this = this;
        this.parameterSettingDisplayMode = tab;
        this.$timeout(function () {
            _this.formulaCtrl.codeEditor.renderer.updateFull(true);
            _this.formulaCtrl.codeEditor.focus();
        }, 0);
    };
    ParameterSourceSettingCtrl.prototype.onCopyOrientationChanged = function () {
        this.parentScope.param.CopyOrientation = this.orientation.ident;
    };
    ParameterSourceSettingCtrl.prototype.onViewModeChanged = function () {
        this.parentScope.param.Dropdown.viewMode = this.viewMode.ident;
    };
    ParameterSourceSettingCtrl.prototype.destroy = function () {
        this.sourceCtrl = undefined;
        this.sources.selected.ctrl.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
        this.formulaCtrl.destroy();
        this.parentScope = undefined;
    };
    ParameterSourceSettingCtrl.prototype.updateParameterTimestamps = function () {
        var _this = this;
        var _a;
        this.timestamps = [
            { name: this.language.getElementValue('reportTimestampsStartDateHdr'), ident: 0 },
            { name: this.language.getElementValue('reportTimestampsEndDateHdr'), ident: 1 },
        ];
        if (this.parentScope.reportTemplate.ReportType === 1 && this.parentScope.reportTemplate.HasStep) {
            this.timestamps = __spreadArray(__spreadArray([], this.timestamps, true), [{ name: this.language.getElementValue('reportTimestampsStepStartHdr'), ident: 2 },
                { name: this.language.getElementValue('reportTimestampsStepEndHdr'), ident: 3 },], false);
        }
        this.timestamp = (_a = _.find(this.timestamps, function (timestamp) { return timestamp.ident === _this.parentScope.param.Timestamp; })) !== null && _a !== void 0 ? _a : this.timestamps[0];
    };
    return ParameterSourceSettingCtrl;
}());
var UiSelectGroup = (function (_super) {
    __extends(UiSelectGroup, _super);
    function UiSelectGroup(sourceWithGroup) {
        var _this = _super.call(this, sourceWithGroup.ident, sourceWithGroup.name) || this;
        _this.group = sourceWithGroup.group;
        return _this;
    }
    return UiSelectGroup;
}(UiSelectItem));
