var ParameterFormulaCtrl = (function () {
    function ParameterFormulaCtrl(parentScope, httpService, clientSettings, notificationService, modal, language, reportCompletionsProvider) {
        this.parentScope = parentScope;
        this.httpService = httpService;
        this.clientSettings = clientSettings;
        this.notificationService = notificationService;
        this.modal = modal;
        this.language = language;
        this.reportCompletionsProvider = reportCompletionsProvider;
        this.watchFunctions = [];
        this.timestamps = [
            { text: this.language.getElementValue('timeStampHdr'), value: 'Timestamp' },
            { text: this.language.getElementValue('stepStartHdr'), value: 'StepStart' },
            { text: this.language.getElementValue('stepEndHdr'), value: 'StepEnd' },
            { text: this.language.getElementValue('reportTimestampsStartDateHdr'), value: 'StartDate' },
            { text: this.language.getElementValue('reportTimestampsEndDateHdr'), value: 'EndDate' },
            { text: this.language.getElementValue('reportDataCreateDateHdr'), value: 'ReportCreationDate' },
            { text: this.language.getElementValue('reportDataUpdateHdr'), value: 'ReportUpdateDate' }
        ];
    }
    ParameterFormulaCtrl.prototype.checkRoundness = function (parameter) {
        return (parameter.ParameterType === 'double' ||
            parameter.ParameterType === 'double?' ||
            parameter.ParameterType === 'AggregationValue' ||
            parameter.ParameterType === 'WinccOaValue' ||
            parameter.ParameterType === 'OpcValue' ||
            parameter.ParameterType === 'PiramidaValue' ||
            parameter.ParameterType === 'AlphaValue');
    };
    ParameterFormulaCtrl.prototype.checkSplittable = function (parameter) {
        return (parameter.ParameterType === 'double' ||
            parameter.ParameterType === 'double?' ||
            parameter.ParameterType === 'int' ||
            parameter.ParameterType === 'AggregationValue' ||
            parameter.ParameterType === 'WinccOaValue' ||
            parameter.ParameterType === 'PiramidaValue' ||
            parameter.ParameterType === 'OpcValue' ||
            parameter.ParameterType === 'AlphaValue' ||
            parameter.ParameterType === 'StoredReportValue');
    };
    ParameterFormulaCtrl.prototype.switchFullScreen = function () {
        angular.element('.report-parameter-edit-modal-window .modal-dialog')[0].style.marginLeft = this.isCodeEditorFullScreen
            ? 'auto'
            : '0';
        this.isCodeEditorFullScreen = !this.isCodeEditorFullScreen;
    };
    ParameterFormulaCtrl.prototype.onCodeEditorInitialized = function (codeEditor) {
        this.codeEditor = codeEditor;
        this.codeEditor.focus();
    };
    ParameterFormulaCtrl.prototype.onCodeEditorChange = function () {
        if (_.isUndefined(this.parentScope.param)) {
            return;
        }
        if (this.parentScope.settingsCtrl.sources.selected.ident !== 'calc') {
            this.parentScope.settingsCtrl.sources.selected = this.parentScope.getSelectedItem(this.parentScope.settingsCtrl.sources, 'calc');
        }
    };
    ParameterFormulaCtrl.prototype.init = function () {
        var _this = this;
        this.resultTypes = getVariantsExtendableContainer(this.parentScope, [
            new UiSelectItem('double', this.language.getElementValue('reportParameterTypeDoubleHdr')),
            new UiSelectItem('double?', this.language.getElementValue('reportParameterTypeDoubleNullableHdr')),
            new UiSelectItem('int', this.language.getElementValue('reportParameterTypeIntegerHdr')),
            new UiSelectItem('string', this.language.getElementValue('reportParameterTypeStringHdr')),
            new UiSelectItem('DateTime', this.language.getElementValue('dateHdr')),
            new UiSelectItem('TimeSpan', this.language.getElementValue('reportParameterTypeTimeSpanHdr')),
            new UiSelectItem('ReportTable', this.language.getElementValue('reportParameterTypeTableHdr')),
            new UiSelectItem('ReportTable[]', this.language.getElementValue('reportParameterTypeTablesHdr')),
            new UiSelectItem('WinccOaAlarmsTable', this.language.getElementValue('reportParameterTypeWinccOaAlarmsTableHdr')),
            new UiSelectItem('JArray', this.language.getElementValue('reportParameterTypeArrayHdr')),
            new UiSelectItem('LogRow[]', this.language.getElementValue('reportParameterTypeLogDataHdr')),
            new UiSelectItem('WinccValue', this.language.getElementValue('reportParameterTypeValueWinCcHdr')),
            new UiSelectItem('WinccOaValue', this.language.getElementValue('reportParameterTypeValueWinCcOaHdr')),
            new UiSelectItem('AggregationValue', this.language.getElementValue('reportParameterTypeAggregationValueHdr')),
            new UiSelectItem('PiramidaValue', this.language.getElementValue('reportParameterTypePiramidaValueHdr')),
            new UiSelectItem('PiramidaDiscretState', this.language.getElementValue('reportParameterTypePiramidaDiscretStateHdr')),
            new UiSelectItem('OpcValue', this.language.getElementValue('reportParameterTypeValueOpcHdr')),
            new UiSelectItem('LinkValue', this.language.getElementValue('reportParameterNavigationHdr')),
            new UiSelectItem('WinccOaAlarm[]', this.language.getElementValue('reportParameterTypeListAlarmsWinCcHdr')),
            new UiSelectItem('XmlValue', this.language.getElementValue('reportParameterTypeXmlDocumentHdr')),
            new UiSelectItem('JsValue', this.language.getElementValue('reportParameterTypeJsValueHdr')),
            new UiSelectItem('ReportChartValue', this.language.getElementValue('reportParameterTypeReportChartValueHdr')),
            new UiSelectItem('DictionaryClassInstance[]', this.language.getElementValue('reportParameterTypeArrayCimModelClassesHdr')),
            new UiSelectItem('double[]', this.language.getElementValue('reportParameterTypeArrayDoubleHdr')),
            new UiSelectItem('double[][]', this.language.getElementValue('reportParameterTypeTableDoubleHdr')),
            new UiSelectItem('double[][][]', this.language.getElementValue('reportParameterTypeTablesDoubleHdr')),
            new UiSelectItem('int[]', this.language.getElementValue('reportParameterTypeArrayIntHdr')),
            new UiSelectItem('int[][]', this.language.getElementValue('reportParameterTypeTableIntHdr')),
            new UiSelectItem('string[]', this.language.getElementValue('reportParameterTypeArrayStringHdr')),
            new UiSelectItem('string[][]', this.language.getElementValue('reportParameterTypeTableStringHdr')),
            new UiSelectItem('string[][][]', this.language.getElementValue('reportParameterTypeTablesStringHdr')),
            new UiSelectItem('object[]', this.language.getElementValue('reportParameterTypeArrayObjectHdr')),
            new UiSelectItem('object[][]', this.language.getElementValue('reportParameterTypeTableObjectHdr')),
            new UiSelectItem('Boolean', this.language.getElementValue('reportParameterTypeBoolHdr')),
            new UiSelectItem('WinccValue[]', this.language.getElementValue('reportParameterTypeWinCcValueTableHdr')),
            new UiSelectItem('OperationTimeParameterLog', this.language.getElementValue('reportParameterTypeOTDeviceLogArrayHdr')),
            new UiSelectItem('StoredReportValue', this.language.getElementValue('reportParameterTypeStoredReportValueHdr')),
            new UiSelectItem('StoredReportValue[]', this.language.getElementValue('reportParameterTypeStoredReportValueArrayHdr')),
            new UiSelectItem('DropDownValue', this.language.getElementValue('reportParameterTypeDropDownListHdr')),
            new UiSelectItem(UserFileSettings.UserFileReturnValueTypeName, this.language.getElementValue('reportParameterTypeFileValueHdr')),
            new UiSelectItem(AlphaSettings.AlphaReturnValueTypeName, this.language.getElementValue('reportParameterTypeValueAlphaHdr')),
        ], function () {
            return _this.parentScope.param.ParameterType;
        }, function (after, before) {
            var _a;
            if (after === before)
                return;
            _this.parentScope.param.ParameterType = after.ident;
            _this.isSplittable = _this.checkSplittable(_this.parentScope.param);
            _this.isRounded = _this.checkRoundness(_this.parentScope.param);
            (_a = _this.parentScope.param).Predefined && (_a.Predefined = _this.parentScope.param.canPredefined());
        });
        this.isSplittable = this.checkSplittable(this.parentScope.param);
        this.isRounded = this.checkRoundness(this.parentScope.param);
        this.reportCompletionsProvider.getCompletions()
            .then(function (completions) {
            var parameterCompletions = _.map(_.filter(_this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident != _this.parentScope.param.Ident; }), function (parameter) { return ({
                caption: "".concat(parameter.Ident),
                value: "%".concat(parameter.Ident, "%"),
                meta: 'parameter'
            }); });
            _this.completions = completions.concat(parameterCompletions);
        })
            .catch(function (error) {
            _this.completions = [];
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ParameterFormulaCtrl.prototype.setFormula = function (formula) {
        this.parentScope.param.Formula = formula;
    };
    ParameterFormulaCtrl.prototype.setResultType = function (type) {
        var item = _.find(this.resultTypes, function (i) {
            return i.ident === type;
        });
        this.resultTypes.selected = item !== null && item !== void 0 ? item : new UiSelectItem(type, type);
        this.parentScope.param.ParameterType = type;
    };
    ParameterFormulaCtrl.prototype.isFormulaValid = function () {
        var _this = this;
        this.parentScope.param.Formula = this.codeEditor.getValue();
        var parameters = JSON.parse(JSON.stringify(this.parentScope.reportTemplate.Parameters));
        var currentParamterIdx = _.findIndex(parameters, function (parameter) { return parameter.Ident === _this.parentScope.param.Ident; });
        if (currentParamterIdx < 0) {
            parameters.push(this.parentScope.param);
        }
        else {
            parameters[currentParamterIdx] = this.parentScope.param;
        }
        this.httpService
            .post(this.clientSettings.getServerInstance() + '/ReportTemplate/IsFormulaValid', {
            templateName: this.parentScope.reportTemplate.Name,
            parameters: parameters,
            verificationParameterIdent: this.parentScope.param.Ident,
        })
            .then(function (response) {
            if (_.isEmpty(response.data.errors)) {
                _this.codeEditor.getSession().clearAnnotations();
                _this.notificationService.showMessage(_this.language.getElementValue('reportErrorNotFoundMsg'));
            }
            else {
                _this.codeEditor.getSession().clearAnnotations();
                var errorGroups = _.groupBy(response.data.errors, function (error) { return error.line; });
                var annotationArray = Object.entries(errorGroups).map(function (_a) {
                    var _ = _a[0], errors = _a[1];
                    return errors.map(function (error) {
                        return ({
                            row: error.line,
                            text: _this.language.getElementValue('errorsHdr') + ':\n' +
                                errors
                                    .map(function (errorLine) { return "".concat(errorLine.errorNumber, ": ").concat(errorLine.errorText); })
                                    .reduce(function (memo, text) { return memo + '\n' + text; }, '')
                                    .trim()
                                    .slice(0, 500) + ' ...',
                            type: 'error',
                        });
                    });
                });
                if (!_.isEmpty(annotationArray)) {
                    _this.codeEditor.scrollToLine(annotationArray[0][0].row, true, false, function () { });
                }
                _this.codeEditor.getSession().setAnnotations(_.flatten(annotationArray));
                _this.notificationService.warnMessage(_this.language.getElementValue('reportErrorCalculationParameterMsg'));
            }
        }, function (response) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), response.data);
        });
    };
    ParameterFormulaCtrl.prototype.insertTimestamp = function () {
        var _this = this;
        this.modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/TimestampSelectModal/TimestampSelectModal.html',
            controller: 'TimestampSelectModalController',
            backdrop: 'static',
            windowClass: 'app-modal-window',
            resolve: {
                timestamps: function () {
                    return _this.timestamps;
                },
                isFormattingEnabled: function () {
                    return false;
                }
            }
        }).result.then(function (selectedTimestamp) {
            _this.codeEditor.insert(selectedTimestamp);
            _this.codeEditor.focus();
        }, function () { });
    };
    ParameterFormulaCtrl.prototype.insertParamAddress = function () {
        var _this = this;
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterSelectModal.html',
            controller: 'parameterSelectModalCtrl',
            backdrop: 'static',
            windowClass: 'app-modal-window',
            resolve: {
                parameters: function () {
                    return _.filter(_this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident !== _this.parentScope.param.Ident; });
                }
            }
        });
        modalInstance.result.then(function (parameter) {
            _this.codeEditor.insert("%".concat(parameter.Ident, "%"));
            _this.codeEditor.focus();
        }, function () { });
    };
    ParameterFormulaCtrl.prototype.insertFormula = function () {
        var _this = this;
        this.modal.open({
            templateUrl: 'ng1/dist/src/UserDocuments/ReportFormulas/ReportFormulaSelectModal/ReportFormulaSelectModal.html',
            controller: 'reportFormulaSelectModalCtrl',
            backdrop: 'static',
            windowClass: 'app-modal-window',
            resolve: {
                resultTypes: function () { return _this.resultTypes; },
                currentFormulaName: function () { return null; }
            }
        }).result.then(function (selectedFormula) {
            var parametersString = _.map(selectedFormula.parameters, function (p, i) { return p.name; }).join(', ');
            _this.codeEditor.insert(selectedFormula.name + "(".concat(parametersString, ")"));
            _this.codeEditor.focus();
        }, function () { });
    };
    ParameterFormulaCtrl.prototype.destroy = function () {
        this.codeEditor.getSession().removeAllListeners('change');
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
        this.resultTypes.destroy();
        this.parentScope = undefined;
    };
    return ParameterFormulaCtrl;
}());
