var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ReportParameterBacklightExt = (function (_super) {
    __extends(ReportParameterBacklightExt, _super);
    function ReportParameterBacklightExt(parentScope, backlightItem, language) {
        var _this = _super.call(this) || this;
        _this.singleValueConditionTypes = [
            0,
            1,
            2,
            3,
        ];
        _this.rangeValueConditionTypes = [
            4,
            5,
        ];
        var self = _this;
        _this.language = language;
        _this.parameterIdent = backlightItem.parameterIdent;
        _this.condition = backlightItem.condition;
        _this.conditionType = backlightItem.conditionType;
        _this.colorHex = backlightItem.colorHex;
        _this.isOpen = false;
        _this.nameInputVisible = false;
        var isSimpleParameterType = parentScope.param.ParameterType === 'WinccOaValue' ||
            parentScope.param.ParameterType === 'OpcValue' ||
            parentScope.param.ParameterType === 'AlphaValue' ||
            parentScope.param.ParameterType === 'double' ||
            parentScope.param.ParameterType === 'int' ||
            parentScope.param.ParameterType === 'int?' ||
            parentScope.param.ParameterType === 'double?';
        var typesUiSelectItems;
        if (isSimpleParameterType) {
            typesUiSelectItems = [
                new UiSelectItem(0, _this.language.getElementValue('parameterBacklightItsValueHdr')),
                new UiSelectItem(1, _this.language.getElementValue('valueParameterHdr')),
            ];
        }
        else {
            typesUiSelectItems = [new UiSelectItem(1, _this.language.getElementValue('valueParameterHdr'))];
            _this.conditionType = 1;
        }
        _this.types = getVariantsContainer(parentScope, typesUiSelectItems, function (t) {
            return t.ident === _this.conditionType;
        }, function (after, before) {
            if (before === after) {
                return;
            }
            _this.conditionType = after.ident;
            _this.reportParameters.selected = undefined;
            self.comparators.selected = _this.comparators[1];
        });
        _this.comparators = getVariantsContainer(parentScope, [
            new UiSelectItem(0, _this.language.getElementValue('moreHdr')),
            new UiSelectItem(1, _this.language.getElementValue('equalHdr')),
            new UiSelectItem(2, _this.language.getElementValue('notEqualHdr')),
            new UiSelectItem(3, _this.language.getElementValue('lessHdr')),
            new UiSelectItem(4, _this.language.getElementValue('inIntervalHdr')),
            new UiSelectItem(5, _this.language.getElementValue('outIntervalHdr')),
        ], function (t) {
            return t.ident === _this.condition.comparator;
        }, function (after, before) {
            if (before === after) {
                return;
            }
            if (_.contains(self.rangeValueConditionTypes, after.ident)) {
                if (_.isUndefined(self.condition.left)) {
                    self.condition.left = 0;
                }
            }
            if (_.contains(self.singleValueConditionTypes, after.ident)) {
                if (_.isDefined(self.condition.left)) {
                    self.condition.left = undefined;
                }
            }
            _this.condition.comparator = after.ident;
        });
        var filteredParameters = _.filter(parentScope.reportTemplate.Parameters, function (i) {
            return (i.Ident !== parentScope.param.Ident &&
                (i.ParameterType === 'WinccOaValue' ||
                    i.ParameterType === 'OpcValue' ||
                    i.ParameterType === 'AlphaValue' ||
                    i.ParameterType === 'double' ||
                    i.ParameterType === 'int' ||
                    i.ParameterType === 'Boolean'));
        });
        _this.reportParameters = getVariantsContainer(parentScope, _.map(filteredParameters, function (parameter) {
            return new UiSelectItem(parameter.Ident, parameter.Source);
        }), function (t) {
            return t.ident === _this.parameterIdent;
        }, function (after, before) {
            if (before === after || _.isUndefined(after))
                return;
            _this.parameterIdent = after.ident;
        });
        _this.destroy = function () {
            _this.reportParameters.destroy();
            _this.comparators.destroy();
            _this.types.destroy();
        };
        return _this;
    }
    ReportParameterBacklightExt.prototype.keyPressEnter = function (event) {
        if (event.which === 13) {
            this.nameInputVisible = false;
            event.preventDefault();
        }
    };
    return ReportParameterBacklightExt;
}(ReportParameterBacklight));
