var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
var ChartSettingsCtrl = (function () {
    function ChartSettingsCtrl(parentScope, language, modalService, formulaFactory) {
        this.parentScope = parentScope;
        this.language = language;
        this.modalService = modalService;
        this.formulaFactory = formulaFactory;
        this.colors = [
            'rgb(52, 86, 139)',
            'rgb(255, 111, 97)',
            'rgb(107, 91, 149)',
            'rgb(146, 168, 209)',
            'rgb(195, 68, 122)',
            'rgb(127, 205, 205)',
            'rgb(225, 93, 68)',
            'rgb(223, 207, 190)',
            'rgb(155, 35, 53)',
            'rgb(91, 94, 166)',
            'rgb(136, 176, 75)',
            'rgb(239, 192, 80)',
            'rgb(69, 184, 172)',
            'rgb(221, 65, 36)',
            'rgb(0, 155, 119)',
            'rgb(181, 101, 167)',
            'rgb(149, 82, 81)',
            'rgb(218, 247, 166)',
            'rgb(255, 195, 0)',
            'rgb(255, 87, 51)'
        ];
        this.chartTypes = [
            {
                type: 0,
                value: 'line',
                text: this.language.getElementValue('reportChartLineHdr')
            },
            {
                type: 1,
                value: 'column',
                text: this.language.getElementValue('reportChartTypeColumHdr')
            },
            {
                type: 2,
                value: 'column',
                text: this.language.getElementValue('reportChartTypeStackHdr')
            },
            {
                type: 3,
                value: 'pie',
                text: this.language.getElementValue('reportChartTypePieHdr')
            }
        ];
        this.chartLegendPositions = [
            {
                legendPosition: 0,
                text: this.language.getElementValue('reportChartLegendPositionNoneHdr')
            },
            {
                legendPosition: 1,
                text: this.language.getElementValue('reportChartLegendPositionBottomHdr')
            },
            {
                legendPosition: 2,
                text: this.language.getElementValue('reportChartLegendPositionTopHdr')
            },
            {
                legendPosition: 3,
                text: this.language.getElementValue('reportChartLegendPositionLeftHdr')
            },
            {
                legendPosition: 4,
                text: this.language.getElementValue('reportChartLegendPositionRightHdr')
            }
        ];
        this.chartAxisXModes = [
            {
                mode: 0,
                text: this.language.getElementValue('reportChartAxisXModeAutoHdr')
            },
            {
                mode: 1,
                text: this.language.getElementValue('reportChartAxisXModeCustomArrayHdr')
            }
        ];
        this.availableAxisXParameters = [];
        this.availableAxisXAutoDateTimeParameterIdents = [];
        this.availableAxisXNumericParameterIdents = [];
        this.availableSeriesParameters = [];
        this.availablePlotLineParameters = [];
        this.availablePieChartParameters = [];
        this.selectedSeriesParameters = [];
        this.selectedPlotLineParameters = [];
        this.selectedPieChartParameters = [];
    }
    ChartSettingsCtrl.prototype.changeChartType = function () {
        this.parentScope.param.Chart.Type = this.selectedChartType.type;
        this.updateUI();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.changeLegendPosition = function () {
        this.parentScope.param.Chart.LegendPosition = this.selectedLegendPosition.legendPosition;
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.changeAxisXMode = function () {
        this.parentScope.param.Chart.AxisX.mode = this.selectedChartAxisXMode.mode;
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.changeAxisXParameter = function () {
        var _a;
        this.parentScope.param.Chart.AxisX.custom.parameterIdent = (_a = this.selectedAxisXParameter) === null || _a === void 0 ? void 0 : _a.Ident;
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.changeSeries = function (parameterIdent, index) {
        this.parentScope.param.Chart.Series[index].parameterIdent = parameterIdent;
        this.updateSeriesParameters();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.changePlotLine = function (parameterIdent, index) {
        this.parentScope.param.Chart.PlotLines[index].parameterIdent = parameterIdent;
        this.updateSeriesParameters();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.changeColor = function (series) {
        if (_.isDefined(series.callout)) {
            series.callout.color = series.color;
        }
        if (_.isDefined(series.marker)) {
            series.marker.color = series.color;
        }
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.updateSeriesParameters = function () {
        var _this = this;
        if (this.isPieChart()) {
            this.parentScope.param.Chart.Series = _.filter(this.parentScope.param.Chart.Series, function (series) {
                var _a;
                return _.contains(ChartParameterTypes.digitalTypes, (_a = _.find(_this.parentScope.reportTemplate.Parameters, function (p) { return p.Ident === (series === null || series === void 0 ? void 0 : series.parameterIdent); })) === null || _a === void 0 ? void 0 : _a.ParameterType);
            });
        }
        this.selectedSeriesParameters = _.filter(_.map(this.parentScope.param.Chart.Series, function (series) {
            return _.find(_this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident === series.parameterIdent; });
        }), _.isDefined);
        this.selectedPlotLineParameters = _.filter(_.map(this.parentScope.param.Chart.PlotLines, function (plotLine) {
            return _.find(_this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident === plotLine.parameterIdent; });
        }), _.isDefined);
    };
    ChartSettingsCtrl.prototype.updateFormula = function () {
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
    };
    ChartSettingsCtrl.prototype.updateUI = function () {
        var _this = this;
        var _a, _b, _c, _d;
        this.selectedChartType =
            (_a = _.find(this.chartTypes, function (chartType) { return chartType.type === _this.parentScope.param.Chart.Type; })) !== null && _a !== void 0 ? _a : this.chartTypes[0];
        this.selectedLegendPosition =
            (_b = _.find(this.chartLegendPositions, function (chartLegendPosition) {
                return chartLegendPosition.legendPosition === _this.parentScope.param.Chart.LegendPosition;
            })) !== null && _b !== void 0 ? _b : this.chartLegendPositions[0];
        this.availableAxisXParameters = _.filter(this.parentScope.reportTemplate.Parameters, function (parameter) {
            return _.contains(__spreadArray(__spreadArray([], ChartParameterTypes.digitalArrayTypes, true), ChartParameterTypes.stringArrayTypes, true), parameter.ParameterType);
        });
        this.availableAxisXAutoDateTimeParameterIdents = __spreadArray(__spreadArray([], _.map(_.filter(this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.ParameterType === 'DateTime'; }), function (parameter) { return parameter.Ident; }), true), [undefined], false);
        this.availableAxisXNumericParameterIdents = __spreadArray(__spreadArray([], _.map(_.filter(this.parentScope.reportTemplate.Parameters, function (parameter) {
            return _.contains(ChartParameterTypes.digitalTypes, parameter.ParameterType);
        }), function (parameter) { return parameter.Ident; }), true), [undefined], false);
        this.availableSeriesParameters = _.filter(this.parentScope.reportTemplate.Parameters, function (parameter) {
            return _.contains(__spreadArray(__spreadArray([], ChartParameterTypes.digitalArrayTypes, true), ChartParameterTypes.digitalTypes, true), parameter.ParameterType) && parameter.Ident !== _this.parentScope.param.Ident;
        });
        this.availablePlotLineParameters = _.filter(this.parentScope.reportTemplate.Parameters, function (parameter) {
            return _.contains(ChartParameterTypes.digitalTypes, parameter.ParameterType) &&
                parameter.Ident !== _this.parentScope.param.Ident;
        });
        this.availablePieChartParameters = _.filter(this.parentScope.reportTemplate.Parameters, function (parameter) {
            return _.contains(__spreadArray([], ChartParameterTypes.digitalTypes, true), parameter.ParameterType);
        });
        this.updateSeriesParameters();
        this.selectedChartAxisXMode =
            (_c = _.find(this.chartAxisXModes, function (ChartAxisXMode) { return ChartAxisXMode.mode === _this.parentScope.param.Chart.AxisX.mode; })) !== null && _c !== void 0 ? _c : this.chartAxisXModes[this.parentScope.reportTemplate.HasStep ? 0 : 1];
        this.selectedAxisXParameter = _.find(this.availableAxisXParameters, function (parameter) { var _a; return ((_a = _this.parentScope.param.Chart.AxisX.custom) === null || _a === void 0 ? void 0 : _a.parameterIdent) === parameter.Ident; });
        this.parentScope.param.Chart.AxisX.custom.parameterIdent = ((_d = this.selectedAxisXParameter) === null || _d === void 0 ? void 0 : _d.Ident) || null;
        var axisX = this.parentScope.param.Chart.AxisX;
        if (axisX.mode === 0) {
            if (_.isUndefined(axisX.auto)) {
                axisX.auto = {
                    dateTimeFormat: undefined,
                    tickInterval: '1h',
                    minParameterIdent: undefined,
                    maxParameterIdent: undefined
                };
            }
        }
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
        this.parentScope.settingsCtrl.formulaCtrl.setResultType('ReportChartValue');
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.getFormula = function () {
        return this.formulaFactory.getFormula(this.parentScope.param, this.parentScope.reportTemplate.Parameters);
    };
    ChartSettingsCtrl.prototype.isPieChart = function () {
        return this.selectedChartType.type === 3;
    };
    ChartSettingsCtrl.prototype.isDigitalArray = function (parameter) {
        return _.contains(ChartParameterTypes.digitalArrayTypes, parameter === null || parameter === void 0 ? void 0 : parameter.ParameterType);
    };
    ChartSettingsCtrl.prototype.isAutoAxisX = function () {
        return this.parentScope.reportTemplate.HasStep && this.selectedChartAxisXMode.mode === 0;
    };
    ChartSettingsCtrl.prototype.init = function () {
        if (!this.parentScope.reportTemplate.HasStep) {
            this.parentScope.param.Chart.AxisX.mode = 1;
        }
        this.updateUI();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.destroy = function () { };
    ChartSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        if (_.isUndefined(this.parentScope.param.Chart) ||
            _.isNull(this.parentScope.param.Chart) ||
            _.any(this.parentScope.param.Chart.Series, function (series) {
                return _.isUndefined(series.parameterIdent);
            })) {
            return true;
        }
        return false;
    };
    ChartSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Chart.canEdited();
    };
    ChartSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Chart.canPlanned();
    };
    ChartSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Chart.canBacklight();
    };
    ChartSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Chart.canPredefined();
    };
    ChartSettingsCtrl.prototype.addEmptySeries = function () {
        var parameter = this.isPieChart()
            ? this.getAvailablePieChartParametersLeft()[0]
            : this.getAvailableSeriesParametersLeft()[0];
        this.parentScope.param.Chart.Series.push({
            parameterIdent: parameter.Ident,
            label: null,
            color: this.colors[this.parentScope.param.Chart.Series.length],
            type: 0,
            lineSize: 2,
            callout: undefined,
            lineDashStyle: 4,
            marker: {
                color: this.colors[this.parentScope.param.Chart.Series.length],
                size: 1,
                shape: 'circle',
                transparency: undefined
            }
        });
        this.updateSeriesParameters();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.removeSeries = function (index) {
        this.parentScope.param.Chart.Series.splice(index, 1);
        this.updateSeriesParameters();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.moveSeriesUp = function (index) {
        var temp = this.parentScope.param.Chart.Series[index];
        this.parentScope.param.Chart.Series[index] = this.parentScope.param.Chart.Series[index - 1];
        this.parentScope.param.Chart.Series[index - 1] = temp;
        this.updateSeriesParameters();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.moveSeriesDown = function (index) {
        var temp = this.parentScope.param.Chart.Series[index];
        this.parentScope.param.Chart.Series[index] = this.parentScope.param.Chart.Series[index + 1];
        this.parentScope.param.Chart.Series[index + 1] = temp;
        this.updateSeriesParameters();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.addEmptyPlotLine = function () {
        this.parentScope.param.Chart.PlotLines.push({
            parameterIdent: this.getAvailablePlotLineParametersLeft()[0].Ident,
            color: 'rgba(0, 0, 0)',
            width: 1,
            dashStyle: 4
        });
        this.updateSeriesParameters();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.removePlotLine = function (index) {
        this.parentScope.param.Chart.PlotLines.splice(index, 1);
        this.updateSeriesParameters();
        this.updateFormula();
    };
    ChartSettingsCtrl.prototype.getAvailableSeriesParametersLeft = function (parameterIdentToInclude) {
        var _this = this;
        var parametersLeft = _.filter(this.availableSeriesParameters, function (availableParameter) {
            return !_.any(_this.parentScope.param.Chart.Series, function (series) { return series.parameterIdent === availableParameter.Ident; });
        });
        if (_.isDefined(parameterIdentToInclude) &&
            !_.any(parametersLeft, function (parameter) { return parameter.Ident === parameterIdentToInclude; })) {
            var parameterToInclude = _.find(this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident === parameterIdentToInclude; });
            return __spreadArray([parameterToInclude], parametersLeft, true);
        }
        return parametersLeft;
    };
    ChartSettingsCtrl.prototype.getAvailablePlotLineParametersLeft = function (parameterIdentToInclude) {
        var _this = this;
        var parametersLeft = _.filter(this.availablePlotLineParameters, function (availableParameter) {
            return !_.any(_this.parentScope.param.Chart.PlotLines, function (series) { return series.parameterIdent === availableParameter.Ident; });
        });
        if (_.isDefined(parameterIdentToInclude) &&
            !_.any(parametersLeft, function (parameter) { return parameter.Ident === parameterIdentToInclude; })) {
            var parameterToInclude = _.find(this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident === parameterIdentToInclude; });
            return __spreadArray([parameterToInclude], parametersLeft, true);
        }
        return parametersLeft;
    };
    ChartSettingsCtrl.prototype.getAvailablePieChartParametersLeft = function (parameterIdentToInclude) {
        var _this = this;
        var availableParameters = _.filter(this.availablePieChartParameters, function (availableParameter) {
            return !_.any(_this.parentScope.param.Chart.Series, function (series) { return series.parameterIdent === availableParameter.Ident; });
        });
        if (_.isDefined(parameterIdentToInclude)) {
            var parameterToInclude = _.find(this.parentScope.reportTemplate.Parameters, function (parameter) { return parameter.Ident === parameterIdentToInclude; });
            return __spreadArray([parameterToInclude], availableParameters, true);
        }
        return availableParameters;
    };
    ChartSettingsCtrl.prototype.getParameterTypeString = function (parameterToInclude) {
        if (_.contains(ChartParameterTypes.digitalArrayTypes, parameterToInclude.ParameterType)) {
            return this.language.getElementValue('reportChartParameterArrayHdr');
        }
        if (_.contains(ChartParameterTypes.digitalTypes, parameterToInclude.ParameterType)) {
            return this.language.getElementValue('reportChartParameterCalculationValueHdr');
        }
    };
    ChartSettingsCtrl.prototype.showSeriesExtraSettings = function (series) {
        var _this = this;
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterEditModal/ChartSettings/ChartExtraSettingsModal/ChartExtraSettingsModal.html',
            controller: 'chartExtraSettingsModalCtrl',
            windowClass: 'app-modal-window level-two',
            backdrop: 'static',
            resolve: {
                chartType: function () {
                    return _this.selectedChartType.type;
                },
                series: function () {
                    return series;
                }
            }
        });
        modalInstance.result.then(function (newSeries) {
            series.label = _.isEmpty(newSeries.label)
                ? null
                : newSeries.label;
            series.callout = _.isDefined(newSeries.callout) ? _.clone(newSeries.callout) : undefined;
            series.marker = _.isDefined(newSeries.marker) ? _.clone(newSeries.marker) : undefined;
            (series.parameterIdent = newSeries.parameterIdent), (series.color = newSeries.color);
            series.type = newSeries.type;
            series.lineDashStyle = newSeries.lineDashStyle;
            series.lineSize = newSeries.lineSize;
            _this.updateFormula();
        }, function () { });
    };
    ChartSettingsCtrl.prototype.showPlotLinesSettings = function (plotLine) {
        var _this = this;
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/UserDocuments/Administration/ParameterEditModal/ChartSettings/ChartPlotLinesSettingsModal/ChartPlotLinesSettingsModal.html',
            controller: 'chartPlotLinesSettingsModalCtrl',
            windowClass: 'app-modal-window level-two',
            backdrop: 'static',
            resolve: {
                plotLine: function () {
                    return plotLine;
                }
            }
        });
        modalInstance.result.then(function (newPlotLine) {
            plotLine.color = newPlotLine.color;
            plotLine.dashStyle = newPlotLine.dashStyle;
            plotLine.parameterIdent = newPlotLine.parameterIdent;
            plotLine.width = newPlotLine.width;
            _this.updateFormula();
        }, function () { });
    };
    return ChartSettingsCtrl;
}());
