var ReportParameterChart = (function () {
    function ReportParameterChart() {
        this.defaultTimestampFormat = '%H:%M %d.%m';
        this.Title = '';
        this.Series = [];
        this.PlotLines = [];
        this.Type = 0;
        this.LegendPosition = 1;
        this.Size = {
            width: 800,
            height: 400
        };
        this.AxisX = {
            mode: 0,
            custom: {
                parameterIdent: undefined,
                minParameterIdent: undefined,
                maxParameterIdent: undefined,
                tickInterval: undefined
            },
            auto: {
                dateTimeFormat: this.defaultTimestampFormat,
                tickInterval: '1h',
                minParameterIdent: undefined,
                maxParameterIdent: undefined
            }
        };
        this.AxisY = {
            min: undefined,
            max: undefined,
            tickInterval: undefined
        };
    }
    ReportParameterChart.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportParameterChart();
        clone.Series = _.isUndefined(obj.Series)
            ? obj.Series
            : _.map(obj.Series, function (p) {
                return ({
                    parameterIdent: p.parameterIdent,
                    label: p.label,
                    type: p.type,
                    lineDashStyle: p.lineDashStyle,
                    lineSize: p.lineSize,
                    color: p.color,
                    marker: p.marker,
                    callout: p.callout
                });
            });
        clone.PlotLines = _.isUndefined(obj.PlotLines)
            ? obj.PlotLines
            : _.map(obj.PlotLines, function (p) {
                return ({
                    parameterIdent: p.parameterIdent,
                    dashStyle: p.dashStyle,
                    width: p.width,
                    color: p.color,
                });
            });
        if (_.isDefined(obj.AxisX)) {
            clone.AxisX = {
                auto: obj.AxisX.auto,
                custom: obj.AxisX.custom,
                mode: obj.AxisX.mode
            };
            if (_.isDefined(obj.AxisX.auto)) {
                clone.AxisX.auto = {
                    dateTimeFormat: obj.AxisX.auto.dateTimeFormat,
                    tickInterval: obj.AxisX.auto.tickInterval,
                    minParameterIdent: undefined,
                    maxParameterIdent: undefined,
                };
            }
        }
        clone.AxisX.mode = obj.AxisX.mode;
        clone.Type = obj.Type;
        clone.LegendPosition = obj.LegendPosition;
        clone.Size.width = obj.Size.width;
        clone.Size.height = obj.Size.height;
        clone.Title = obj.Title;
        clone.AxisY.min = obj.AxisY.min;
        clone.AxisY.max = obj.AxisY.max;
        clone.AxisY.tickInterval = obj.AxisY.tickInterval;
        clone.IsColumnStack = obj.IsColumnStack;
        return clone;
    };
    ReportParameterChart.isEqual = function (obj, other) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r;
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        if (_.isUndefined(obj.Series) || _.isUndefined(other.Series)) {
            if (obj.Series !== other.Series) {
                return false;
            }
        }
        else {
            if (obj.Series.length !== other.Series.length) {
                return false;
            }
            for (var i = 0; i < obj.Series.length; i++) {
                if (_.isUndefined(obj.Series[i]) || _.isUndefined(other.Series[i])) {
                    if (obj.Series[i] !== other.Series[i]) {
                        return false;
                    }
                }
                else {
                    if (obj.Series[i].label !== other.Series[i].label ||
                        obj.Series[i].type !== other.Series[i].type ||
                        obj.Series[i].lineDashStyle !== other.Series[i].lineDashStyle ||
                        obj.Series[i].lineSize !== other.Series[i].lineSize ||
                        obj.Series[i].parameterIdent !== other.Series[i].parameterIdent ||
                        obj.Series[i].color !== other.Series[i].color) {
                        return false;
                    }
                    if (_.isUndefined(obj.Series[i].callout) || _.isUndefined(other.Series[i].callout)) {
                        if (obj.Series[i].callout !== other.Series[i].callout) {
                            return false;
                        }
                    }
                    else {
                        if (obj.Series[i].callout.labelInterval !== other.Series[i].callout.labelInterval ||
                            obj.Series[i].callout.labelOffset !== other.Series[i].callout.labelOffset ||
                            obj.Series[i].callout.color !== other.Series[i].callout.color ||
                            obj.Series[i].callout.fontSize !== other.Series[i].callout.fontSize ||
                            obj.Series[i].callout.distanceFromPoint !== other.Series[i].callout.distanceFromPoint ||
                            obj.Series[i].callout.alignmentStyles !== other.Series[i].callout.alignmentStyles) {
                            return false;
                        }
                    }
                    if (_.isUndefined(obj.Series[i].marker) || _.isUndefined(other.Series[i].marker)) {
                        if (obj.Series[i].marker !== other.Series[i].marker) {
                            return false;
                        }
                    }
                    else {
                        if (obj.Series[i].marker.color !== other.Series[i].marker.color ||
                            obj.Series[i].marker.size !== other.Series[i].marker.size ||
                            obj.Series[i].marker.shape !== other.Series[i].marker.shape) {
                            return false;
                        }
                    }
                }
            }
        }
        if (_.isUndefined(obj.PlotLines) || _.isUndefined(other.PlotLines)) {
            if (obj.PlotLines !== other.PlotLines) {
                return false;
            }
        }
        else {
            if (obj.PlotLines.length !== other.PlotLines.length) {
                return false;
            }
            for (var i = 0; i < obj.PlotLines.length; i++) {
                if (_.isUndefined(obj.PlotLines[i]) || _.isUndefined(other.PlotLines[i])) {
                    if (obj.PlotLines[i] !== other.PlotLines[i]) {
                        return false;
                    }
                }
                else {
                    if (obj.PlotLines[i].dashStyle !== other.PlotLines[i].dashStyle ||
                        obj.PlotLines[i].width !== other.PlotLines[i].width ||
                        obj.PlotLines[i].parameterIdent !== other.PlotLines[i].parameterIdent ||
                        obj.PlotLines[i].color !== other.PlotLines[i].color) {
                        return false;
                    }
                }
            }
        }
        return (obj.Title === other.Title &&
            obj.Type === other.Type &&
            obj.LegendPosition === other.LegendPosition &&
            obj.Size.width === other.Size.width &&
            obj.Size.height === other.Size.height &&
            obj.AxisX.mode === other.AxisX.mode &&
            ((_a = obj.AxisX.custom) === null || _a === void 0 ? void 0 : _a.parameterIdent) === ((_b = other.AxisX.custom) === null || _b === void 0 ? void 0 : _b.parameterIdent) &&
            ((_c = obj.AxisX.custom) === null || _c === void 0 ? void 0 : _c.minParameterIdent) === ((_d = other.AxisX.custom) === null || _d === void 0 ? void 0 : _d.minParameterIdent) &&
            ((_e = obj.AxisX.custom) === null || _e === void 0 ? void 0 : _e.maxParameterIdent) === ((_f = other.AxisX.custom) === null || _f === void 0 ? void 0 : _f.maxParameterIdent) &&
            ((_g = obj.AxisX.custom) === null || _g === void 0 ? void 0 : _g.tickInterval) === ((_h = other.AxisX.custom) === null || _h === void 0 ? void 0 : _h.tickInterval) &&
            ((_j = obj.AxisX.auto) === null || _j === void 0 ? void 0 : _j.tickInterval) === ((_k = other.AxisX.auto) === null || _k === void 0 ? void 0 : _k.tickInterval) &&
            ((_l = obj.AxisX.auto) === null || _l === void 0 ? void 0 : _l.dateTimeFormat) === ((_m = other.AxisX.auto) === null || _m === void 0 ? void 0 : _m.dateTimeFormat) &&
            ((_o = obj.AxisX.auto) === null || _o === void 0 ? void 0 : _o.minParameterIdent) === ((_p = other.AxisX.auto) === null || _p === void 0 ? void 0 : _p.minParameterIdent) &&
            ((_q = obj.AxisX.auto) === null || _q === void 0 ? void 0 : _q.maxParameterIdent) === ((_r = other.AxisX.auto) === null || _r === void 0 ? void 0 : _r.maxParameterIdent) &&
            obj.AxisY.min === other.AxisY.min &&
            obj.AxisY.max === other.AxisY.max &&
            obj.AxisY.tickInterval === other.AxisY.tickInterval &&
            obj.IsColumnStack === other.IsColumnStack);
    };
    ReportParameterChart.prototype.canEdited = function () {
        return false;
    };
    ReportParameterChart.prototype.canPlanned = function () {
        return true;
    };
    ReportParameterChart.prototype.canBacklight = function () {
        return false;
    };
    ReportParameterChart.prototype.canPredefined = function () {
        return false;
    };
    return ReportParameterChart;
}());
