var AlphaSettingsCtrl = (function () {
    function AlphaSettingsCtrl(parentScope, modalService, alphaConnectionProvider, notificationService, language) {
        this.parentScope = parentScope;
        this.modalService = modalService;
        this.alphaConnectionProvider = alphaConnectionProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.connectionTypes = [13];
        this.watchFunctions = [];
    }
    AlphaSettingsCtrl.prototype.init = function () {
        var selfScope = this;
        this.alphaFunctions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('onCurrentTime', selfScope.language.getElementValue('reportParameterInCurrentTimeHdr'), 'AlphaValue'),
            new SelectSourceFunctionsItem('historical', selfScope.language.getElementValue('reportParameterOnPeriodHdr'), 'AlphaValue[]'),
            new SelectSourceFunctionsItem('onTimestamp', selfScope.language.getElementValue('reportParameterOnTimeStampHdr'), 'AlphaValue'),
            new SelectSourceFunctionsItem('historicalEvents', selfScope.language.getElementValue('reportParameterTypeListEventsAlphaHdr'), 'AlphaEventValue[]')
        ], function (func) {
            return func.ident === selfScope.parentScope.param.AlphaPlatform.func;
        }, function (after, before) {
            if (after === before) {
                return;
            }
            selfScope.parentScope.param.AlphaPlatform.func = after.ident;
            if (after.ident === 'onTimestamp') {
                selfScope.parentScope.param.AlphaPlatform.includeBorders = true;
            }
            selfScope.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
            if (!selfScope.canEdited()) {
                selfScope.parentScope.param.Editable = false;
            }
        });
        this.startPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return selfScope.parentScope.param.AlphaPlatform.startPeriod;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            selfScope.parentScope.param.AlphaPlatform.startPeriod = after.ident;
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        });
        this.endPeriods = getVariantsExtendableContainer(this.parentScope, this.parentScope.settingsCtrl.getTimestamps(), function () {
            return selfScope.parentScope.param.AlphaPlatform.endPeriod;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            selfScope.parentScope.param.AlphaPlatform.endPeriod = after.ident;
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return selfScope.parentScope.param.AlphaPlatform;
        }, function (before, after) {
            if (before === after || _.isUndefined(after)) {
                return;
            }
            selfScope.parentScope.settingsCtrl.formulaCtrl.setFormula(selfScope.getFormula());
        }, true));
        if (this.alphaFunctions.selected) {
            this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.alphaFunctions.selected.returnType);
            this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        }
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    AlphaSettingsCtrl.prototype.onConnectionSelected = function (connection) {
        this.selectedConnection = connection;
    };
    AlphaSettingsCtrl.prototype.filterAlphaFunctions = function () {
        var _this = this;
        return function (item) {
            if (_.isUndefined(_this.selectedConnection)) {
                return false;
            }
            if (_.any(_this.selectedConnection.specializedSettings, function (settings) { return !settings.alpha.hasHistoryNode; })) {
                return item.ident === 'onCurrentTime';
            }
            return true;
        };
    };
    AlphaSettingsCtrl.prototype.canCheckTagAddress = function () {
        return _.isDefined(this.parentScope.param.AlphaPlatform.connectionGuid) && !_.isEmpty(this.parentScope.param.AlphaPlatform.address);
    };
    AlphaSettingsCtrl.prototype.checkTagAddress = function () {
        var _this = this;
        this.alphaConnectionProvider
            .checkTagAddress(this.parentScope.param.AlphaPlatform.address, this.parentScope.param.AlphaPlatform.connectionGuid)
            .then(function (checkResult) {
            if (checkResult) {
                _this.notificationService.showMessage(_this.language.getElementValue('reportTagAddressIsExistMsg'));
            }
            else {
                _this.notificationService.errorMessage(_this.language.getElementValue('reportTagAddressIsNotExistMsg'));
            }
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('reportErrorCheckTagAddressMsg'), error);
        });
    };
    AlphaSettingsCtrl.prototype.isHistoricalParameter = function () {
        return this.alphaFunctions
            && this.alphaFunctions.selected
            && (this.alphaFunctions.selected.ident === 'historical' || this.alphaFunctions.selected.ident === 'historicalEvents');
    };
    AlphaSettingsCtrl.prototype.isHistoricalOnTimeParameter = function () {
        return this.alphaFunctions
            && this.alphaFunctions.selected
            && this.alphaFunctions.selected.ident === 'onTimestamp';
    };
    AlphaSettingsCtrl.prototype.showTimeStamps = function () {
        return this.isHistoricalParameter() || this.isHistoricalOnTimeParameter();
    };
    AlphaSettingsCtrl.prototype.clearTag = function () {
        this.parentScope.param.AlphaPlatform.name = '';
        this.parentScope.param.AlphaPlatform.address = '';
    };
    AlphaSettingsCtrl.prototype.showAlphaTagsTree = function () {
        var _this = this;
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return _this.selectedConnection.id; },
                isMultiselectEnabled: function () { return false; },
                tagTreeTypes: function () { return [TagTreeType.Alpha]; },
                tagAddress: function () { return _this.parentScope.param.AlphaPlatform.address; }
            },
        });
        modalInstance.result.then(function (tags) {
            _this.parentScope.param.AlphaPlatform.name = tags[0].name;
            _this.parentScope.param.AlphaPlatform.address = tags[0].address;
        });
    };
    AlphaSettingsCtrl.prototype.destroy = function () {
        this.alphaFunctions.destroy();
        this.startPeriods.destroy();
        this.endPeriods.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    AlphaSettingsCtrl.prototype.getFormula = function () {
        var connection = this.parentScope.param.AlphaPlatform.connectionGuid;
        var address = this.parentScope.param.AlphaPlatform.address;
        if (_.isUndefined(connection)) {
            connection = '';
        }
        if (!this.alphaFunctions.selected) {
            return '';
        }
        var functionName = '';
        switch (this.alphaFunctions.selected.ident) {
            case 'onCurrentTime':
                functionName = 'GetAlphaValue';
                break;
            case 'historical':
                functionName = 'GetAlphaValuesOnPeriod';
                break;
            case 'onTimestamp':
                functionName = 'GetAlphaValueOnTimeStamp';
                break;
            case 'historicalEvents':
                functionName = 'GetAlphaEvents';
                break;
        }
        var formula = String.Format('{0}(@"{1}", @"{2}"', functionName, connection, address);
        if (this.isHistoricalParameter()) {
            formula += String.Format(', {0}, {1}, {2}, {3}', this.parentScope.param.AlphaPlatform.startPeriod, this.parentScope.param.AlphaPlatform.endPeriod, this.parentScope.param.AlphaPlatform.includeBorders.toString(), this.parentScope.param.AlphaPlatform.maxFields.toString());
        }
        if (this.isHistoricalOnTimeParameter()) {
            formula += String.Format(', {0}', this.parentScope.param.AlphaPlatform.startPeriod);
        }
        return formula + ')';
    };
    AlphaSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return (_.isUndefined(this.parentScope.param.AlphaPlatform.connectionGuid)
            || (this.isHistoricalParameter() && this.parentScope.param.AlphaPlatform.maxFields.toString() === ''));
    };
    AlphaSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.AlphaPlatform.canEdited();
    };
    AlphaSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.AlphaPlatform.canPlanned();
    };
    AlphaSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.AlphaPlatform.canBacklight();
    };
    AlphaSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.AlphaPlatform.canPredefined();
    };
    return AlphaSettingsCtrl;
}());
