var AlphaSettings = (function () {
    function AlphaSettings(templateHasStep) {
        this.address = '';
        this.name = '';
        this.func = 'onTimestamp';
        this.startPeriod = templateHasStep
            ? 'StepStart'
            : 'StartDate';
        this.endPeriod = templateHasStep
            ? 'StepEnd'
            : 'EndDate';
        this.maxFields = 10000;
        this.includeBorders = true;
    }
    AlphaSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new AlphaSettings();
        clone.connectionGuid = obj.connectionGuid;
        clone.func = obj.func;
        clone.name = obj.name;
        clone.address = obj.address;
        clone.startPeriod = obj.startPeriod;
        clone.endPeriod = obj.endPeriod;
        clone.includeBorders = obj.includeBorders;
        clone.maxFields = obj.maxFields;
        return clone;
    };
    AlphaSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        return (obj.connectionGuid === other.connectionGuid &&
            obj.func === other.func &&
            obj.name === other.name &&
            obj.address === other.address &&
            obj.startPeriod === other.startPeriod &&
            obj.endPeriod === other.endPeriod &&
            obj.includeBorders === other.includeBorders &&
            obj.maxFields === other.maxFields);
    };
    AlphaSettings.prototype.canEdited = function () {
        return this.func !== 'historical' && this.func !== 'historicalEvents';
    };
    AlphaSettings.prototype.canPlanned = function () {
        return true;
    };
    AlphaSettings.prototype.canBacklight = function () {
        return !_.contains(['table', 'doubleArray', 'stringOneDimArray'], this.func);
    };
    AlphaSettings.prototype.canPredefined = function () {
        return false;
    };
    AlphaSettings.AlphaParameterTypeName = 'alpha';
    AlphaSettings.AlphaReturnValueTypeName = 'AlphaValue';
    return AlphaSettings;
}());
