var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var TagsTreeNodesProvider = (function () {
    function TagsTreeNodesProvider($q, winccOaProvider, opcConnectionProvider, alphaConnectionProvider, notificationService, languageService) {
        this.$q = $q;
        this.winccOaProvider = winccOaProvider;
        this.opcConnectionProvider = opcConnectionProvider;
        this.alphaConnectionProvider = alphaConnectionProvider;
        this.notificationService = notificationService;
        this.languageService = languageService;
    }
    TagsTreeNodesProvider.prototype.getNodes = function (tagTreeType, connectionGuid, parentId, searchText, isShowDescription) {
        var _this = this;
        if (isShowDescription === void 0) { isShowDescription = false; }
        var deferred = this.$q.defer();
        switch (tagTreeType) {
            case TagTreeType.WinccOaCns:
                this.winccOaProvider.getCnsTreeNodes(connectionGuid, searchText)
                    .then(function (nodes) { return deferred.resolve(_this.limit(tagTreeType, _.map(_.filter(nodes, _this.hasLeafTagAddress), function (node) { return _this.convertCnsTreeNode(node); }), searchText)); })
                    .catch(function (response) { return deferred.reject(response); });
                break;
            case TagTreeType.WinccOaPara:
                this.winccOaProvider.getParaTreeNodes(connectionGuid, (_.isDefined(parentId) ? +parentId : null), searchText, isShowDescription)
                    .then(function (nodes) { return deferred.resolve(_this.limit(tagTreeType, _.map(nodes, function (node) { return _this.convertParaTreeNode(node, searchText); }), searchText)); })
                    .catch(function (response) { return deferred.reject(response); });
                break;
            case TagTreeType.Opc:
                this.opcConnectionProvider.getOpcTreeNodes(connectionGuid, parentId)
                    .then(function (nodes) { return deferred.resolve(_this.limit(tagTreeType, _.map(nodes, function (node) { return _this.convertOpcTreeNode(node); }), searchText)); })
                    .catch(function (response) { return deferred.reject(response); });
                break;
            case TagTreeType.Alpha:
                this.alphaConnectionProvider.getTreeNodes(connectionGuid, parentId)
                    .then(function (nodes) { return deferred.resolve(_this.limit(tagTreeType, _.map(nodes, function (node) { return _this.convertAlphaTreeNode(node); }), searchText)); })
                    .catch(function (response) { return deferred.reject(response); });
                break;
        }
        return deferred.promise;
    };
    TagsTreeNodesProvider.prototype.convertParaTreeNode = function (node, searchText) {
        return __assign(__assign({ id: node.id.toString() }, (_.isEmpty(searchText)
            ? { children: node.hasChildren }
            : {
                parent: node.parentId
                    ? node.parentId.toString()
                    : '#',
            })), { text: node.name, type: node.type === 3
                ? 'file'
                : 'folder', address: node.tagAddress === '' || node.tagAddress[node.tagAddress.length - 1] === ':' || node.tagAddress.indexOf('.') !== -1
                ? node.tagAddress
                : node.tagAddress + '.' });
    };
    TagsTreeNodesProvider.prototype.hasLeafTagAddress = function (node) {
        return !(node.type === 2 && _.isEmpty(node.tagAddress));
    };
    TagsTreeNodesProvider.prototype.convertCnsTreeNode = function (node) {
        var name = node.name.split(/[:.]+/).pop();
        var nameParts = name.split('|');
        var location = nameParts.length < 2 || node.type === 1
            ? ''
            : nameParts.shift().trim();
        var text = node.type === 1
            ? name
            : nameParts.join('|').trim();
        return {
            id: node.id,
            parent: _.isEmpty(node.parentId)
                ? '#'
                : node.parentId,
            text: text,
            location: location,
            type: node.type === 1
                ? 'folder'
                : 'file',
            address: node.tagAddress
        };
    };
    TagsTreeNodesProvider.prototype.convertOpcTreeNode = function (node) {
        return {
            id: node.id,
            text: node.name,
            type: node.hasChildren
                ? 'folder'
                : 'file',
            children: node.hasChildren,
            address: node.tagAddress,
        };
    };
    TagsTreeNodesProvider.prototype.convertAlphaTreeNode = function (node) {
        return {
            id: node.id,
            text: node.name,
            type: node.hasChildren
                ? 'folder'
                : 'file',
            children: node.hasChildren,
            address: node.tagAddress,
        };
    };
    TagsTreeNodesProvider.prototype.limit = function (tagTreeType, nodes, searchText) {
        var noDataNode = {
            text: this.languageService.getElementValue('noDataMsg'),
            icon: 'glyphicon glyphicon-info-sign',
            state: { disabled: true }
        };
        var maxNodesCount = tagTreeType === TagTreeType.WinccOaCns
            ? 1000
            : 10000;
        if (!_.isEmpty(searchText) && nodes.length > maxNodesCount) {
            this.notificationService.warnMessage(this.languageService.getElementValue('treeTagsLimitMsg'));
            return [noDataNode];
        }
        return nodes.length !== 0
            ? nodes
            : [noDataNode];
    };
    TagsTreeNodesProvider.$inject = [
        '$q',
        'winCCOAProvider',
        'opcConnectionProvider',
        'alphaPlatformConnectionProvider',
        'notificationService',
        'language',
    ];
    return TagsTreeNodesProvider;
}());
angular
    .module('kamhpp')
    .service('tagsTreeNodesProvider', TagsTreeNodesProvider);
