var Tag = (function () {
    function Tag(name, address) {
        this.name = name;
        this.address = address;
    }
    return Tag;
}());
var TagTreeType;
(function (TagTreeType) {
    TagTreeType[TagTreeType["Opc"] = 0] = "Opc";
    TagTreeType[TagTreeType["WinccOaPara"] = 1] = "WinccOaPara";
    TagTreeType[TagTreeType["WinccOaCns"] = 2] = "WinccOaCns";
    TagTreeType[TagTreeType["Alpha"] = 3] = "Alpha";
})(TagTreeType || (TagTreeType = {}));
var TagsTreeTab = (function () {
    function TagsTreeTab(ident, name, isVisible) {
        if (isVisible === void 0) { isVisible = false; }
        this.ident = ident;
        this.name = name;
        this.isVisible = isVisible;
    }
    return TagsTreeTab;
}());
var TagsTreeModalCtrl = (function () {
    function TagsTreeModalCtrl(scope, modalInstance, $q, timeout, notificationService, languageService, winccOaProvider, tagsTreeConfigurationProvider, tagsTreeNodesProvider, userPreferencesService, connectionGuid, isMultiselectEnabled, tagTreeTypes, tagAddress) {
        var _this = this;
        this.scope = scope;
        this.modalInstance = modalInstance;
        this.$q = $q;
        this.timeout = timeout;
        this.notificationService = notificationService;
        this.languageService = languageService;
        this.winccOaProvider = winccOaProvider;
        this.tagsTreeConfigurationProvider = tagsTreeConfigurationProvider;
        this.tagsTreeNodesProvider = tagsTreeNodesProvider;
        this.userPreferencesService = userPreferencesService;
        this.connectionGuid = connectionGuid;
        this.isMultiselectEnabled = isMultiselectEnabled;
        this.tree = new SmsTree();
        this.isShowDescription = false;
        this.searchText = '';
        this.tabs = [
            new TagsTreeTab(TagTreeType.WinccOaCns, this.languageService.getElementValue('tagsCnsTreeHdr')),
            new TagsTreeTab(TagTreeType.WinccOaPara, this.languageService.getElementValue('tagsTreeHdr')),
            new TagsTreeTab(TagTreeType.Opc, this.languageService.getElementValue('tagsTreeHdr')),
            new TagsTreeTab(TagTreeType.Alpha, this.languageService.getElementValue('tagsTreeHdr')),
        ];
        this.scope.ctrl = this;
        var events = [];
        _.forEach(this.tabs, function (tab) {
            tab.isVisible = _.any(tagTreeTypes, function (type) { return type === tab.ident; });
        });
        this.selectTab(tagTreeTypes[0]);
        events.push(scope.$on('jstreeStateReady', function () {
            var tree = _this.tree.element.jstree(true);
            var node = _.isEmpty(tagAddress)
                ? null
                : _.find(tree._model.data, function (node) { var _a; return ((_a = node === null || node === void 0 ? void 0 : node.original) === null || _a === void 0 ? void 0 : _a.address) === tagAddress; });
            if (_.isDefined(node)) {
                tree.deselect_all(true);
                tree.select_node(node);
                tree.get_node(node, true).children('.jstree-anchor').focus();
            }
            else {
                if (!_.isEmpty(tagAddress)) {
                    tree.deselect_all(true);
                    return;
                }
                var selectedNodes = tree.get_selected(true);
                if (_.isEmpty(selectedNodes)) {
                    return;
                }
                tree.get_node(_.first(selectedNodes), true).children('.jstree-anchor').focus();
            }
        }));
        events.push(scope.$on('$destroy', function () {
            _.forEach(events, function (func) {
                if (func) {
                    func();
                }
            });
        }));
    }
    TagsTreeModalCtrl.prototype.selectTab = function (tabIdent) {
        var _this = this;
        this.selectedTab = _.find(this.tabs, function (tab) { return tab.ident === tabIdent; });
        this.searchText = this.getSearchText(this.selectedTab.ident);
        this.treeConfiguration = null;
        this.timeout(function () {
            return _this.getTagTreeData()
                .then(function (data) { return _this.treeConfiguration = _this.tagsTreeConfigurationProvider.getConfiguration(_this.selectedTab.ident, data, _this.isMultiselectEnabled); })
                .catch(function (error) { return _this.notificationService.errorMessage(_this.languageService.getElementValue('failedLoadDataServerMsg'), error); });
        });
    };
    TagsTreeModalCtrl.prototype.searchTags = function () {
        if (this.selectedTab.ident === TagTreeType.Opc || this.selectedTab.ident === TagTreeType.Alpha) {
            return;
        }
        this.refreshNodes();
    };
    TagsTreeModalCtrl.prototype.canSearch = function () {
        return this.selectedTab.ident !== TagTreeType.Opc && this.selectedTab.ident !== TagTreeType.Alpha;
    };
    TagsTreeModalCtrl.prototype.refreshTree = function () {
        var _this = this;
        switch (this.selectedTab.ident) {
            case TagTreeType.Opc:
                this.refreshNodes();
                break;
            case TagTreeType.WinccOaCns:
                this.winccOaProvider
                    .updateCnsTreeNodes(this.connectionGuid)
                    .then(function () { return _this.refreshNodes(); })
                    .catch(function (error) { return _this.notificationService.errorMessage(_this.languageService.getElementValue('serverSettingsConnectionErrorWithWinCCOAMsg'), error); });
                break;
            case TagTreeType.WinccOaPara:
                this.winccOaProvider
                    .updateParaTreeNodes(this.connectionGuid)
                    .then(function () { return _this.refreshNodes(); })
                    .catch(function (error) { return _this.notificationService.errorMessage(_this.languageService.getElementValue('serverSettingsConnectionErrorWithWinCCOAMsg'), error); });
                break;
            case TagTreeType.Alpha:
                this.refreshNodes();
                break;
        }
    };
    TagsTreeModalCtrl.prototype.canShowDescription = function () {
        return this.selectedTab.ident === TagTreeType.WinccOaPara;
    };
    TagsTreeModalCtrl.prototype.onShowDescriptionChange = function () {
        this.refreshNodes();
    };
    TagsTreeModalCtrl.prototype.ok = function () {
        var _this = this;
        var selectedNodes = this.tree.element.jstree(true).get_selected(true);
        var selectedTags = _.map(selectedNodes, function (node) { return new Tag(_this.getTagName(node), node.original.address); });
        this.modalInstance.close(selectedTags);
    };
    TagsTreeModalCtrl.prototype.cancel = function () {
        this.modalInstance.dismiss();
    };
    TagsTreeModalCtrl.prototype.canSelectTags = function () {
        var _a, _b;
        var tree = (_b = (_a = this.tree) === null || _a === void 0 ? void 0 : _a.element) === null || _b === void 0 ? void 0 : _b.jstree(true);
        return _.isObject(tree)
            && _.all(tree.get_selected(true), function (tag) { return !_.isEmpty(tag.original.address); });
    };
    TagsTreeModalCtrl.prototype.refreshNodes = function () {
        var _this = this;
        this.getTagTreeData()
            .then(function (data) {
            _this.tree.element.jstree(true).settings.core.data = data;
            var refreshEvent = _this.scope.$on('jstreeRefresh', function () {
                if (_.isArray(data)) {
                    var openAllEvent_1 = _this.scope.$on('jstreeOpenAll', function () {
                        _this.tree.element.jstree(true).save_state();
                        _this.saveSearchText(_this.selectedTab.ident);
                        openAllEvent_1();
                    });
                    _this.tree.element.jstree(true).open_all();
                }
                else {
                    _this.tree.element.jstree(true).save_state();
                    _this.saveSearchText(_this.selectedTab.ident);
                }
                refreshEvent();
            });
            _this.tree.element.jstree(true).refresh(false, true);
        });
    };
    TagsTreeModalCtrl.prototype.getTagTreeData = function () {
        var _this = this;
        var deffered = this.$q.defer();
        if (!_.isEmpty(this.searchText)) {
            this.tagsTreeNodesProvider
                .getNodes(this.selectedTab.ident, this.connectionGuid, null, this.searchText, this.isShowDescription)
                .then(function (nodes) { return deffered.resolve(nodes); })
                .catch(function () { return deffered.reject(); });
        }
        else {
            var loadNodesFunction = function (node, cb) {
                _this.tagsTreeNodesProvider.getNodes(_this.selectedTab.ident, _this.connectionGuid, (node.id === "#" ? null : node.id), _this.searchText, _this.isShowDescription)
                    .then(function (nodes) { return cb(nodes); })
                    .catch(function () { return _this.notificationService.errorMessage(_this.languageService.getElementValue('failedLoadDataServerMsg')); });
            };
            deffered.resolve(loadNodesFunction);
        }
        return deffered.promise;
    };
    TagsTreeModalCtrl.prototype.saveSearchText = function (tagTreeType) {
        var preferences = this.userPreferencesService.getPreferences();
        var tagTreeName = this.tagsTreeConfigurationProvider.getTreeName(tagTreeType);
        preferences.common.tagsTreeSearchText[tagTreeName] = this.searchText;
        this.userPreferencesService.setPreferences(preferences);
    };
    TagsTreeModalCtrl.prototype.getSearchText = function (tagTreeType) {
        var preferences = this.userPreferencesService.getPreferences();
        var tagTreeName = this.tagsTreeConfigurationProvider.getTreeName(tagTreeType);
        return preferences.common.tagsTreeSearchText[tagTreeName];
    };
    TagsTreeModalCtrl.prototype.getTagName = function (node) {
        var _this = this;
        var name = !_.isEmpty(node.original.location)
            ? node.original.location + ' | ' + node.text
            : node.text;
        switch (this.selectedTab.ident) {
            case TagTreeType.Opc:
            case TagTreeType.Alpha:
                _.forEach(node.parents, function (parent) {
                    if (parent === '#') {
                        return;
                    }
                    name = _this.tree.element.jstree(true).get_node(parent).text + '.' + name;
                });
                break;
            case TagTreeType.WinccOaPara:
                name = node.original.address;
                break;
            case TagTreeType.WinccOaCns:
                _.forEach(node.parents, function (parent) {
                    if (parent === '#') {
                        return;
                    }
                    var parentNode = _this.tree.element.jstree(true).get_node(parent);
                    name = parentNode.text + (parentNode.parent === '#' ? ':' : '.') + name;
                });
                break;
        }
        return this.selectedTab.ident === TagTreeType.WinccOaCns
            ? '.' + name
            : name;
    };
    TagsTreeModalCtrl.$inject = [
        '$scope',
        '$modalInstance',
        '$q',
        '$timeout',
        'notificationService',
        'language',
        'winCCOAProvider',
        'tagsTreeConfigurationProvider',
        'tagsTreeNodesProvider',
        'userPreferencesService',
        'connectionGuid',
        'isMultiselectEnabled',
        'tagTreeTypes',
        'tagAddress',
    ];
    return TagsTreeModalCtrl;
}());
angular
    .module('kamhpp')
    .controller('tagsTreeModalCtrl', TagsTreeModalCtrl);
