var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var ConnectionCheckResult = (function (_super) {
    __extends(ConnectionCheckResult, _super);
    function ConnectionCheckResult() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return ConnectionCheckResult;
}(CheckResult));
var ExternalConnectionsComponent = (function () {
    function ExternalConnectionsComponent() {
        this.templateUrl = 'ng1/dist/src/ExternalConnections/ExternalConnections.html';
        this.controller = ExternalConnectionsCtrl;
        this.controllerAs = 'ctrl';
    }
    return ExternalConnectionsComponent;
}());
var ExternalConnectionsCtrl = (function () {
    function ExternalConnectionsCtrl($rootScope, scope, $q, $window, $modal, http, $location, $upload, notificationService, language, externalConnectionsProvider, reportTemplateProvider, switchoverFormConfigurationProvider, operationTimeConfigurationProvider, exportService, clientSettings, guid, formatTimezoneFilter, authentication, permissionService, licenseStorage) {
        var _this = this;
        this.$rootScope = $rootScope;
        this.scope = scope;
        this.$q = $q;
        this.$window = $window;
        this.$modal = $modal;
        this.http = http;
        this.$location = $location;
        this.$upload = $upload;
        this.notificationService = notificationService;
        this.language = language;
        this.externalConnectionsProvider = externalConnectionsProvider;
        this.reportTemplateProvider = reportTemplateProvider;
        this.switchoverFormConfigurationProvider = switchoverFormConfigurationProvider;
        this.operationTimeConfigurationProvider = operationTimeConfigurationProvider;
        this.exportService = exportService;
        this.clientSettings = clientSettings;
        this.guid = guid;
        this.formatTimezoneFilter = formatTimezoneFilter;
        this.authentication = authentication;
        this.licenseStorage = licenseStorage;
        this.externalConnections = [];
        this.selectedExternalConnection = null;
        this.containerForFile = { data: {} };
        this.connectionTypeCtrl = null;
        this.types = [
            { id: 5, name: 'WinCC Classic', type: this.language.getElementValue('externalConnectionSourceTypeScadaHdr') },
            { id: 4, name: this.language.getElementValue('winccoaHdr'), type: this.language.getElementValue('externalConnectionSourceTypeScadaHdr') },
            { id: 10, name: 'InfluxDB', type: this.language.getElementValue('externalConnectionSourceTypeDbmsHdr') },
            { id: 0, name: 'Microsoft SQL Server', type: this.language.getElementValue('externalConnectionSourceTypeDbmsHdr') },
            { id: 3, name: 'MySQL', type: this.language.getElementValue('externalConnectionSourceTypeDbmsHdr') },
            { id: 1, name: 'Oracle', type: this.language.getElementValue('externalConnectionSourceTypeDbmsHdr') },
            { id: 2, name: 'PostgreSQL', type: this.language.getElementValue('externalConnectionSourceTypeDbmsHdr') },
            { id: 11, name: 'Excel', type: this.language.getElementValue('externalConnectionSourceTypeFileHdr') },
            { id: 7, name: this.language.getElementValue('fileTxtHdr'), type: this.language.getElementValue('externalConnectionSourceTypeFileHdr') },
            { id: 8, name: 'HTTP', type: this.language.getElementValue('externalConnectionSourceTypeOtherHdr') },
            { id: 9, name: 'ODBC', type: this.language.getElementValue('externalConnectionSourceTypeOtherHdr') },
            { id: 12, name: 'OLE DB', type: this.language.getElementValue('externalConnectionSourceTypeOtherHdr') },
            { id: 6, name: 'OPC', type: this.language.getElementValue('externalConnectionSourceTypeOtherHdr') },
            { id: 13, name: this.language.getElementValue('alphaPlatformHdr'), type: this.language.getElementValue('externalConnectionSourceTypeScadaHdr') },
        ];
        this.uniqueNamePattern = this.language.getElementValue('connectionUniqueNamePattern');
        this.watchFunctions = [];
        this.refreshOriginalConnections = function (updatedConnection) {
            var originalConnection = _.find(_this.externalConnections, function (connection) { return connection.id === updatedConnection.id; });
            if (originalConnection) {
                originalConnection.id = updatedConnection.id;
                originalConnection.name = updatedConnection.name;
                originalConnection.type = updatedConnection.type;
                originalConnection.retryCount = updatedConnection.retryCount;
                originalConnection.retryInterval = updatedConnection.retryInterval;
                originalConnection.specializedSettings = updatedConnection.specializedSettings;
            }
        };
        this.permissions = permissionService.getAll();
        this.filterConnectionTypes();
    }
    ExternalConnectionsCtrl.prototype.$onInit = function () {
        var _this = this;
        this.getAllConnections();
        this.$window.onbeforeunload = function (event) {
            var message = undefined;
            if (_this.selectedExternalConnection && _this.selectedExternalConnection.isChanged) {
                message = _this.language.getElementValue('changesNoSaveMsg');
            }
            if (typeof event == 'undefined') {
                event = window.event;
            }
            if (_.isDefined(event) && _.isDefined(message)) {
                event.returnValue = message;
                return message;
            }
            return undefined;
        };
        this.watchFunctions.push(this.$rootScope.$on('$locationChangeStart', function (event) {
            if (_.isUndefined(_this.selectedExternalConnection)
                || !_this.selectedExternalConnection.isChanged) {
                return;
            }
            var newUrl = _this.$location.url();
            event.preventDefault();
            _this.showSaveModalInstance().result.then(function (data) {
                if (data === 'ok') {
                    _this.saveConnection().then(function () {
                        _this.setNewSelected(undefined);
                        _this.$location.url(newUrl);
                    });
                }
                if (data === 'no') {
                    _this.setNewSelected(undefined);
                    _this.$location.url(newUrl);
                }
            });
        }));
        this.watchFunctions.push(this.scope.$watch(function () {
            return _this.containerForFile.data;
        }, function () {
            if (_.isUndefined(_this.containerForFile.data)
                || !_.any(_this.containerForFile.data))
                return;
            _this.$upload.upload({
                url: _this.clientSettings.getServerInstance() + '/ExternalConnections/ImportExternalConnections',
                file: _this.containerForFile.data
            }).then(function (importedExternalConnectionsResponse) {
                if (!_.any(importedExternalConnectionsResponse.data)) {
                    return;
                }
                _.each(importedExternalConnectionsResponse.data, function (imported) {
                    var existedIdx = _.findIndex(_this.externalConnections, function (existedConnection) {
                        return existedConnection.id === imported.id;
                    });
                    if (existedIdx > -1) {
                        _this.externalConnections[existedIdx] = imported;
                        if (_this.selectedExternalConnection.id === imported.id) {
                            _this.selectedExternalConnection
                                = new ExternalConnectionSettings(_this.scope, _this.externalConnections[existedIdx]);
                            _this.selectNewConnectionType(imported.type);
                        }
                    }
                    else {
                        _this.externalConnections.push(imported);
                    }
                });
                if (_.isUndefined(_this.selectedExternalConnection) && _.any(_this.externalConnections)) {
                    _this.selectConnection(_this.externalConnections[0]);
                }
                _this.notificationService.showMessage(_this.language.getElementValue('importExternalConnectionsSuccessMsg'));
            }, function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('importExternalConnectionsErrorMsg'), data);
            });
        }));
    };
    ExternalConnectionsCtrl.prototype.filterConnectionTypes = function () {
        var _this = this;
        this.externalConnectionsProvider.hasOracleProvider().then(function (hasOracleProvider) {
            if (!hasOracleProvider) {
                _this.types = _.filter(_this.types, function (type) { return type.id !== 1; });
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
        this.externalConnectionsProvider.hasAlphaPlatformProvider().then(function (hasAlphaPlatformProvider) {
            if (!hasAlphaPlatformProvider) {
                _this.types = _.filter(_this.types, function (type) { return type.id !== 13; });
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ExternalConnectionsCtrl.prototype.$onDestroy = function () {
        _.forEach(this.watchFunctions, function (func) {
            if (func) {
                func();
            }
        });
    };
    ExternalConnectionsCtrl.prototype.createConnection = function () {
        var _this = this;
        if (_.isDefined(this.selectedExternalConnection)
            && this.selectedExternalConnection.isChanged) {
            this.showSaveModalInstance()
                .result
                .then(function (data) {
                if (data === 'ok') {
                    _this.saveConnection()
                        .then(function () {
                        _this.createConnectionImpl();
                    });
                }
                if (data === 'no') {
                    _this.createConnectionImpl();
                }
                if (data === 'cancel') {
                    return;
                }
            });
        }
        else {
            this.createConnectionImpl();
        }
    };
    ExternalConnectionsCtrl.prototype.isConnectionUsed = function () {
        var _this = this;
        if (_.isUndefined(this.selectedExternalConnection)) {
            return;
        }
        var groupPromise = [
            this.licenseStorage.hasModule(62376423) ? this.reportTemplateProvider.getExtrenalConnectionUsingTemplates(this.selectedExternalConnection.id) : null,
            this.licenseStorage.hasModule(6239971) ? this.switchoverFormConfigurationProvider.getSwitchoverFormConfiguration() : null,
            this.licenseStorage.hasModule(6526756) ? this.operationTimeConfigurationProvider.getOperationTimeConfiguration() : null
        ];
        var deferred = this.$q.defer();
        this.$q.all(groupPromise).then(function (_a) {
            var reportTemplates = _a[0], switchoverFormsConfiguration = _a[1], operationTimeConfiguration = _a[2];
            var isConnectionUsedInReports = _.isDefined(reportTemplates) && _.any(reportTemplates);
            var isConnectionUsedInSwitchoverForms = _.isDefined(switchoverFormsConfiguration)
                && (switchoverFormsConfiguration.winccOaConnectionGuid === _this.selectedExternalConnection.id
                    || switchoverFormsConfiguration.opcConnectionGuid === _this.selectedExternalConnection.id);
            var isConnectionUsedInOperationTime = _.isDefined(operationTimeConfiguration)
                && (operationTimeConfiguration.providerType === 3 || operationTimeConfiguration.providerType === 2)
                && operationTimeConfiguration.connectionIdent === _this.selectedExternalConnection.id;
            if (isConnectionUsedInReports || isConnectionUsedInSwitchoverForms || isConnectionUsedInOperationTime) {
                _this.$modal.open({
                    templateUrl: 'ng1/dist/src/ExternalConnections/ExternalConnectionIsUsedModal/ExternalConnectionIsUsedModal.html',
                    controller: 'externalConnectionIsUsedModalCtrl',
                    backdrop: 'static',
                    windowClass: 'app-modal-window',
                    resolve: {
                        connectionName: function () { return _this.selectedExternalConnection.name; },
                        reportTemplates: function () { return reportTemplates; },
                        isConnectionUsedInReports: function () { return isConnectionUsedInReports; },
                        isConnectionUsedInSwitchoverForms: function () { return isConnectionUsedInSwitchoverForms; },
                        isConnectionUsedInOperationTime: function () { return isConnectionUsedInOperationTime; }
                    }
                })
                    .result.then(function () {
                    deferred.resolve(false);
                });
            }
            else {
                _this.$modal.open({
                    templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
                    controller: 'yesNoModalCtrl',
                    backdrop: 'static',
                    resolve: {
                        header: function () { return _this.language.getElementValue('externalConnectionDeletingHdr'); },
                        body: function () { return String.Format(_this.language.getElementValue('externalConnectionDeleteModalQuestionMsg'), _this.selectedExternalConnection.name); }
                    }
                })
                    .result.then(function () {
                    deferred.resolve(true);
                });
            }
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
        return deferred.promise;
    };
    ExternalConnectionsCtrl.prototype.deleteConnection = function () {
        var _this = this;
        this.isConnectionUsed()
            .then(function (result) {
            if (!result) {
                return;
            }
            _this.externalConnectionsProvider
                .deleteConnection(_this.selectedExternalConnection)
                .then(function () {
                var deletedItem = _.find(_this.externalConnections, function (dto) {
                    return dto.id === _this.selectedExternalConnection.id;
                });
                var deletedItemIdx = _this.externalConnections.indexOf(deletedItem);
                if (deletedItemIdx > -1) {
                    _this.externalConnections.splice(deletedItemIdx, 1);
                    _this.setNewSelected(undefined);
                    var newSelectedConnectionIdx = deletedItemIdx > 0
                        ? deletedItemIdx - 1
                        : 0;
                    if (_this.externalConnections.length > 0) {
                        _this.selectConnection(_this.externalConnections[newSelectedConnectionIdx]);
                    }
                }
                _this.notificationService.showMessage(_this.language.getElementValue('connectionSuccessDeleteMsg'));
            }, function (data) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedDeleteConnectionMsg'), data);
            });
        }, function () { });
    };
    ExternalConnectionsCtrl.prototype.copyConnection = function () {
        var _this = this;
        if (_.isUndefined(this.selectedExternalConnection)) {
            return;
        }
        if (_.isDefined(this.selectedExternalConnection)
            && this.selectedExternalConnection.isChanged) {
            this.showSaveModalInstance()
                .result
                .then(function (data) {
                if (data === 'ok') {
                    _this.saveConnection()
                        .then(function () {
                        _this.copyConnectionImpl();
                    });
                }
                if (data === 'no') {
                    _this.copyConnectionImpl();
                }
                if (data === 'cancel') {
                    return;
                }
            });
        }
        else {
            this.copyConnectionImpl();
        }
    };
    ;
    ExternalConnectionsCtrl.prototype.exportExternalConnections = function () {
        this.exportService.export('/ExternalConnections/ExportExternalConnections');
    };
    ;
    ExternalConnectionsCtrl.prototype.selectConnection = function (connectionSettings) {
        var _this = this;
        if (_.isDefined(this.selectedExternalConnection)
            && this.selectedExternalConnection.id === connectionSettings.id) {
            return;
        }
        if (_.isUndefined(this.selectedExternalConnection)
            || !this.selectedExternalConnection.isChanged) {
            this.setNewSelected(connectionSettings);
        }
        else {
            this.showSaveModalInstance()
                .result
                .then(function (data) {
                if (data === 'ok') {
                    _this.saveConnection()
                        .then(function () {
                        _this.setNewSelected(connectionSettings);
                    });
                }
                if (data === 'no') {
                    _this.setNewSelected(connectionSettings);
                }
                if (data === 'cancel') {
                    return;
                }
            });
        }
    };
    ExternalConnectionsCtrl.prototype.hasConnections = function () {
        return !_.isEmpty(this.externalConnections);
    };
    ExternalConnectionsCtrl.prototype.getConnectionSettingsPagePath = function (connectionType) {
        switch (connectionType) {
            case 6: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/Opc/OpcConnectionSettings.html';
            }
            case 8: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/Http/HttpConnectionSettings.html';
            }
            case 0: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/MsSql/MsSqlConnectionSettings.html';
            }
            case 9: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/Odbc/OdbcConnectionSettings.html';
            }
            case 10: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/InfluxDb/InfluxDbConnectionSettings.html';
            }
            case 2: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/PostgreSql/PostgreSqlConnectionSettings.html';
            }
            case 1: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/Oracle/OracleConnectionSettings.html';
            }
            case 3: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/MySql/MySqlConnectionSettings.html';
            }
            case 5: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/WinCC/WinccConnectionSettings.html';
            }
            case 7: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/File/FileConnectionSettings.html';
            }
            case 11: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/Excel/ExcelConnectionSettings.html';
            }
            case 12: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/OleDb/OleDbConnectionSettings.html';
            }
            case 4: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/WinccOa/WinccOaConnectionSettings.html';
            }
            case 13: {
                return 'ng1/dist/src/ExternalConnections/SourceSettings/Alpha/AlphaConnectionSettings.html';
            }
            default: {
                return '';
            }
        }
    };
    ExternalConnectionsCtrl.prototype.saveConnection = function () {
        var deferred = this.$q.defer();
        if (!this.isConnectionNameUnique(this.selectedExternalConnection.name, this.selectedExternalConnection.id)) {
            this.notificationService.warnMessage(this.language.getElementValue('connectionNameMustBeUniqMsg'));
            deferred.reject(this.language.getElementValue('connectionNameMustBeUniqMsg'));
            return deferred.promise;
        }
        this.save(this.selectedExternalConnection, deferred);
        return deferred.promise;
    };
    ;
    ExternalConnectionsCtrl.prototype.check = function (index) {
        var _this = this;
        this.externalConnectionsProvider.ping(this.selectedExternalConnection, index)
            .then(function (lastConnectionCheck) {
            _this.selectedExternalConnection.specializedSettings[index].state.currentAccessErrorCount = 0;
            _this.selectedExternalConnection.specializedSettings[index].state.lastConnectionCheck = lastConnectionCheck;
            _this.notificationService.showMessage(_this.language.getElementValue('connectionWasOpenedMsg'));
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedConnectToSourceMsg'), data);
        });
    };
    ;
    ExternalConnectionsCtrl.prototype.onSelectConnectionType = function (type) {
        this.selectedExternalConnection.onSetConnectionType();
        this.initConnectionTypeCtrl(type);
    };
    ExternalConnectionsCtrl.prototype.isWinccOaSource = function () {
        return this.selectedExternalConnection.type === 4;
    };
    ExternalConnectionsCtrl.prototype.getLastConnectionAttempt = function (settings) {
        if (settings.state && settings.state.lastConnectionCheck) {
            return this.formatTimezoneFilter(settings.state.lastConnectionCheck, Date.masks.fullDateTime);
        }
        return '-';
    };
    ExternalConnectionsCtrl.prototype.getNextConnectionAttempt = function (settings) {
        if (settings.state && settings.state.lastConnectionCheck) {
            var nextConnectionAttempt = settings.state.lastConnectionCheck
                .clone()
                .addSeconds(this.selectedExternalConnection.retryInterval);
            return this.formatTimezoneFilter(nextConnectionAttempt, Date.masks.fullDateTime);
        }
        return '-';
    };
    ExternalConnectionsCtrl.prototype.resetState = function (settingsId) {
        var _this = this;
        this.externalConnectionsProvider.resetState(this.selectedExternalConnection.id, settingsId)
            .then(function () {
            var specializedSettings = _.find(_this.selectedExternalConnection.specializedSettings, function (settings, idx) { return idx === settingsId; });
            if (specializedSettings) {
                specializedSettings.state.currentAccessErrorCount = 0;
                specializedSettings.state.lastConnectionCheck = null;
            }
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    ExternalConnectionsCtrl.prototype.getConnectionStateMsg = function () {
        return '';
    };
    ExternalConnectionsCtrl.prototype.addNewConnectionSettings = function () {
        this.selectedExternalConnection.addConnectionSettings();
    };
    ExternalConnectionsCtrl.prototype.remove = function (index) {
        if (this.selectedExternalConnection.specializedSettings.length === 1) {
            return;
        }
        this.selectedExternalConnection.specializedSettings.splice(index, 1);
    };
    ExternalConnectionsCtrl.prototype.moveUp = function (index) {
        if (index == 0) {
            return;
        }
        this.selectedExternalConnection.specializedSettings.splice(index - 1, 0, this.selectedExternalConnection.specializedSettings[index]);
        this.selectedExternalConnection.specializedSettings.splice(index + 1, 1);
    };
    ExternalConnectionsCtrl.prototype.moveDown = function (index) {
        if (index === (this.selectedExternalConnection.specializedSettings.length - 1)) {
            return;
        }
        this.selectedExternalConnection.specializedSettings.splice(index + 2, 0, this.selectedExternalConnection.specializedSettings[index]);
        this.selectedExternalConnection.specializedSettings.splice(index, 1);
    };
    ExternalConnectionsCtrl.prototype.hasEditPermission = function () {
        return this.authentication.hasPermission(this.permissions.ExternalConnectionEdit);
    };
    ExternalConnectionsCtrl.prototype.isConnectionNameUnique = function (connectionName, connectionId) {
        if (_.any(this.externalConnections, function (dto) {
            return (connectionName === dto.name && dto.id !== connectionId);
        })) {
            return false;
        }
        return true;
    };
    ;
    ExternalConnectionsCtrl.prototype.showSaveModalInstance = function () {
        var _this = this;
        var originalConnection = _.find(this.externalConnections, function (dto) {
            return dto.id === _this.selectedExternalConnection.id;
        });
        return this.$modal.open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoCancelModal.html',
            controller: 'yesNoCancelModalCtrl',
            backdrop: 'static',
            resolve: {
                header: function () {
                    return _this.language.getElementValue('externalConnectionModalHdr');
                },
                body: function () {
                    return String.Format(_this.language.getElementValue('saveExternalConnectionSettingsChangesModalQuestionHdr'), originalConnection.name);
                }
            }
        });
    };
    ;
    ExternalConnectionsCtrl.prototype.getAllConnections = function () {
        var _this = this;
        this.externalConnectionsProvider.getAll().then(function (connections) {
            _this.initExternalConnections(connections);
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
    };
    ;
    ExternalConnectionsCtrl.prototype.createConnectionImpl = function () {
        var _this = this;
        var uniqueName = this.getUniqueName(_.map(this.externalConnections, function (dto) { return dto.name; }), this.uniqueNamePattern);
        this.externalConnectionsProvider.createDefaultConnection(uniqueName).then(function (data) {
            _this.externalConnections.push(data);
            _this.setNewSelected(data);
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedCreateConnectionMsg'), data);
        });
    };
    ExternalConnectionsCtrl.prototype.copyConnectionImpl = function () {
        var _this = this;
        var clone = ExternalConnectionSettings.clone(this.selectedExternalConnection);
        clone.id = this.guid.new();
        var uniqueName = this.getUniqueName(_.map(this.externalConnections, function (dto) { return dto.name; }), String.Format(this.language.getElementValue('copyHdr'), clone.name));
        clone.name = uniqueName;
        this.externalConnectionsProvider.createConnection(clone).then(function (data) {
            _this.externalConnections.push(data);
            _this.setNewSelected(data);
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedCreateConnectionMsg'), data);
        });
    };
    ExternalConnectionsCtrl.prototype.save = function (connection, deferred) {
        var _this = this;
        this.externalConnectionsProvider
            .saveChange(connection)
            .then(function () {
            _this.selectedExternalConnection.isChanged = false;
            _this.refreshOriginalConnections(_this.selectedExternalConnection);
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
            deferred.resolve(_this.selectedExternalConnection);
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveChangesMsg'), data);
            deferred.reject(data);
        });
    };
    ExternalConnectionsCtrl.prototype.selectNewConnectionType = function (connectionType) {
        if (_.isDefined(this.connectionTypeCtrl)) {
            this.connectionTypeCtrl.destroy();
        }
        this.onSelectConnectionType(connectionType);
    };
    ;
    ExternalConnectionsCtrl.prototype.initExternalConnections = function (connections) {
        this.externalConnections = connections;
        if (_.any(this.externalConnections)) {
            this.selectedExternalConnection
                = new ExternalConnectionSettings(this.scope, this.externalConnections[0]);
            this.initConnectionTypeCtrl(this.selectedExternalConnection.type);
        }
    };
    ;
    ExternalConnectionsCtrl.prototype.setNewSelected = function (connectionSettings) {
        if (_.isDefined(this.selectedExternalConnection)) {
            this.selectedExternalConnection.destroy();
        }
        if (_.isDefined(connectionSettings)) {
            this.selectedExternalConnection = new ExternalConnectionSettings(this.scope, connectionSettings);
            this.initConnectionTypeCtrl(connectionSettings.type);
        }
        else {
            this.selectedExternalConnection = undefined;
        }
    };
    ExternalConnectionsCtrl.prototype.initConnectionTypeCtrl = function (type) {
        var _this = this;
        if (this.connectionTypeCtrl) {
            this.connectionTypeCtrl.destroy();
            this.connectionTypeCtrl = null;
        }
        switch (type) {
            case 0:
                this.connectionTypeCtrl = new MsSqlConnectionCtrl();
                break;
            case 7:
                this.connectionTypeCtrl = new FileConnectionCtrl();
                break;
            case 1:
                this.connectionTypeCtrl = new OracleConnectionCtrl();
                break;
            case 8:
                this.connectionTypeCtrl = new HttpConnectionCtrl();
                break;
            case 9:
                this.connectionTypeCtrl = new OdbcConnectionCtrl();
                break;
            case 6:
                this.connectionTypeCtrl = new OpcConnectionCtrl(this.$modal, this.language);
                break;
            case 10:
                this.connectionTypeCtrl = new InfluxDbConnectionCtrl(this.language);
                break;
            case 2:
                this.connectionTypeCtrl = new PostgreSqlConnectionCtrl();
                break;
            case 3:
                this.connectionTypeCtrl = new MySqlConnectionCtrl();
                break;
            case 11:
                this.connectionTypeCtrl = new ExcelConnectionCtrl();
                break;
            case 5:
                this.connectionTypeCtrl = new WinccConnectionCtrl();
                break;
            case 12:
                this.connectionTypeCtrl = new OleDbConnectionCtrl();
                break;
            case 4:
                this.connectionTypeCtrl = new WinccOaConnectionCtrl(this.language);
                break;
            case 13:
                this.connectionTypeCtrl = new AlphaConnectionCtrl();
                break;
        }
        if (this.connectionTypeCtrl) {
            this.connectionTypeCtrl.init();
            this.http.get(this.clientSettings.getServerInstance() + '/ExternalConnections/GetState', { params: { guid: this.selectedExternalConnection.id } })
                .then(function (response) {
                _.forEach(_this.selectedExternalConnection.specializedSettings, function (settings, idx) {
                    settings.state = response.data[idx]
                        ? { currentAccessErrorCount: response.data[idx].currentAccessErrorCount, lastConnectionCheck: response.data[idx].lastConnectionCheck }
                        : { currentAccessErrorCount: 0, lastConnectionCheck: null };
                });
            })
                .catch(function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
            });
        }
    };
    ExternalConnectionsCtrl.prototype.getUniqueName = function (names, name) {
        var i = 1;
        while (names.indexOf(name + ' ' + i) !== -1) {
            i++;
        }
        return name + ' ' + i;
    };
    ;
    ExternalConnectionsCtrl.$inject = [
        '$rootScope',
        '$scope',
        '$q',
        '$window',
        '$modal',
        '$http',
        '$location',
        '$upload',
        'notificationService',
        'language',
        'externalConnectionsProvider',
        'reportTemplateProvider',
        'switchoverFormConfigurationProvider',
        'operationTimeConfigurationProvider',
        'exportService',
        'clientSettings',
        'guid',
        'formatTimezoneFilter',
        'authentication',
        'permissionService',
        'licenseStorage'
    ];
    return ExternalConnectionsCtrl;
}());
angular
    .module('kamhpp')
    .component('externalConnections', new ExternalConnectionsComponent());
