var OpcConnectionCtrl = (function () {
    function OpcConnectionCtrl(modalService, language) {
        this.modalService = modalService;
        this.language = language;
        this.opcStandards = [
            { id: 0, name: 'DA' },
            { id: 1, name: 'HDA' },
            { id: 2, name: 'UA' },
        ];
        this.opcAuthenticationTypes = [
            {
                id: 0,
                name: this.language.getElementValue('opcAnonymousAuthenticationTypeHdr'),
            },
            {
                id: 1,
                name: this.language.getElementValue('opcUsernameAndPasswordAuthenticationTypeHdr'),
            },
            {
                id: 2,
                name: this.language.getElementValue('opcCertificateAuthenticationTypeHdr'),
            },
        ];
        this.opcUaSecurityModes = [
            { id: 0, name: this.language.getElementValue('opcUaWithoutSecurityModeHdr') },
            { id: 1, name: this.language.getElementValue('opcUaSignMessagesPolicyHdr') },
            {
                id: 2,
                name: this.language.getElementValue('opcUaSignMessagesAndEncryptPolicyHdr'),
            },
        ];
        this.opcUaSecurityPolicies = [
            { id: 0, name: this.language.getElementValue('opcUaWithoutSecurityPolicyHdr') },
            { id: 1, name: 'Basic128Rsa15' },
            { id: 2, name: 'Basic256' },
            { id: 3, name: 'Basic256Sha256' },
            { id: 4, name: 'Aes128_Sha256_RsaOaep' },
            { id: 5, name: 'Aes256_Sha256_RsaPss' },
        ];
    }
    OpcConnectionCtrl.prototype.init = function () { };
    OpcConnectionCtrl.prototype.destroy = function () { };
    OpcConnectionCtrl.prototype.isOpcUaStandard = function (standard) {
        return standard === 2;
    };
    OpcConnectionCtrl.prototype.filterAuthenticationTypeByOpcStandard = function (opcStandard) {
        return function (authenticationType) {
            if (!authenticationType) {
                return false;
            }
            switch (opcStandard) {
                case 0:
                case 1:
                    return (authenticationType.id === 0 ||
                        authenticationType.id === 1);
                default:
                    return true;
            }
        };
    };
    OpcConnectionCtrl.prototype.exploreServers = function (opcConnection) {
        var modalInstance = this.modalService.open({
            templateUrl: 'ng1/dist/src/ExternalConnections/SourceSettings/Opc/ServersExplorerModal/OpcServersExplorerModalCtrl.html',
            controller: 'opcServersExplorerModalCtrl',
            windowClass: 'app-modal-window level-two',
            backdrop: 'static',
            resolve: {
                opcStandard: function () { return opcConnection.standard; }
            },
        });
        if (opcConnection.standard === 2) {
            modalInstance.result.then(function (data) {
                opcConnection.endpoint = data.endpoint;
                opcConnection.securityMode = data.securityMode;
                opcConnection.securityPolicy = data.securityPolicy;
            });
        }
        else {
            modalInstance.result.then(function (data) {
                opcConnection.path = data.path;
                opcConnection.hostName = data.host;
            });
        }
    };
    OpcConnectionCtrl.prototype.isUsernameAndPasswordAuthenticationType = function (authenticationType) {
        return authenticationType === 1;
    };
    OpcConnectionCtrl.prototype.isCertificateAuthenticationType = function (authenticationType) {
        return authenticationType === 2;
    };
    return OpcConnectionCtrl;
}());
