var AlphaConnection = (function () {
    function AlphaConnection() {
        this.runtimeNode = new AlphaRuntimeNode();
        this.hasHistoryNode = true;
        this.historyNode = new AlphaHistoryNode();
    }
    AlphaConnection.isEqual = function (alphaConnection, other) {
        if (_.isUndefined(alphaConnection) || _.isUndefined(other)) {
            return false;
        }
        return alphaConnection.hasHistoryNode === other.hasHistoryNode
            && AlphaRuntimeNode.isEqual(alphaConnection.runtimeNode, other.runtimeNode)
            && AlphaHistoryNode.isEqual(alphaConnection.historyNode, other.historyNode);
    };
    return AlphaConnection;
}());
var AlphaRuntimeNode = (function () {
    function AlphaRuntimeNode() {
        this.timeout = 5000;
        this.endpoint = new AlphaTcpEndpoint(4388);
    }
    AlphaRuntimeNode.isEqual = function (runtimeNode, other) {
        if (_.isUndefined(runtimeNode) || _.isUndefined(other)) {
            return false;
        }
        return runtimeNode.password === other.password
            && runtimeNode.timeout === other.timeout
            && AlphaTcpEndpoint.isEqual(runtimeNode.endpoint, other.endpoint);
    };
    return AlphaRuntimeNode;
}());
var AlphaTcpEndpoint = (function () {
    function AlphaTcpEndpoint(port, host) {
        if (port === void 0) { port = 4949; }
        if (host === void 0) { host = 'localhost'; }
        this.port = port;
        this.host = host;
    }
    AlphaTcpEndpoint.isEqual = function (enpoint, other) {
        if (_.isUndefined(enpoint) || _.isUndefined(other)) {
            return false;
        }
        return enpoint.port === other.port && enpoint.host === other.host;
    };
    return AlphaTcpEndpoint;
}());
var AlphaHistoryNode = (function () {
    function AlphaHistoryNode() {
        this.endpoints = [];
        this.alias = 'default';
        this.isReadOnly = true;
        this.sessionEstablishmentTimeout = 2000;
        this.operationTimeout = 2000;
        this.maxBufferPoolSize = 8 * 1024 * 1024 * 32;
    }
    AlphaHistoryNode.isEqual = function (historyNode, other) {
        if (_.isUndefined(historyNode) || _.isUndefined(other)) {
            return false;
        }
        if (historyNode.endpoints.length !== other.endpoints.length) {
            return false;
        }
        for (var i = 0; i < historyNode.endpoints.length; i++) {
            if (!AlphaTcpEndpoint.isEqual(historyNode.endpoints[i], other.endpoints[i])) {
                return false;
            }
        }
        return historyNode.alias === other.alias
            && historyNode.isReadOnly === other.isReadOnly
            && historyNode.sessionEstablishmentTimeout === other.sessionEstablishmentTimeout
            && historyNode.operationTimeout === other.operationTimeout
            && historyNode.maxBufferPoolSize === other.maxBufferPoolSize;
    };
    return AlphaHistoryNode;
}());
