var ExternalConnectionSettings = (function () {
    function ExternalConnectionSettings(scope, externalConnectionSettings) {
        this.isChanged = false;
        this.watchFunctions = [];
        this.id = externalConnectionSettings.id;
        this.name = externalConnectionSettings.name;
        this.type = externalConnectionSettings.type;
        this.retryCount = externalConnectionSettings.retryCount;
        this.retryInterval = externalConnectionSettings.retryInterval;
        this.specializedSettings = _.deepclone(externalConnectionSettings.specializedSettings);
        var self = this;
        this.watchFunctions = [];
        this.watchFunctions.push(scope.$watch(function () {
            return self;
        }, function (after, before) {
            if (_.isUndefined(after) || after === before) {
                return;
            }
            if (ExternalConnectionSettings.isEqual(after, before)) {
                return;
            }
            self.isChanged = true;
        }, true));
    }
    ExternalConnectionSettings.prototype.destroy = function () {
        _.forEach(this.watchFunctions, function (func) {
            if (!_.isUndefined(func)) {
                func();
            }
        });
    };
    ExternalConnectionSettings.clone = function (original) {
        if (_.isUndefined(original)) {
            return original;
        }
        var clone = {
            id: original.id,
            name: original.name,
            type: original.type,
            retryCount: original.retryCount,
            retryInterval: original.retryInterval,
            specializedSettings: _.deepclone(original.specializedSettings),
        };
        return clone;
    };
    ExternalConnectionSettings.isEqual = function (externalConnectionSettings, other) {
        if (externalConnectionSettings.name !== other.name || externalConnectionSettings.type !== other.type
            || externalConnectionSettings.retryCount !== other.retryCount
            || externalConnectionSettings.retryInterval !== other.retryInterval) {
            return false;
        }
        if (externalConnectionSettings.specializedSettings.length !== other.specializedSettings.length) {
            return false;
        }
        var specializedSettingsEquals = true;
        for (var i = 0; i < externalConnectionSettings.specializedSettings.length; i++) {
            var connectionSettings = externalConnectionSettings.specializedSettings[i];
            var otherConnectionSettings = other.specializedSettings[i];
            switch (externalConnectionSettings.type) {
                case 0:
                    specializedSettingsEquals = MsSqlConnection.isEqual(connectionSettings.msSql, otherConnectionSettings.msSql);
                    break;
                case 7:
                    specializedSettingsEquals = FileConnection.isEqual(connectionSettings.file, otherConnectionSettings.file);
                    break;
                case 1:
                    specializedSettingsEquals = OracleConnection.isEqual(connectionSettings.oracle, otherConnectionSettings.oracle);
                    break;
                case 8:
                    specializedSettingsEquals = HttpConnection.isEqual(connectionSettings.http, otherConnectionSettings.http);
                    break;
                case 9:
                    specializedSettingsEquals = OdbcConnection.isEqual(connectionSettings.odbc, otherConnectionSettings.odbc);
                    break;
                case 6:
                    specializedSettingsEquals = OpcConnection.isEqual(connectionSettings.opc, otherConnectionSettings.opc);
                    break;
                case 10:
                    specializedSettingsEquals = InfluxDbConnection.isEqual(connectionSettings.influx, otherConnectionSettings.influx);
                    break;
                case 2:
                    specializedSettingsEquals = PostgreSqlConnection.isEqual(connectionSettings.postgreSql, otherConnectionSettings.postgreSql);
                    break;
                case 3:
                    specializedSettingsEquals = MySqlConnection.isEqual(connectionSettings.mySql, otherConnectionSettings.mySql);
                    break;
                case 11:
                    specializedSettingsEquals = ExcelConnectionSettings.isEqual(connectionSettings.excel, otherConnectionSettings.excel);
                    break;
                case 5:
                    specializedSettingsEquals = WinccConnection.isEqual(connectionSettings.wincc, otherConnectionSettings.wincc);
                    break;
                case 12:
                    specializedSettingsEquals = OleDbConnection.isEqual(connectionSettings.oleDb, otherConnectionSettings.oleDb);
                    break;
                case 4:
                    specializedSettingsEquals = WinccOaConnection.isEqual(connectionSettings.winccOa, otherConnectionSettings.winccOa);
                    break;
                case 13:
                    specializedSettingsEquals = AlphaConnection.isEqual(connectionSettings.alpha, otherConnectionSettings.alpha);
                    break;
            }
            if (!specializedSettingsEquals) {
                return false;
            }
        }
        return specializedSettingsEquals;
    };
    ExternalConnectionSettings.prototype.onSetConnectionType = function () {
        var connectionSettings = this.createNewConnectionSettings();
        this.specializedSettings = [connectionSettings];
        switch (this.type) {
            case 0:
                connectionSettings.msSql = new MsSqlConnection();
                break;
            case 7:
                connectionSettings.file = new FileConnection();
                break;
            case 1:
                connectionSettings.oracle = new OracleConnection();
                break;
            case 8:
                connectionSettings.http = new HttpConnection();
                break;
            case 9:
                connectionSettings.odbc = new OdbcConnection();
                break;
            case 6:
                connectionSettings.opc = new OpcConnection();
                break;
            case 10:
                connectionSettings.influx = new InfluxDbConnection();
                break;
            case 2:
                connectionSettings.postgreSql = new PostgreSqlConnection();
                break;
            case 3:
                connectionSettings.mySql = new MySqlConnection();
                break;
            case 11:
                connectionSettings.excel = new ExcelConnectionSettings();
                break;
            case 5:
                connectionSettings.wincc = new WinccConnection();
                break;
            case 12:
                connectionSettings.oleDb = new OleDbConnection();
                break;
            case 4:
                connectionSettings.winccOa = new WinccOaConnection();
                break;
            case 13:
                connectionSettings.alpha = new AlphaConnection();
                break;
        }
    };
    ExternalConnectionSettings.prototype.addConnectionSettings = function () {
        this.specializedSettings.push(this.createNewConnectionSettings());
    };
    ExternalConnectionSettings.prototype.createNewConnectionSettings = function () {
        var connectionSettings = {};
        connectionSettings.state = { currentAccessErrorCount: 0 };
        switch (this.type) {
            case 0:
                connectionSettings.msSql = new MsSqlConnection();
                break;
            case 7:
                connectionSettings.file = new FileConnection();
                break;
            case 1:
                connectionSettings.oracle = new OracleConnection();
                break;
            case 8:
                connectionSettings.http = new HttpConnection();
                break;
            case 9:
                connectionSettings.odbc = new OdbcConnection();
                break;
            case 6:
                connectionSettings.opc = new OpcConnection();
                break;
            case 10:
                connectionSettings.influx = new InfluxDbConnection();
                break;
            case 2:
                connectionSettings.postgreSql = new PostgreSqlConnection();
                break;
            case 3:
                connectionSettings.mySql = new MySqlConnection();
                break;
            case 11:
                connectionSettings.excel = new ExcelConnectionSettings();
                break;
            case 5:
                connectionSettings.wincc = new WinccConnection();
                break;
            case 12:
                connectionSettings.oleDb = new OleDbConnection();
                break;
            case 4:
                connectionSettings.winccOa = new WinccOaConnection();
                break;
            case 13:
                connectionSettings.alpha = new AlphaConnection();
                break;
        }
        return connectionSettings;
    };
    return ExternalConnectionSettings;
}());
