var LicenseWindowController = (function () {
    function LicenseWindowController($scope, $rootScope, $modalInstance, dateFilter, $http, notificationService, language, licenseProvider, authentication, licenseStorage, coreConfigurationProvider, browserInfoProvider, canBeClosed, licenseState, missingModules, errorMessage) {
        var _this = this;
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$modalInstance = $modalInstance;
        this.dateFilter = dateFilter;
        this.$http = $http;
        this.notificationService = notificationService;
        this.language = language;
        this.licenseProvider = licenseProvider;
        this.authentication = authentication;
        this.licenseStorage = licenseStorage;
        this.browserInfoProvider = browserInfoProvider;
        this.canBeClosed = canBeClosed;
        this.serverId = '';
        this.licenseKey = '';
        this.licenseState = '';
        this.missingModules = '';
        this.modalHeader = this.language.getElementValue('licenceWindowsActivationLicenceHdr');
        this.source = null;
        this.$scope.ctrl = this;
        this.licenseProvider
            .getSource()
            .then(function (source) {
            _this.source = source;
            if (source === 0) {
                coreConfigurationProvider
                    .getServerId()
                    .then(function (serverId) { return (_this.serverId = serverId); })
                    .catch(function (error) {
                    return _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
                });
            }
        });
        this.showLicenseInfo(this.stateFromString(licenseState), missingModules, { errorMessage: errorMessage });
    }
    LicenseWindowController.prototype.activateLicense = function (licenseKey) {
        var _this = this;
        this.licenseProvider
            .activateLicense(licenseKey)
            .then(function (license) {
            var licenseStateType = +license.state;
            _this.showLicenseInfo(licenseStateType, '', license);
            if (licenseStateType !== 1) {
                return;
            }
            _this.licenseStorage.save(license);
            _this.$rootScope.$broadcast('licenseActivated', { ownerName: license.ownerName });
            _this.authentication.logout();
        })
            .catch(function (error) {
            _this.notificationService.warnMessage(_this.language.getElementValue('licenceWindowsFailedActivatedMsg'), error);
        });
    };
    LicenseWindowController.prototype.isLicenseFromFile = function () {
        return this.source === 0;
    };
    LicenseWindowController.prototype.getDemoLicense = function () {
        var _this = this;
        this.$http
            .get("https://sms-technodoc.ru/api/v1/license/createDemo?sourceId=".concat(this.serverId))
            .then(function (response) {
            _this.licenseKey = response.data;
        }, function () { return _this.notificationService.errorMessage(_this.language.getElementValue('licenceWindowsConnectionToLicenseServerErrorMsg')); });
    };
    LicenseWindowController.prototype.cancel = function () {
        this.$modalInstance.close('ok');
    };
    LicenseWindowController.prototype.showLicenseInfo = function (licenseState, missingModule, license) {
        if (license === void 0) { license = null; }
        switch (licenseState) {
            case 0: {
                this.modalHeader = this.language.getElementValue('exceptionLicenseWindowsHdr');
                this.licenseState = this.language.getElementValue('licenceWindowsFailedToReceiveLicenseDataMsg');
                break;
            }
            case 1: {
                this.close();
                this.notificationService.showMessage(this.language.getElementValue('licenceWindowsSuccessActivatedMsg'));
                break;
            }
            case 2: {
                this.modalHeader = this.language.getElementValue('licenceWindowsActivationLicenceHdr');
                this.licenseState = '';
                break;
            }
            case 3: {
                this.modalHeader = this.language.getElementValue('exceptionLicenseWindowsHdr');
                this.updateExpiredLicenseMsg(license);
                break;
            }
            case 5: {
                this.modalHeader = this.language.getElementValue('exceptionLicenseWindowsHdr');
                this.licenseState = this.language.getElementValue('licenceWindowsLicenseServerIdMismatchMsg');
                break;
            }
            case 4: {
                this.modalHeader = this.language.getElementValue('exceptionLicenseWindowsHdr');
                this.licenseState = this.language.getElementValue('licenceWindowsLicenseCorruptedMsg');
                break;
            }
            case 6: {
                this.modalHeader = this.language.getElementValue('exceptionLicenseWindowsHdr');
                this.licenseState = this.language.getElementValue('licenceWindowsLicenseServerTimeMismatchMsg');
                break;
            }
            case 7: {
                this.modalHeader = this.language.getElementValue('exceptionLicenseWindowsHdr');
                this.licenseState = this.language.getElementValue('licenceWindowsLicenseSignatureMismatchMsg');
                break;
            }
            case 8: {
                this.modalHeader = this.language.getElementValue('exceptionLicenseWindowsHdr');
                this.licenseState = license === null || license === void 0 ? void 0 : license.errorMessage;
                break;
            }
        }
        if (missingModule) {
            this.missingModules = String.Format(this.language.getElementValue('licenceWindowsFailedToLoadLicenceModuleMsg'), missingModule);
        }
    };
    LicenseWindowController.prototype.close = function () {
        this.$modalInstance.close('ok');
    };
    LicenseWindowController.prototype.updateExpiredLicenseMsg = function (license) {
        var _this = this;
        if (license !== null) {
            this.showExpiredLicenseMsg(license);
        }
        else {
            this.licenseProvider
                .getLicense()
                .then(function (license) {
                if (license === undefined || license === null) {
                    _this.licenseState = _this.language.getElementValue('licenceWindowsFailedToReceiveLicenseDataMsg');
                    return;
                }
                _this.showExpiredLicenseMsg(license);
            })
                .catch(function (error) {
                _this.notificationService.errorMessage(_this.language.getElementValue('licenceWindowsFailedToReceiveLicenseDataMsg'), error);
            });
        }
    };
    LicenseWindowController.prototype.stateFromString = function (licenseState) {
        var state;
        switch (licenseState) {
            case 'undefined':
                state = 0;
                break;
            case 'valid':
                state = 1;
                break;
            case 'notactivated':
                state = 2;
                break;
            case 'expired':
                state = 3;
                break;
            case 'sourceidmismatch':
                state = 5;
                break;
            case 'corrupted':
                state = 4;
                break;
            case 'servertimemismatch':
                state = 6;
                break;
            case 'failedtoload':
                state = 8;
                break;
        }
        return state;
    };
    LicenseWindowController.prototype.showExpiredLicenseMsg = function (license) {
        var dateStr = this.dateFilter(license.expirationDate, Date.masks.shortDateWithPoint);
        this.licenseState =
            new Date() < license.creationDate
                ? this.language.getElementValue('adminServerTimeErrorDetectedHdr') + '.'
                : this.language.getElementValue('adminLicenseHasEndHdr') + dateStr + '.';
    };
    LicenseWindowController.$inject = [
        '$scope',
        '$rootScope',
        '$modalInstance',
        'dateFilter',
        '$http',
        'notificationService',
        'language',
        'licenseProvider',
        'authentication',
        'licenseStorage',
        'coreConfigurationProvider',
        'browserInfoProvider',
        'canBeClosed',
        'licenseState',
        'missingModules',
        'errorMessage'
    ];
    return LicenseWindowController;
}());
angular.module('kamhpp').controller('licenseWindowController', LicenseWindowController);
