var messageStatuses;
(function (messageStatuses) {
    messageStatuses["All"] = "mailsAllHdr";
    messageStatuses["Sent"] = "mailStatusSent";
    messageStatuses["Await"] = "mailAwaitingSent";
    messageStatuses["Unsent"] = "mailFailedToSent";
})(messageStatuses || (messageStatuses = {}));
var MailsLogDiagnosticCtrl = (function () {
    function MailsLogDiagnosticCtrl(mailProvider, notificationService, language, $modal) {
        var _this = this;
        this.mailProvider = mailProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.$modal = $modal;
        this.messageStatuses = [messageStatuses.All, messageStatuses.Sent, messageStatuses.Await, messageStatuses.Unsent];
        this.sentMails = [];
        this.selectedStatus = messageStatuses.All;
        this.dateFormat = Date.masks.fullDateTime;
        this.startDate = new Date().addDays(-7);
        this.endDate = new Date();
        this.sort = {
            columnName: 'sendingDate',
            descending: true
        };
        this.filterFunction = function (mail) {
            if (_this.filterByStatus(mail) &&
                (!_this.searchText ||
                    mail.subject.toLowerCase().includes(_this.searchText.toLowerCase()) ||
                    _.any(mail.recipients, function (recipient) {
                        return recipient.toLowerCase().includes(_this.searchText.toLowerCase());
                    }))) {
                return mail;
            }
        };
        this.loadConfiguration();
        this.loadMails();
    }
    MailsLogDiagnosticCtrl.prototype.loadConfiguration = function () {
        var _this = this;
        this.mailProvider
            .getMailClientConfiguration()
            .then(function (coniguration) {
            _this.sendAttempts = coniguration.sendAttempts;
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
    };
    MailsLogDiagnosticCtrl.prototype.deleteMail = function (mail) {
        var _this = this;
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/Common/Components/YesNoModal.html',
            controller: 'yesNoModalCtrl',
            backdrop: 'static',
            resolve: {
                header: function () { return _this.language.getElementValue('mailDeleteModalHdr'); },
                body: function () { return String.Format(_this.language.getElementValue('mailDeleteModalQuestionHdr'), mail.subject); }
            }
        })
            .result.then(function () {
            var mailToDelete = { messageId: mail.messageId, attachments: mail.attachments, subject: mail.subject };
            _this.mailProvider.deleteMail(mailToDelete).then(function () {
                _this.sentMails = _.filter(_this.sentMails, function (m) { return m.messageId !== mail.messageId; });
                _this.onRefresh();
            });
        });
    };
    MailsLogDiagnosticCtrl.prototype.isMailSent = function (status) {
        return status == 0;
    };
    MailsLogDiagnosticCtrl.prototype.getStatusTitle = function (mail) {
        switch (mail.status) {
            case 0:
                return this.language.getElementValue('mailStatusSent');
            case 1:
                return (this.language.getElementValue('mailAwaitingSent') +
                    ' ' +
                    '(' +
                    mail.sendAttempts +
                    '/' +
                    this.sendAttempts +
                    ')');
            case 2:
                return this.language.getElementValue('mailFailedToSent');
            default:
                return '';
        }
    };
    MailsLogDiagnosticCtrl.prototype.changeSorting = function (columnName) {
        if (this.sort.columnName === columnName) {
            this.sort.descending = !this.sort.descending;
        }
        else {
            this.sort.columnName = columnName;
            this.sort.descending = false;
        }
    };
    MailsLogDiagnosticCtrl.prototype.loadMails = function () {
        var _this = this;
        this.mailProvider.getAllMails(this.startDate, this.endDate).then(function (messagesInfo) {
            _this.sentMails = _.map(messagesInfo, function (messageInfo) {
                var mail = _.deepclone(messageInfo);
                if (mail.needArchive) {
                    mail.attachments = _.map(mail.attachments, function (attachment) {
                        if (!attachment.endsWith('.zip')) {
                            return attachment + '.zip';
                        }
                    });
                }
                mail.recipientsString = mail.recipients.join(', ');
                mail.attachmentsString = mail.attachments.join(', ');
                return mail;
            });
            _this.onRefresh();
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('mailsLogFailedToGetlistOfDocumentsMsg'), error);
        });
    };
    MailsLogDiagnosticCtrl.prototype.filterByStatus = function (mail) {
        return (this.selectedStatus === messageStatuses.All ||
            (this.selectedStatus === messageStatuses.Sent && mail.status == 0) ||
            (this.selectedStatus === messageStatuses.Unsent && mail.status == 2) ||
            (this.selectedStatus === messageStatuses.Await && mail.status == 1));
    };
    MailsLogDiagnosticCtrl.$inject = ['mailProvider', 'notificationService', 'language', '$modal'];
    return MailsLogDiagnosticCtrl;
}());
angular.module('kamhpp').controller('MailsLogDiagnosticCtrl', MailsLogDiagnosticCtrl);
