var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var SwitchoverFormConfigurationCtrl = (function (_super) {
    __extends(SwitchoverFormConfigurationCtrl, _super);
    function SwitchoverFormConfigurationCtrl($scope, switchoverFormConfigurationProvider, ckeditorConfigurationProvider, notificationService, language, modal) {
        var _this = _super.call(this, $scope) || this;
        _this.$scope = $scope;
        _this.switchoverFormConfigurationProvider = switchoverFormConfigurationProvider;
        _this.ckeditorConfigurationProvider = ckeditorConfigurationProvider;
        _this.notificationService = notificationService;
        _this.language = language;
        _this.modal = modal;
        _this.opcConnectionTypes = [6];
        _this.winccOaConnectionTypes = [4];
        _this.fileTypes = [
            { ident: 1, name: 'PDF' },
            { ident: 6, name: 'DOCX' },
        ];
        _this.selectedFileType = _this.fileTypes[0];
        _this.remoteControlKeySources = [
            { ident: 1, name: _this.language.getElementValue('winccoaHdr') },
            { ident: 0, name: _this.language.getElementValue('opcSourceHdr') },
        ];
        _this.editorConfiguration = _this.ckeditorConfigurationProvider.getEditorConfiguration();
        _this.loadConfiguration();
        _this.editorConfiguration.config.height = 350;
        return _this;
    }
    SwitchoverFormConfigurationCtrl.prototype.loadConfiguration = function () {
        var _this = this;
        this.switchoverFormConfigurationProvider
            .getSwitchoverFormConfiguration()
            .then(function (configuration) {
            _this.configuration = configuration;
            _this.selectedFileType = _.find(_this.fileTypes, function (type) { return type.ident === configuration.exportConfiguration.fileType; });
            _this.selectedRemoteControlKeySource = _.find(_this.remoteControlKeySources, function (source) { return source.ident === _this.configuration.remoteControlKeyConfiguration.source; });
        }).
            catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    SwitchoverFormConfigurationCtrl.prototype.saveConfiguration = function () {
        var _this = this;
        if ((this.configuration.exportConfiguration.saveSwitchoverFormWhenStoppedOrClosed
            && _.isBlank(this.configuration.exportConfiguration.filePath))
            || (this.configuration.remoteControlKeyConfiguration.isRemoteControlKeyVerificationEnabled
                && (_.isBlank(this.configuration.remoteControlKeyConfiguration.remoteControlKeyReferenceValue)
                    || _.isBlank(this.configuration.remoteControlKeyConfiguration.remoteControlKeyTagAddress)))) {
            this.notificationService.warnMessage(this.language.getElementValue('allFieldsMustFilledMsg'));
            return;
        }
        return this.switchoverFormConfigurationProvider
            .saveSwitchoverFormConfiguration(this.configuration)
            .then(function () {
            _this.hasChanges = false;
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
        })
            .catch(function (error) { return _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveChangesMsg'), error); });
        ;
    };
    SwitchoverFormConfigurationCtrl.prototype.onConfigurationChanged = function () {
        this.hasChanges = true;
    };
    SwitchoverFormConfigurationCtrl.prototype.onTemplateChange = function (newValue, oldValue) {
        if (_.isUndefined(oldValue) || newValue === oldValue) {
            return;
        }
        this.onConfigurationChanged();
    };
    SwitchoverFormConfigurationCtrl.prototype.onExportFileTypeChanged = function () {
        this.configuration.exportConfiguration.fileType = this.selectedFileType.ident;
        this.onConfigurationChanged();
    };
    SwitchoverFormConfigurationCtrl.prototype.onRemoteControlKeyVerificationSourceChanged = function () {
        this.configuration.remoteControlKeyConfiguration.source = this.selectedRemoteControlKeySource.ident;
        this.onConfigurationChanged();
    };
    SwitchoverFormConfigurationCtrl.prototype.isTagExists = function () {
        var _this = this;
        this.switchoverFormConfigurationProvider
            .isTagExists(this.configuration.remoteControlKeyConfiguration.remoteControlKeyTagAddress, this.configuration.remoteControlKeyConfiguration.source)
            .then(function (data) {
            if (data) {
                _this.notificationService.showMessage(_this.language.getElementValue('tagAddressIsExistMsg'));
            }
            else {
                _this.notificationService.errorMessage(_this.language.getElementValue('tagAddressIsNotExistMsg'));
            }
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('errorCheckTagAddressMsg'), result);
        });
    };
    SwitchoverFormConfigurationCtrl.prototype.isWinccOaSource = function () {
        return this.configuration.remoteControlKeyConfiguration.source === 1;
    };
    SwitchoverFormConfigurationCtrl.prototype.selectTag = function (source) {
        var _this = this;
        var tagTreeTypes = source === 0
            ? [TagTreeType.Opc]
            : [TagTreeType.WinccOaCns, TagTreeType.WinccOaPara];
        var connectionGuid = source === 0
            ? this.configuration.opcConnectionGuid
            : this.configuration.winccOaConnectionGuid;
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/TagsTree/TagsTreeModal.html',
            controller: 'tagsTreeModalCtrl',
            windowClass: 'app-modal-window modal-wide modal-width-100 modal-tab-window level-two',
            backdrop: 'static',
            resolve: {
                connectionGuid: function () { return connectionGuid; },
                isMultiselectEnabled: function () { return false; },
                tagTreeTypes: function () { return tagTreeTypes; },
                tagAddress: function () { return _this.configuration.remoteControlKeyConfiguration.remoteControlKeyTagAddress; },
            },
        });
        modalInstance.result.then(function (tags) {
            _this.configuration.remoteControlKeyConfiguration.remoteControlKeyTagAddress = tags[0].address;
        }, function () { });
    };
    SwitchoverFormConfigurationCtrl.prototype.addStepExecutionSafeIpAddress = function () {
        var defaultIp = '255.255.255.255';
        if (_.isUndefined(this.configuration.stepExecutionSafeIpAddresses)) {
            this.configuration.stepExecutionSafeIpAddresses = [defaultIp];
        }
        else {
            this.configuration.stepExecutionSafeIpAddresses.push(defaultIp);
        }
    };
    SwitchoverFormConfigurationCtrl.$inject = [
        '$scope',
        'switchoverFormConfigurationProvider',
        'switchoverFormsCkeditorConfigurationProvider',
        'notificationService',
        'language',
        '$modal'
    ];
    return SwitchoverFormConfigurationCtrl;
}(BaseConfigurationController));
angular
    .module('kamhpp')
    .controller('SwitchoverFormConfigurationCtrl', SwitchoverFormConfigurationCtrl);
