﻿ALTER DATABASE %DatabaseName% SET search_path TO "td"
;

CREATE SCHEMA IF NOT EXISTS "td"
;

CREATE EXTENSION IF NOT EXISTS pgcrypto WITH SCHEMA "td"
;

CREATE TABLE IF NOT EXISTS "td"."__EFMigrationsHistory" (
    "MigrationId" character varying(150) NOT NULL,
    "ProductVersion" character varying(32) NOT NULL,
    CONSTRAINT "PK___EFMigrationsHistory" PRIMARY KEY ("MigrationId")
);

CREATE TABLE "td"."CimAttributeDataTypes" (
    "Id" serial NOT NULL,
    "Name" text NOT NULL,
    CONSTRAINT "PK_CimAttributeDataTypes" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."CimAttributeInstances" (
    "Id" serial NOT NULL,
    "UniqueCode" text NOT NULL,
    "StartDate" timestamp without time zone NOT NULL,
    "EndDate" timestamp without time zone NULL,
    "AttributeUniqueCode" text NULL,
    "ClassIstanceUniqueCode" text NULL,
    "Value" text NULL,
    CONSTRAINT "PK_CimAttributeInstances" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."CimLinkCapacities" (
    "Id" serial NOT NULL,
    "Name" text NOT NULL,
    CONSTRAINT "PK_CimLinkCapacities" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."CimClasses" (
    "Id" serial NOT NULL,
    "UniqueCode" text NOT NULL,
    "StartDate" timestamp without time zone NOT NULL,
    "EndDate" timestamp without time zone NULL,
    "Name" text NOT NULL,
    "BaseClassUniqueCode" text NULL,
    CONSTRAINT "PK_CimClasses" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."CimClassInstances" (
    "Id" serial NOT NULL,
    "UniqueCode" text NOT NULL,
    "StartDate" timestamp without time zone NOT NULL,
    "EndDate" timestamp without time zone NULL,
    "Name" text NOT NULL,
    "ClassUniqueCode" text NOT NULL,
    CONSTRAINT "PK_CimClassInstances" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."CimDictionaryProfileSets" (
    "Id" uuid NOT NULL,
    "Name" text NULL,
    CONSTRAINT "PK_CimDictionaryProfileSets" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."CimLinkInstances" (
    "Id" serial NOT NULL,
    "UniqueCode" text NOT NULL,
    "StartDate" timestamp without time zone NOT NULL,
    "EndDate" timestamp without time zone NULL,
    "LinkUniqueCode" text NULL,
    "SourceClassInstanceUniqueCode" text NOT NULL,
    "TargetClassInstanceUniqueCode" text NOT NULL,
    CONSTRAINT "PK_CimLinkInstances" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."CimLinkTypes" (
    "Id" serial NOT NULL,
    "Name" text NOT NULL,
    CONSTRAINT "PK_CimLinkTypes" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."CimAttributes" (
    "Id" serial NOT NULL,
    "UniqueCode" text NOT NULL,
    "StartDate" timestamp without time zone NOT NULL,
    "EndDate" timestamp without time zone NULL,
    "Name" text NOT NULL,
    "ClassUniqueCode" text NOT NULL,
    "DataTypeId" integer NOT NULL,
    CONSTRAINT "PK_CimAttributes" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_CimAttributes_CimAttributeDataTypes_DataTypeId" FOREIGN KEY ("DataTypeId") REFERENCES "td"."CimAttributeDataTypes" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."CimDictionaryProfiles" (
    "Id" uuid NOT NULL,
    "SourceUniqueCode" text NULL,
    "TargetUniqueCode" text NULL,
    "LinkUniqueCode" text NULL,
    "Name" text NULL,
    "IsBackLink" boolean NOT NULL,
    "CreateGroupNode" boolean NOT NULL,
    "ShowRecursiveSelfLinks" boolean NOT NULL,
    "ParentId" uuid NULL,
    "CimDictionaryProfileId" uuid NOT NULL,
    "CimDictionaryProfileSetId" uuid NOT NULL,
    CONSTRAINT "PK_CimDictionaryProfiles" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_CimDictionaryProfiles_CimDictionaryProfiles_CimDictionaryPr~" FOREIGN KEY ("CimDictionaryProfileId") REFERENCES "td"."CimDictionaryProfiles" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_CimDictionaryProfiles_CimDictionaryProfileSets_CimDictionar~" FOREIGN KEY ("CimDictionaryProfileSetId") REFERENCES "td"."CimDictionaryProfileSets" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."CimLinks" (
    "Id" serial NOT NULL,
    "UniqueCode" text NOT NULL,
    "StartDate" timestamp without time zone NOT NULL,
    "EndDate" timestamp without time zone NULL,
    "Name" text NOT NULL,
    "SourceClassUniqueCode" text NOT NULL,
    "TargetClassUniqueCode" text NOT NULL,
    "TypeId" integer NOT NULL,
    "CapacityId" integer NOT NULL,
    CONSTRAINT "PK_CimLinks" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_CimLinks_CimLinkCapacities_CapacityId" FOREIGN KEY ("CapacityId") REFERENCES "td"."CimLinkCapacities" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_CimLinks_CimLinkTypes_TypeId" FOREIGN KEY ("TypeId") REFERENCES "td"."CimLinkTypes" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."ExternalConnectionSettings" (
    "Id" uuid NOT NULL,
    "Name" text NOT NULL,
    "Type" integer NOT NULL,
    "Status" integer NOT NULL,
    "AllowableAccessErrorCount" integer NOT NULL,
    "CurrentAccessErrorCount" integer NOT NULL,
    "Json" text NOT NULL,
    "LastCheckTime" timestamp without time zone NOT NULL,
    "ReconnectionInterval" text NOT NULL,
    CONSTRAINT "PK_ExternalConnectionSettings" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."Mails" (
    "Id" text NOT NULL,
    "CreationTimestamp" timestamp without time zone NOT NULL,
    "Message" bytea NOT NULL,
    "IsSent" boolean NOT NULL,
    CONSTRAINT "PK_Mails" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."OpcConnections" (
    "Id" serial NOT NULL,
    "Name" text NOT NULL,
    "Json" text NOT NULL,
    CONSTRAINT "PK_OpcConnections" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."ReportTemplates" (
    "Id" serial NOT NULL,
    "UniqueGuid" uuid NOT NULL,
    "Version" integer NOT NULL,
    "Name" text NOT NULL,
    "Chapter" text NOT NULL,
    "Parameters" text NOT NULL,
    "Html" text NOT NULL,
    "Rules" text NOT NULL,
    "ContentVersion" integer NOT NULL,
    "HasStep" boolean NOT NULL,
    "IsHide" boolean NOT NULL,
    "PeriodStep" text NULL,
    "Priority" integer NOT NULL,
    "ReportType" integer NOT NULL,
    CONSTRAINT "PK_ReportTemplates" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."Reports" (
    "Id" serial NOT NULL,
    "Name" text NOT NULL,
    "StartDate" timestamp without time zone NOT NULL,
    "EndDate" timestamp without time zone NOT NULL,
    "Values" bytea NULL,
    "RecalculationState" integer NOT NULL,
    "CalculationResult" integer NOT NULL,
    "IsCompleted" boolean NOT NULL,
    "HasIncompletedRules" boolean NOT NULL,
    "ReportTemplateUniqueGuid" uuid NOT NULL,
    "PredefinedValuesHashCode" integer NOT NULL,
    "ReportTemplateId" integer NOT NULL,
    "ContentVersion" integer NOT NULL,
    "Changes" text NULL,
    "CreatedDate" timestamp without time zone NOT NULL,
    "CreatedUserName" text NULL,
    "DependentReports" text NULL,
    "UpdatedDate" timestamp without time zone NOT NULL,
    "LockDate" timestamp without time zone NULL,
    "PredefinedValues" text NOT NULL,
    "Rules" text NULL,
    CONSTRAINT "PK_Reports" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_Reports_ReportTemplates_ReportTemplateId" FOREIGN KEY ("ReportTemplateId") REFERENCES "td"."ReportTemplates" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."ServerSettings" (
    "Name" text NOT NULL,
    "Value" text NULL,
    CONSTRAINT "PK_ServerSettings" PRIMARY KEY ("Name")
);

CREATE TABLE "td"."SysLogs" (
    "Id" uuid NOT NULL,
    "ActionTime" timestamp without time zone NOT NULL,
    "User" text NOT NULL,
    "Description" text NOT NULL,
    "TagValues" text NOT NULL,
    CONSTRAINT "PK_SysLogs" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."Roles" (
    "Id" uuid NOT NULL,
    "Name" text NOT NULL,
    "PermissionIdents" text NOT NULL,
    "IsDomainUserGroup" boolean NOT NULL,
    CONSTRAINT "PK_Roles" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."Users" (
    "Id" uuid NOT NULL,
    "Login" text NOT NULL,
    "Name" text NOT NULL,
    "Password" text NOT NULL,
    "IsActive" boolean NOT NULL,
	"IsDomain" boolean NOT NULL,
    "Position" text NULL,
    "Signature" bytea NULL,
    "SigningAuthority" text NULL,
    CONSTRAINT "PK_Users" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."UserRoles" (
    "UserId" uuid NOT NULL,
    "RoleId" uuid NOT NULL,
    CONSTRAINT "PK_UserRoles" PRIMARY KEY ("UserId", "RoleId"),
    CONSTRAINT "FK_UserRoles_Roles_RoleId" FOREIGN KEY ("RoleId") REFERENCES "td"."Roles" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_UserRoles_Users_UserId" FOREIGN KEY ("UserId") REFERENCES "td"."Users" ("Id") ON DELETE CASCADE
);

CREATE INDEX "IX_CimAttributes_DataTypeId" ON "td"."CimAttributes" ("DataTypeId");

CREATE INDEX "IX_CimDictionaryProfiles_CimDictionaryProfileId" ON "td"."CimDictionaryProfiles" ("CimDictionaryProfileId");

CREATE INDEX "IX_CimDictionaryProfiles_CimDictionaryProfileSetId" ON "td"."CimDictionaryProfiles" ("CimDictionaryProfileSetId");

CREATE INDEX "IX_CimLinks_CapacityId" ON "td"."CimLinks" ("CapacityId");

CREATE INDEX "IX_CimLinks_TypeId" ON "td"."CimLinks" ("TypeId");

CREATE INDEX "IX_Reports_ReportTemplateId" ON "td"."Reports" ("ReportTemplateId");

CREATE UNIQUE INDEX "IX_Reports_ReportTemplateId_StartDate_EndDate" ON "Reports" ("ReportTemplateId", "StartDate", "EndDate", "PredefinedValuesHashCode");

CREATE UNIQUE INDEX "IX_Reports_ReportTemplateUniqueGuid_StartDate_EndDate" ON "Reports" ("ReportTemplateUniqueGuid", "StartDate", "EndDate", "PredefinedValuesHashCode");

CREATE INDEX "IX_UserRoles_RoleId" ON "td"."UserRoles" ("RoleId");

CREATE INDEX "IX_UserRoles_UserId" ON "td"."UserRoles" ("UserId");
