var DeviceLimitExceedInterceptor = (function () {
    function DeviceLimitExceedInterceptor($q, $rootScope, $injector) {
        var _this = this;
        this.$q = $q;
        this.$rootScope = $rootScope;
        this.$injector = $injector;
        this.responseError = function (response) {
            if (response.status !== 403) {
                return _this.$q.reject(response);
            }
            var forbiddenReason = response.data[dto.reasonProblemResponseFieldName];
            if (!forbiddenReason || forbiddenReason !== dto.deviceLimitExceedReason) {
                return _this.$q.reject(response);
            }
            var modal = _this.$injector.get('$modal');
            if (!_this.$rootScope.modalDeviceLimitExceedOpened) {
                _this.$rootScope.modalDeviceLimitExceedOpened = true;
                modal
                    .open({
                    templateUrl: 'ng1/dist/src/Core/License/DeviceLimitExceedWindow/DeviceLimitExceedWindow.html',
                    controller: 'deviceLimitExceedWindowController',
                    backdrop: 'static',
                    windowClass: 'modal-medium',
                    keyboard: false
                })
                    .result.then(function () {
                    _this.$rootScope.modalDeviceLimitExceedOpened = false;
                }, function () { });
            }
            return _this.$q.reject(response);
        };
    }
    DeviceLimitExceedInterceptor.Factory = function ($q, $rootScope, $injector) {
        return new DeviceLimitExceedInterceptor($q, $rootScope, $injector);
    };
    DeviceLimitExceedInterceptor.$inject = ['$q', '$rootScope', '$injector'];
    return DeviceLimitExceedInterceptor;
}());
