var NotificationBodyOutputType;
(function (NotificationBodyOutputType) {
    NotificationBodyOutputType["None"] = "";
    NotificationBodyOutputType["TrustedHtml"] = "trustedHtml";
})(NotificationBodyOutputType || (NotificationBodyOutputType = {}));
var NotificationMessage = (function () {
    function NotificationMessage(message, details) {
        this.message = '';
        this.details = [];
        if (_.isDefined(message))
            this.message = message;
        if (_.isDefined(details))
            this.details = details;
    }
    return NotificationMessage;
}());
angular.module('kamhpp').service('notificationService', function (toaster, language) {
    var detailsToString = function (details) {
        if (angular.isUndefined(details))
            return undefined;
        if (angular.isArray(details)) {
            if (details.length === 0) {
                return undefined;
            }
            var detailsAsString_1 = '';
            _.each(details, function (detail) {
                detailsAsString_1 += detail + '<br/>';
            });
            return detailsAsString_1;
        }
        if (angular.isString(details))
            return details;
        if (_.isDefined(details.data) && _.isDefined(details.data.detail)) {
            return details.data.detail;
        }
        if (_.isDefined(details.data) && angular.isString(details.data)) {
            return details.data;
        }
        var messageContainer = details;
        if (messageContainer.message) {
            return messageContainer.message;
        }
        if (_.isUndefined(messageContainer.Message)) {
            return '';
        }
        var message = 'Message: ' + messageContainer.Message;
        if (!angular.isUndefined(messageContainer.MessageDetail))
            message += '<br/>MessageDetail: ' + messageContainer.MessageDetail;
        if (!angular.isUndefined(messageContainer.ExceptionMessage))
            message += '<br/>ExceptionMessage: ' + messageContainer.ExceptionMessage;
        if (!angular.isUndefined(messageContainer.ExceptionType))
            message += '<br/>ExceptionType: ' + messageContainer.ExceptionType;
        if (!angular.isUndefined(messageContainer.StackTrace))
            message += '<br/><br/>StackTrace: ' + messageContainer.StackTrace;
        return message;
    };
    var replaceLineBreakCharacters = function (message, bodyOutputType) {
        if (bodyOutputType === NotificationBodyOutputType.TrustedHtml) {
            return message.replace(/(?:\r\n|\r|\n)/g, '<br>');
        }
        return message;
    };
    this.showMessage = function (message, details, bodyOutputType, timeOut, preventDuplicates) {
        if (bodyOutputType === void 0) { bodyOutputType = NotificationBodyOutputType.None; }
        if (timeOut === void 0) { timeOut = 3000; }
        if (preventDuplicates === void 0) { preventDuplicates = false; }
        toaster.pop('success', '', replaceLineBreakCharacters(message, bodyOutputType), timeOut, detailsToString(details), bodyOutputType, preventDuplicates);
    };
    this.infoMessage = function (message, details, bodyOutputType, timeOut, preventDuplicates) {
        if (bodyOutputType === void 0) { bodyOutputType = NotificationBodyOutputType.None; }
        if (timeOut === void 0) { timeOut = 3000; }
        if (preventDuplicates === void 0) { preventDuplicates = false; }
        toaster.pop('info', '', replaceLineBreakCharacters(message, bodyOutputType), timeOut, detailsToString(details), bodyOutputType, preventDuplicates);
    };
    this.warnMessage = function (message, details, bodyOutputType, timeOut, preventDuplicates) {
        if (bodyOutputType === void 0) { bodyOutputType = NotificationBodyOutputType.None; }
        if (timeOut === void 0) { timeOut = 10000; }
        if (preventDuplicates === void 0) { preventDuplicates = false; }
        toaster.pop('warning', '', replaceLineBreakCharacters(message, bodyOutputType), timeOut, detailsToString(details), bodyOutputType, preventDuplicates);
    };
    this.errorMessage = function (message, details, bodyOutputType, timeOut, preventDuplicates) {
        if (bodyOutputType === void 0) { bodyOutputType = NotificationBodyOutputType.None; }
        if (timeOut === void 0) { timeOut = 0; }
        if (preventDuplicates === void 0) { preventDuplicates = false; }
        if (_.isDefined(details) && (details.status !== 500)) {
            return;
        }
        toaster.pop('error', language.getElementValue('errorHdr'), replaceLineBreakCharacters(message, bodyOutputType), timeOut, detailsToString(details), bodyOutputType, preventDuplicates);
    };
    this.clear = function () {
        toaster.clear();
    };
});
