app.directive('smsSelectableRows', [
    function () {
        return {
            restrict: 'A',
            link: function (scope, element) {
                var attributeName = 'sms-table-row-checked';
                var trs = $(element.children('tbody')[0]).children('tr');
                _.each(trs, function (tr) {
                    tr.onclick = function () {
                        var checkedValue = tr.getAttribute(attributeName);
                        if (_.isUndefined(checkedValue)) {
                            tr.setAttribute(attributeName, '');
                        }
                        else {
                            tr.removeAttribute(attributeName);
                        }
                    };
                });
            },
        };
    },
]);
