var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var SelectReportItem = (function (_super) {
    __extends(SelectReportItem, _super);
    function SelectReportItem(ident, name, type) {
        var _this = _super.call(this, ident, name) || this;
        _this.type = type;
        return _this;
    }
    return SelectReportItem;
}(UiSelectItem));
var SelectReportFunctionsItem = (function (_super) {
    __extends(SelectReportFunctionsItem, _super);
    function SelectReportFunctionsItem(ident, name, sourceFunction, returnType) {
        var _this = _super.call(this, ident, name, returnType) || this;
        _this.sourceFunction = sourceFunction;
        return _this;
    }
    return SelectReportFunctionsItem;
}(SelectSourceFunctionsItem));
var SelectReportTemplate = (function (_super) {
    __extends(SelectReportTemplate, _super);
    function SelectReportTemplate(ident, name) {
        return _super.call(this, ident, name) || this;
    }
    return SelectReportTemplate;
}(UiSelectItem));
var ReportLinkSettingsCtrl = (function () {
    function ReportLinkSettingsCtrl(parentScope, language, reportTemplateProvider, httpService, clientSettings, qService, notificationService) {
        var _this = this;
        this.parentScope = parentScope;
        this.language = language;
        this.reportTemplateProvider = reportTemplateProvider;
        this.httpService = httpService;
        this.clientSettings = clientSettings;
        this.qService = qService;
        this.notificationService = notificationService;
        this.watchFunctions = [];
        this.reportTemplates = [];
        this.getLastVersionReportTemplate = function (uniqueGuid) {
            var deferred = _this.qService.defer();
            _this.httpService
                .get(_this.clientSettings.getServerInstance() + '/ReportTemplate/GetLastVersionReportTemplate', {
                params: { uniqueGuid: uniqueGuid },
            })
                .then(function (response) {
                deferred.resolve(response.data);
            }, function (response) {
                deferred.reject(response);
            });
            return deferred.promise;
        };
        this.initLinkParameter = function (parameter) {
            var self = _this;
            parameter.parameters.selected = _.find(parameter.parameters, function (p) {
                return p.ident === parameter.ident;
            });
            _this.watchFunctions.push(self.parentScope.$watch(function () {
                return parameter.parameters.selected;
            }, function (before, after) {
                if (before === after) {
                    return;
                }
                parameter.ident = parameter.parameters.selected.ident;
            }));
            return parameter;
        };
        this.add = function () {
            var self = _this;
            var newParameter = {
                ident: null,
                parameters: _.deepclone(self.reportParameters),
                getAvalibleReportParametersFilter: function (enteredString) {
                    return function (item) {
                        return self.avalibleReportParametersFilter(item, newParameter.parameters.selected, enteredString);
                    };
                },
            };
            _this.watchFunctions.push(self.parentScope.$watch(function () {
                return newParameter.parameters.selected;
            }, function (after, before) {
                if (before === after) {
                    return;
                }
                newParameter.ident = newParameter.parameters.selected.ident;
            }));
            self.reportLinkParameters.push(newParameter);
        };
        this.avalibleReportParametersFilter = function (item, currentSelected, enteredString) {
            var selfScope = _this;
            if ((_.isUndefined(selfScope.parentScope) || item.ident === selfScope.parentScope.param.Ident) &&
                selfScope.setting.templateUniqueGuid === selfScope.parentScope.reportTemplate.UniqueGuid) {
                return false;
            }
            if (!_.isUndefined(currentSelected) && item.ident === currentSelected.ident) {
                return true;
            }
            for (var j = 0; j < selfScope.reportLinkParameters.length; j++) {
                if (_.isUndefined(selfScope.reportLinkParameters[j].parameters.selected)) {
                    continue;
                }
                if (selfScope.reportLinkParameters[j].parameters.selected.ident === item.ident) {
                    return false;
                }
            }
            enteredString = enteredString.toUpperCase().replaceAll(' ', '').replaceAll('.', '').replaceAll('-', '');
            if (item.name.toUpperCase().replaceAllPolyfill(' ', '').replaceAllPolyfill('.', '').replaceAllPolyfill('-', '').contains(enteredString)) {
                return true;
            }
            else {
                return false;
            }
        };
    }
    ReportLinkSettingsCtrl.prototype.updateUIComponentsVisibility = function (func) {
        switch (func) {
            case 1:
                this.reportTemplatesSelectorVisible = false;
                this.reportDateSelectoVisible = false;
                this.parameterSelectorVisible = true;
                this.parameterListVisible = false;
                this.timestampSelectorVisible = false;
                break;
            case 0:
                this.reportTemplatesSelectorVisible = true;
                this.reportDateSelectoVisible = true;
                this.parameterSelectorVisible = false;
                this.parameterListVisible = true;
                this.timestampSelectorVisible = true;
                break;
            case 3:
                this.reportTemplatesSelectorVisible = true;
                this.reportDateSelectoVisible = true;
                this.parameterSelectorVisible = false;
                this.parameterListVisible = true;
                this.timestampSelectorVisible = false;
                break;
            case 4:
                this.reportTemplatesSelectorVisible = true;
                this.reportDateSelectoVisible = true;
                this.parameterSelectorVisible = true;
                this.parameterListVisible = false;
                this.timestampSelectorVisible = true;
                break;
            default:
                this.reportTemplatesSelectorVisible = false;
                this.reportDateSelectoVisible = false;
                this.parameterSelectorVisible = false;
                this.parameterListVisible = false;
                this.timestampSelectorVisible = false;
                break;
        }
    };
    ReportLinkSettingsCtrl.prototype.isDisabledAddingToList = function () {
        return _.isUndefined(this.reports) || _.isUndefined(this.reports.selected);
    };
    ReportLinkSettingsCtrl.prototype.initReportParameters = function (parameters) {
        var _this = this;
        if (!_.isUndefined(this.reportParametersSelect)) {
            this.reportParametersSelect.destroy();
        }
        this.reportParametersSelect = getVariantsContainer(this.parentScope, _.map(parameters, function (item) {
            return new UiSelectItem(item.Ident, item.Ident);
        }), function (t) {
            return t.ident === _this.setting.parameterIdent[0];
        }, function (after, before) {
            if (after === before || after === undefined)
                return;
            _this.setting.parameterIdent = [];
            _this.setting.parameterIdent.push(after.ident);
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        });
    };
    ReportLinkSettingsCtrl.prototype.initReportParametersOfReportTemplate = function (uniqueGuid) {
        var _this = this;
        this.getLastVersionReportTemplate(uniqueGuid)
            .then(function (tempalte) {
            if (_this.setting.func === 4) {
                _this.initReportParameters(tempalte.Parameters);
                return;
            }
            _this.reportParameters = _.map(tempalte.Parameters, function (parameter) {
                return new UiSelectItem(parameter.Ident, parameter.Ident);
            });
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
    };
    ReportLinkSettingsCtrl.prototype.initReportsContainer = function () {
        var _this = this;
        if (!_.isUndefined(this.reports)) {
            this.reports.destroy();
        }
        this.reportTemplateProvider.getAllReportTemplatesShortInfo().then(function (reportTemplates) {
            _this.reportTemplates = reportTemplates;
            _this.reports = getVariantsContainer(_this.parentScope, _.map(_this.reportTemplates, function (template) {
                return new SelectReportItem(template.uniqueGuid, template.name, template.reportType);
            }), function (t) {
                return t.ident === _this.setting.templateUniqueGuid;
            }, function (after, before) {
                if (after === before || after === undefined) {
                    return;
                }
                ;
                if (after.type === 0) {
                    _this.reportEndDate.selected = _this.reportStartDate.selected;
                    _this.timestamp.selected = _this.reportStartDate.selected;
                }
                _this.reportLinkParameters = [];
                _this.setting.parameterIdent = [];
                _this.setting.templateUniqueGuid = after.ident;
                _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
                _this.initReportParametersOfReportTemplate(after.ident);
            });
            _this.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }, function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
    };
    ReportLinkSettingsCtrl.prototype.changeFunc = function (after, before) {
        if (after === before || after === undefined) {
            return;
        }
        switch (after) {
            case 1:
                if (!_.isUndefined(this.reportParametersSelect)) {
                    this.reportParametersSelect.destroy();
                    this.reportParametersSelect = undefined;
                }
                this.setting.templateUniqueGuid = this.parentScope.reportTemplate.UniqueGuid;
                this.setting.parameterIdent = [];
                this.initReportParameters(this.filterParameter);
                break;
            case 4:
                if (!_.isUndefined(this.reportParametersSelect)) {
                    this.reportParametersSelect.destroy();
                    this.reportParametersSelect = undefined;
                }
                if (!_.isUndefined(this.reports)) {
                    this.reports.destroy();
                    this.reports = undefined;
                }
                this.setting.templateUniqueGuid = null;
                this.setting.parameterIdent = [];
                this.initReportsContainer();
                break;
            case 3:
            case 0:
                if (!_.isUndefined(this.reports)) {
                    this.reports.destroy();
                    this.reports = undefined;
                }
                this.setting.templateUniqueGuid = null;
                this.reportLinkParameters = [];
                this.setting.parameterIdent = [];
                this.initReportsContainer();
                break;
        }
    };
    ReportLinkSettingsCtrl.prototype.loadData = function () {
        var _this = this;
        if (_.isEmpty(this.setting.templateUniqueGuid) || _.isNull(this.setting.templateUniqueGuid)) {
            this.reportLinkParameters = [];
            return;
        }
        this.getLastVersionReportTemplate(this.setting.templateUniqueGuid)
            .then(function (template) {
            _this.reportParameters = _.map(template.Parameters, function (i) {
                return new UiSelectItem(i.Ident, i.Ident);
            });
            try {
                var linkParameters = _.map(_this.setting.parameterIdent, function (paramName) {
                    var result = {
                        ident: paramName,
                        parameters: _.deepclone(_this.reportParameters),
                        getAvalibleReportParametersFilter: function (enteredString) {
                            return function (item) {
                                return _this.avalibleReportParametersFilter(item, result.parameters.selected, enteredString);
                            };
                        },
                    };
                    return result;
                });
                _this.reportLinkParameters = _.map(linkParameters, function (p) {
                    return _this.initLinkParameter(p);
                });
            }
            catch (e) {
                _this.reportLinkParameters = [];
            }
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveDataMsg'), data);
            _this.reportParameters = [];
            _this.reportLinkParameters = [];
            _this.parentScope.blockUI.reset(true);
        });
    };
    ReportLinkSettingsCtrl.prototype.init = function () {
        var _this = this;
        var self = this;
        self.setting = self.parentScope.param.Report;
        self.updateUIComponentsVisibility(self.setting.func);
        self.functions = getVariantsContainer(self.parentScope, [
            new SelectReportFunctionsItem(1, this.language.getElementValue('reportPreviousParameterValue'), 'GetPreviousParameterValue', 'StoredReportValue'),
            new SelectReportFunctionsItem(4, this.language.getElementValue('reportValueByParameterOnTimestamp'), 'GetValueByParameterOnTimestamp', 'StoredReportValue'),
            new SelectReportFunctionsItem(0, this.language.getElementValue('reportValuesOnTimestamp'), 'GetValuesOnTimestamp', 'StoredReportValue[]'),
            new SelectReportFunctionsItem(3, this.language.getElementValue('reportValuesBySeveralParameters'), 'GetValues', 'StoredReportValue[]'),
        ], function (t) {
            return t.ident === self.setting.func;
        }, function (after, before) {
            if (after === before || after == undefined)
                return;
            self.setting.func = after.ident;
            self.changeFunc(after.ident, before.ident);
            self.updateUIComponentsVisibility(after.ident);
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        self.filterParameter = _.filter(this.parentScope.reportTemplate.Parameters, function (i) {
            return i.Ident !== _this.parentScope.param.Ident;
        });
        self.initReportParameters(self.filterParameter);
        if (_.isDefined(self.setting.templateUniqueGuid)) {
            self.initReportParametersOfReportTemplate(self.setting.templateUniqueGuid);
        }
        self.timestamp = getVariantsExtendableContainer(self.parentScope, self.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.setting.timestamp;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            self.setting.timestamp = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        self.reportStartDate = getVariantsExtendableContainer(self.parentScope, self.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.setting.reportStartDateType;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            self.setting.reportStartDateType = after.ident;
            if (self.reports.selected.type === 0) {
                self.reportEndDate.selected = after;
                self.timestamp.selected = after;
            }
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        self.reportEndDate = getVariantsExtendableContainer(self.parentScope, self.parentScope.settingsCtrl.getTimestamps(), function () {
            return self.setting.reportEndDate;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            self.setting.reportEndDate = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        });
        if (self.setting.func !== 1) {
            self.initReportsContainer();
        }
        if (self.setting.func === 3 ||
            self.setting.func === 0) {
            self.loadData();
        }
        self.watchFunctions.push(self.parentScope.$watch(function () {
            return self.reportLinkParameters;
        }, function (after, before) {
            if (after === before || after === undefined) {
                return;
            }
            self.setting.parameterIdent = _.map(self.reportLinkParameters, function (item) { return item.ident; });
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        }, true));
        self.parentScope.settingsCtrl.formulaCtrl.setResultType(self.functions.selected.returnType);
        self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    ReportLinkSettingsCtrl.prototype.destroy = function () {
        _.forEach(this.watchFunctions, function (func) {
            if (!_.isUndefined(func))
                func();
        });
        this.functions.destroy();
        if (_.isDefined(this.reportParametersSelect)) {
            this.reportParametersSelect.destroy();
        }
        if (_.isDefined(this.reports)) {
            this.reports.destroy();
        }
        this.timestamp.destroy();
        this.reportStartDate.destroy();
        this.reportEndDate.destroy();
    };
    ReportLinkSettingsCtrl.prototype.getFormula = function () {
        var formula = '';
        if (_.isDefined(this.setting.func)) {
            var uniqueGuid = this.setting.templateUniqueGuid;
            var reportName = this.setting.func === 1
                ? this.parentScope.reportTemplate.Name
                : this.reportTemplates.length !== 0 && uniqueGuid
                    ? _.findWhere(this.reportTemplates, { uniqueGuid: uniqueGuid }).name
                    : '';
            var parametersName = this.setting.parameterIdent.join('", "');
            var reportStartDate = _.isUndefined(this.setting.reportStartDateType) ? '' : this.setting.reportStartDateType;
            var reportEndDate = _.isUndefined(this.setting.reportEndDate) ? '' : this.setting.reportEndDate;
            var timestamp = _.isUndefined(this.setting.timestamp) ? '' : this.setting.timestamp;
            switch (this.setting.func) {
                case 1:
                    formula = "ReportGetPreviousParameterValue(@\"".concat(reportName, "\", \"").concat(parametersName, "\");");
                    break;
                case 0:
                    formula = "ReportGetParametersValuesOnTimestamp(@\"".concat(reportName, "\", ").concat(reportStartDate, ", ").concat(reportEndDate, ", ").concat(timestamp, ", new string[]{\"").concat(parametersName, "\"});");
                    break;
                case 3:
                    formula = "ReportGetParametersValues(@\"".concat(reportName, "\", ").concat(reportStartDate, ", ").concat(reportEndDate, ", new string[]{\"").concat(parametersName, "\"});");
                    break;
                case 4:
                    formula = "ReportGetValueByParameterOnTimestamp(@\"".concat(reportName, "\", ").concat(reportStartDate, ", ").concat(reportEndDate, ", ").concat(timestamp, ", \"").concat(parametersName, "\");");
                    break;
            }
        }
        return formula;
    };
    ReportLinkSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    ReportLinkSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Report.canEdited();
    };
    ReportLinkSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Report.canPlanned();
    };
    ReportLinkSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Report.canBacklight();
    };
    ReportLinkSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Report.canPredefined();
    };
    return ReportLinkSettingsCtrl;
}());
