var ReportLinkSettings = (function () {
    function ReportLinkSettings(uniqueGuid, templateHasStep) {
        if (templateHasStep === void 0) { templateHasStep = null; }
        this.func = 1;
        this.timestamp = 'StartDate';
        this.reportStartDateType = templateHasStep
            ? 'StepStart'
            : 'StartDate';
        this.reportEndDate = templateHasStep
            ? 'StepEnd'
            : 'EndDate';
        this.parameterIdent = [];
        this.templateUniqueGuid = uniqueGuid;
    }
    ReportLinkSettings.clone = function (obj) {
        if (_.isUndefined(obj)) {
            return obj;
        }
        var clone = new ReportLinkSettings(obj.templateUniqueGuid);
        clone.templateUniqueGuid = obj.templateUniqueGuid;
        clone.timestamp = obj.timestamp;
        clone.reportStartDateType = obj.reportStartDateType;
        clone.reportEndDate = obj.reportEndDate;
        clone.func = obj.func;
        clone.parameterIdent = [];
        _.forEach(obj.parameterIdent, function (item) {
            clone.parameterIdent.push(item);
        });
        return clone;
    };
    ReportLinkSettings.isEqual = function (obj, other) {
        if (_.isUndefined(obj) || _.isUndefined(other)) {
            return obj === other;
        }
        var parametersIsEqual = true;
        for (var i = 0; i < obj.parameterIdent.length; i++) {
            if (obj.parameterIdent[i] !== other.parameterIdent[i]) {
                parametersIsEqual = false;
                break;
            }
        }
        return (parametersIsEqual &&
            obj.templateUniqueGuid === other.templateUniqueGuid &&
            obj.timestamp === other.timestamp &&
            obj.reportStartDateType === other.reportStartDateType &&
            obj.reportEndDate === other.reportEndDate &&
            obj.func === other.func);
    };
    ReportLinkSettings.prototype.canEdited = function () {
        return true;
    };
    ReportLinkSettings.prototype.canPlanned = function () {
        return this.func === 4
            || this.func === 0;
    };
    ReportLinkSettings.prototype.canBacklight = function () {
        return _.contains([1, 4], this.func);
    };
    ReportLinkSettings.prototype.canPredefined = function () {
        return false;
    };
    return ReportLinkSettings;
}());
