var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var OracleSettingsCtrl = (function (_super) {
    __extends(OracleSettingsCtrl, _super);
    function OracleSettingsCtrl(codeEditor, modalService, parentScope, language) {
        var _this = _super.call(this, codeEditor, modalService, parentScope) || this;
        _this.parentScope = parentScope;
        _this.language = language;
        _this.functions = [];
        _this.connectionTypes = [1];
        _this.watchFunctions = [];
        return _this;
    }
    OracleSettingsCtrl.prototype.init = function () {
        var _this = this;
        var self = this;
        this.functions = getVariantsContainer(this.parentScope, [
            new SelectSourceFunctionsItem('table', this.language.getElementValue('tableHdr'), 'ReportTable'),
            new SelectSourceFunctionsItem('objectArray', this.language.getElementValue('reportParameterTypeTableObjectHdr'), 'object[][]'),
            new SelectSourceFunctionsItem('doubleArray', this.language.getElementValue('sqlTableNumberHdr'), 'double[][]'),
            new SelectSourceFunctionsItem('cellString', this.language.getElementValue('reportCellStringHdr'), 'string'),
            new SelectSourceFunctionsItem('cellDouble', this.language.getElementValue('reportCellNumberHdr'), 'double'),
            new SelectSourceFunctionsItem('stringOneDimArray', this.language.getElementValue('sqlStringSetHdr'), 'string[]'),
        ], function (t) {
            return t.ident === self.parentScope.param.Oracle.func;
        }, function (after, before) {
            if (after === before)
                return;
            if (after == undefined || after === before)
                return;
            self.parentScope.param.Oracle.func = after.ident;
            self.parentScope.settingsCtrl.formulaCtrl.setResultType(after.returnType);
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(self.getFormula());
            if (!self.canEdited()) {
                self.parentScope.param.Editable = false;
            }
        });
        this.watchFunctions.push(this.parentScope.$watch(function () {
            return self.parentScope.param.Oracle;
        }, function (before, after) {
            if (_.isUndefined(self.parentScope.param.Oracle) ||
                _.isNull(self.parentScope.param.Oracle) ||
                after == undefined)
                return;
            self.parentScope.settingsCtrl.formulaCtrl.setFormula(_this.getFormula());
        }, true));
        this.parentScope.settingsCtrl.formulaCtrl.setResultType(this.functions.selected.returnType);
        this.parentScope.settingsCtrl.formulaCtrl.setFormula(this.getFormula());
        if (!this.canEdited()) {
            this.parentScope.param.Editable = false;
        }
    };
    OracleSettingsCtrl.prototype.onCodeEditorChange = function (change) {
        this.parentScope.param.Oracle.sql = change.code;
    };
    OracleSettingsCtrl.prototype.destroy = function () {
        this.functions.destroy();
        for (var i = 0; i < this.watchFunctions.length; i++) {
            var func = this.watchFunctions[i];
            if (!_.isUndefined(func)) {
                func();
            }
        }
    };
    OracleSettingsCtrl.prototype.getFormula = function () {
        var connectionGuid = this.parentScope.param.Oracle.connectionGuid;
        var sql = ReportFormulaEscaper.escape(this.parentScope.param.Oracle.sql, this.parentScope.reportTemplate.Parameters);
        switch (this.functions.selected.ident) {
            case 'table':
                return ('return OracleQueryAsHtmlTableByConnection("' +
                    connectionGuid +
                    '", ' +
                    sql +
                    ', ' +
                    this.parentScope.param.Oracle.includeHeader +
                    ');');
            case 'doubleArray':
                return 'return OracleQueryAsDoubleArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'objectArray':
                return 'return OracleQueryAsObjectArrayByConnection("' + connectionGuid + '", ' + sql + ');';
            case 'cellString':
                return 'return OracleQueryAsStringByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
            case 'cellDouble':
                return 'return OracleQueryAsDoubleByConnection("' + connectionGuid + '", ' + sql + ', 0, 0);';
            case 'stringOneDimArray':
                return 'return OracleQueryAsStringArrayByConnection("' + connectionGuid + '", ' + sql + ')[0];';
        }
        return '';
    };
    OracleSettingsCtrl.prototype.isIncorrectParameterSettings = function () {
        return false;
    };
    OracleSettingsCtrl.prototype.canEdited = function () {
        return this.parentScope.param.Oracle.canEdited();
    };
    OracleSettingsCtrl.prototype.canPlanned = function () {
        return this.parentScope.param.Oracle.canPlanned();
    };
    OracleSettingsCtrl.prototype.canBacklight = function () {
        return this.parentScope.param.Oracle.canBacklight();
    };
    OracleSettingsCtrl.prototype.canPredefined = function () {
        return this.parentScope.param.Oracle.canPredefined();
    };
    return OracleSettingsCtrl;
}(DatabaseSettingsBaseCtrl));
