var SwitchoverFormController = (function () {
    function SwitchoverFormController(rootScope, scope, location, modal, compile, routeParams, switchoverFormProviderService, switchoverFormTemplateProviderService, switchoverFormAlarmsProvider, switchoverFormPlayerProvider, switchoverFormConfigurationProvider, timeout, notificationService, language, authentication, userProvider, timezoneProviderService, mailProvider, formatTimezoneFilter, removeHtmlFilter, exportService, printService) {
        var _this = this;
        this.rootScope = rootScope;
        this.scope = scope;
        this.location = location;
        this.modal = modal;
        this.compile = compile;
        this.routeParams = routeParams;
        this.switchoverFormProviderService = switchoverFormProviderService;
        this.switchoverFormTemplateProviderService = switchoverFormTemplateProviderService;
        this.switchoverFormAlarmsProvider = switchoverFormAlarmsProvider;
        this.switchoverFormPlayerProvider = switchoverFormPlayerProvider;
        this.switchoverFormConfigurationProvider = switchoverFormConfigurationProvider;
        this.timeout = timeout;
        this.notificationService = notificationService;
        this.language = language;
        this.authentication = authentication;
        this.userProvider = userProvider;
        this.timezoneProviderService = timezoneProviderService;
        this.mailProvider = mailProvider;
        this.formatTimezoneFilter = formatTimezoneFilter;
        this.removeHtmlFilter = removeHtmlFilter;
        this.exportService = exportService;
        this.printService = printService;
        this.dateFormat = Date.masks.fullDateTime;
        this.localTimezone = {
            name: this.language.getElementValue('localTimezoneNameHdr'),
            timezoneOffsetMinutes: Date.getLocalTimezoneUtcOffsetMinutes(),
        };
        this.currentTimezone = this.localTimezone;
        this.timezones = [this.localTimezone];
        this.switchoverFormProviderService
            .getSwitchoverForm(parseInt(this.routeParams.formId))
            .then(function (form) {
            form.conditions = _.sortBy(form.conditions, function (c) { return c.orderNumber; });
            form.operations = _.sortBy(form.operations, function (o) { return o.orderNumber; });
            _this.switchoverForm = new SwitchoverForm(form);
            _this.compileSwitchoverForm(_this.switchoverForm);
            _this.appointments = _this.getAppointments(_this.switchoverForm.headerHtml + _this.switchoverForm.footerHtml);
            _this.switchoverFormPlayerProvider.createInstance(_this.switchoverForm).then(function (player) {
                _this.player = player;
                _this.player.afterStepChange = function () {
                    _this.scrollToCurrentStep();
                };
            });
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
        this.switchoverFormConfigurationProvider.getSwitchoverFormConfiguration().then(function (settings) {
            _this.isRemoteControlKeyVerificationEnabled =
                settings.remoteControlKeyConfiguration.isRemoteControlKeyVerificationEnabled;
            _this.isWriteCommandAutomaticExecutionAllowed = settings.isWriteCommandAutomaticExecutionAllowed;
        });
        this.timezoneProviderService.getAllTimezones().then(function (timezones) {
            _this.timezones = _this.timezones.concat(timezones);
        }, function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('serverSettingsTimezonesNotFoundMsg'), error);
        });
        this.mailProvider
            .isMailEnabled()
            .then(function (isEnable) {
            _this.isEnable = isEnable;
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
        });
    }
    SwitchoverFormController.prototype.canEditSwitchoverForm = function () {
        return this.isOpened() && this.authentication.hasPermission(this.rootScope.permissions.SwitchoverFormEdit);
    };
    SwitchoverFormController.prototype.canAddSigners = function () {
        return (this.canEditSwitchoverForm() &&
            this.authentication.hasPermission(this.rootScope.permissions.SwitchoverFormTemplateAdmin) &&
            this.appointments.length > 0);
    };
    SwitchoverFormController.prototype.canCreateTemplate = function () {
        return (this.switchoverForm &&
            this.switchoverForm.templateId &&
            this.switchoverForm.status === 0 &&
            this.authentication.hasPermission(this.rootScope.permissions.SwitchoverFormTemplateAdmin));
    };
    SwitchoverFormController.prototype.isOpened = function () {
        return this.switchoverForm && this.switchoverForm.status === 0;
    };
    SwitchoverFormController.prototype.isStopped = function () {
        return this.switchoverForm && this.switchoverForm.status === 1;
    };
    SwitchoverFormController.prototype.send = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/Common/Components/MailModal/MailSendModal.html',
            controller: 'mailSendModalCtrl',
            windowClass: 'app-modal-window',
            backdrop: 'static',
            resolve: {
                subject: function () { return _this.switchoverForm.name; },
                hideFileTypes: function () { return [
                    0,
                    2,
                    3,
                    4,
                    5,
                ]; },
            },
        })
            .result.then(function (mailSendingInfo) {
            _this.switchoverFormProviderService
                .send(_this.switchoverForm.id, mailSendingInfo)
                .then(function () {
                return _this.notificationService.showMessage(_this.language.getElementValue('mailWasSentSuccessfullyMsg'));
            })
                .catch(function (error) {
                return _this.notificationService.errorMessage(_this.language.getElementValue('mailWasntSentMsg'), error);
            });
        }, function () { });
    };
    SwitchoverFormController.prototype.showDescription = function () {
        var _this = this;
        this.modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/View/DescriptionModal/SwitchoverFormDescriptionModal.html',
            controller: 'switchoverFormDescriptionModalCtrl',
            windowClass: 'app-modal-window',
            backdrop: 'static',
            resolve: {
                description: function () { return _this.switchoverForm.description; },
                isReadOnly: function () { return true; },
            },
        });
    };
    SwitchoverFormController.prototype.deleteForm = function () {
        var _this = this;
        this.modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/View/DeleteFormModal/DeleteSwitchoverFormModal.html',
            controller: 'deleteSwitchoverFormModalCtrl',
            backdrop: 'static',
            resolve: {
                name: function () { return _this.switchoverForm.name; },
            },
        })
            .result.then(function () {
            _this.switchoverFormProviderService
                .delete(_this.switchoverForm.id, _this.switchoverForm.name, _this.switchoverForm.serialNumber)
                .then(function () {
                _this.location.path('/switchover-forms');
                _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsDeletedSuccessfullyMsg'));
            })
                .catch(function (error) {
                return _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsDeletedErrorMsg'), error);
            });
        }, function () { });
    };
    SwitchoverFormController.prototype.stop = function () {
        var _this = this;
        this.userProvider
            .getRegularUsers()
            .then(function (users) {
            _this.modal
                .open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/View/StopModal/StopSwitchoverFormModal.html',
                controller: 'stopSwitchoverFormCtrl',
                backdrop: 'static',
                resolve: {
                    users: function () { return _.sortBy(users, function (user) { return user.name; }); },
                    creationDate: function () { return _this.switchoverForm.creationDate; },
                    reason: function () { return _this.getStopReasonMessage(_this.switchoverForm); },
                },
            })
                .result.then(function (stopInfo) {
                stopInfo.stopDate = Date.convertToUtc(stopInfo.stopDate, _this.currentTimezone.timezoneOffsetMinutes);
                _this.switchoverFormProviderService
                    .stop(_this.switchoverForm.id, _this.switchoverForm.name, _this.switchoverForm.serialNumber, stopInfo)
                    .then(function () {
                    _this.switchoverForm.status = 1;
                    _this.switchoverForm.stopDate = stopInfo.stopDate;
                    _this.switchoverForm.stopReason = stopInfo.reason;
                    _this.switchoverForm.stopUserFullName = stopInfo.userName;
                    _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsStopedSuccessfullyMsg'));
                })
                    .catch(function (error) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsStopedErrorMsg'), error);
                });
            }, function () { });
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
    };
    SwitchoverFormController.prototype.close = function () {
        var _this = this;
        var closeDate = Date.convertToUtc(new Date(), this.currentTimezone.timezoneOffsetMinutes);
        this.switchoverFormProviderService
            .close(this.switchoverForm.id, this.switchoverForm.name, this.switchoverForm.serialNumber, closeDate)
            .then(function () {
            _this.switchoverForm.status = 2;
            _this.switchoverForm.closeDate = closeDate;
            _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsClosedMsg'));
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsClosedErrorMsg'), error);
        });
    };
    SwitchoverFormController.prototype.openLog = function () {
        var _this = this;
        this.modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/View/OpenLogModal/OpenSwitchoverFormLogModal.html',
            controller: 'openSwitchoverFormLogModalCtrl',
            windowClass: 'switchover-form-log-modal',
            backdrop: 'static',
            resolve: {
                switchoverForm: function () { return _this.switchoverForm; },
            },
        });
    };
    SwitchoverFormController.prototype.showAlarms = function () {
        var _this = this;
        this.switchoverFormAlarmsProvider
            .getFormAlarms(this.switchoverForm.id)
            .then(function (alarms) {
            _this.modal.open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/View/ViewAlarmsModal/ViewAlarmsModal.html',
                controller: 'viewAlarmsModalCtrl',
                windowClass: 'app-modal-window edit-template-alarms-modal',
                backdrop: 'static',
                resolve: {
                    alarms: function () { return alarms; },
                },
            });
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
    };
    SwitchoverFormController.prototype.addSigners = function () {
        var _this = this;
        this.userProvider
            .getRegularUsers()
            .then(function (users) {
            _this.modal
                .open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/View/AddSignersModal/AddSignersSwitchoverFormModal.html',
                controller: 'addSignersSwitchoverFormModalCtrl',
                backdrop: 'static',
                resolve: {
                    users: function () { return _.sortBy(users, function (user) { return user.name; }); },
                    appointments: function () {
                        return _this.getAppointments(_this.switchoverForm.headerHtml + _this.switchoverForm.footerHtml);
                    },
                },
            })
                .result.then(function (signers) {
                _this.switchoverFormProviderService
                    .addSigners(_this.switchoverForm.id, signers)
                    .then(function (footer) {
                    _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSignersAddedSuccessfullyMsg'));
                    _this.switchoverForm.footerHtml = footer;
                    _this.compileSwitchoverForm(_this.switchoverForm);
                })
                    .catch(function (error) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsSignersAddedErrorMsg'), error);
                });
            }, function () { });
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsGetDataErrorMsg'), error);
        });
    };
    SwitchoverFormController.prototype.exportSwitchoverFormTo = function (exportFileType) {
        var url = '/SwitchoverFormExport/ExportTo' + exportFileType + '?id=' + this.switchoverForm.id;
        this.exportService.export(url);
    };
    SwitchoverFormController.prototype.createTemplate = function () {
        var _this = this;
        var _a;
        var maxOperationNumber = (_a = _.max(this.switchoverForm.operations, function (o) { return o.uiOrderNumber; }).uiOrderNumber) !== null && _a !== void 0 ? _a : 0;
        var notExecutedOperation = _.find(this.switchoverForm.operations, function (operation) {
            return !_this.isOperationExecutionSuccess(operation) && operation.type !== 2;
        });
        var operationNumber = _.isDefined(notExecutedOperation)
            ? notExecutedOperation.uiOrderNumber
            : _.any(this.switchoverForm.operations)
                ? maxOperationNumber
                : 0;
        var now = new Date();
        var templateName = String.Format(this.language.getElementValue('copyHdr'), this.switchoverForm.name) +
            ' (' +
            this.formatTimezoneFilter(new Date(now.getUTCFullYear(), now.getUTCMonth(), now.getUTCDate(), now.getUTCHours(), now.getUTCMinutes(), now.getUTCSeconds()), this.dateFormat, this.localTimezone.timezoneOffsetMinutes) +
            ')';
        var modalInstance = this.modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/View/CopyTemplateModal/CopySwitchoverFormTemplateModal.html',
            controller: 'copySwitchoverFormTemplateModalCtrl',
            backdrop: 'static',
            resolve: {
                templateName: function () { return templateName; },
                operationNumber: function () { return operationNumber; },
            },
        });
        modalInstance.result.then(function (copyTemplateInfo) {
            var _a;
            if (copyTemplateInfo.needStopCurrentForm) {
                var stopInfo = {
                    reason: _this.language.getElementValue('switchoverFormsCreateUntypicalTemplateHdr'),
                    userName: (_a = _this.authentication.user) === null || _a === void 0 ? void 0 : _a.name,
                    stopDate: Date.convertToUtc(new Date(), _this.currentTimezone.timezoneOffsetMinutes),
                };
                var selectedOperation = _.find(_this.switchoverForm.operations, function (operation) { return operation.uiOrderNumber == copyTemplateInfo.operationNumber; });
                copyTemplateInfo.operationNumber = selectedOperation
                    ? selectedOperation.orderNumber
                    : _this.switchoverForm.operations.length != 0 &&
                        copyTemplateInfo.operationNumber < _this.switchoverForm.operations[0].uiOrderNumber
                        ? 1
                        : _this.switchoverForm.operations.length + 1;
                _this.switchoverFormProviderService
                    .stop(_this.switchoverForm.id, _this.switchoverForm.name, _this.switchoverForm.serialNumber, stopInfo)
                    .then(function () {
                    _this.copyTemplate(copyTemplateInfo);
                })
                    .catch(function (data) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), data);
                });
            }
            else {
                _this.copyTemplate(copyTemplateInfo);
            }
        }, function () { });
    };
    SwitchoverFormController.prototype.isCurrentTimezone = function (timezone) {
        return timezone.name === this.currentTimezone.name;
    };
    SwitchoverFormController.prototype.setCurrentTimezone = function (timezone) {
        this.currentTimezone = timezone;
    };
    SwitchoverFormController.prototype.scrollToCurrentStep = function () {
        this.scrollToStep(this.switchoverForm.currentStepOrderNumber);
    };
    SwitchoverFormController.prototype.getStopMessage = function () {
        return String.Format(this.language.getElementValue('switchoverFormsStoppedPassageHdr'), this.switchoverForm.stopUserFullName, this.switchoverForm.stopReason, this.formatTimezoneFilter(this.switchoverForm.stopDate, this.dateFormat, this.currentTimezone.timezoneOffsetMinutes));
    };
    SwitchoverFormController.prototype.getStatusBarInfo = function () {
        if (this.player.isStopped() || this.switchoverForm.isCompleted()) {
            return '';
        }
        var date = this.formatTimezoneFilter(new Date(), Date.masks.shortDateTime, 0);
        var stepDescription = this.switchoverForm.currentStep
            ? this.removeHtmlFilter(this.switchoverForm.currentStep.description)
            : '';
        var statusBarMessage = this.player.isPaused()
            ? this.language.getElementValue('switchoverFormsExecutionPausedMsg')
            : this.language.getElementValue('switchoverFormsStepInProcessMsg');
        return (date +
            ': ' +
            String.Format(statusBarMessage, this.switchoverForm.currentStep.uiOrderNumber.toString(), stepDescription.trim()));
    };
    SwitchoverFormController.prototype.executeOperation = function (operation) {
        var _this = this;
        operation.isProcessed = true;
        this.switchoverFormProviderService
            .executeOperation(this.switchoverForm.id, this.switchoverForm.name, this.switchoverForm.serialNumber, operation.id, operation.uiOrderNumber)
            .then(function (result) {
            operation.status = result.status;
            operation.executionDate = result.executionDate;
            operation.remoteControlKeyPosition = result.remoteControlKeyPosition;
            operation.isProcessed = false;
            switch (result.status) {
                case 2:
                case 1: {
                    _this.switchoverForm.nextStep();
                    _this.player.resume();
                    break;
                }
                case 3: {
                    _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsOperationExecutionInterruptedMsg'), result.failedCommand.name, result.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml);
                    break;
                }
            }
        })
            .catch(function (error) {
            operation.isProcessed = false;
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsOperationExecutionFailedMsg'), error);
        });
    };
    SwitchoverFormController.prototype.confirmOperationExecution = function (operation, isNeedCheckAlarms) {
        var _this = this;
        operation.isProcessed = true;
        this.switchoverFormProviderService
            .executeOperationManual(this.switchoverForm.id, this.switchoverForm.name, this.switchoverForm.serialNumber, operation.id, operation.uiOrderNumber, isNeedCheckAlarms)
            .then(function (result) {
            operation.status = result.status;
            operation.executionDate = result.executionDate;
            operation.remoteControlKeyPosition = result.remoteControlKeyPosition;
            operation.isProcessed = false;
            switch (result.status) {
                case 1: {
                    if (_this.isRemoteControlKeyVerificationEnabled &&
                        result.remoteControlKeyPosition === 3 &&
                        !_.isEmpty(result.errorMessage)) {
                        _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsCommandWarningOperationExecutionMsg'), result.failedCommand.name, result.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml);
                    }
                    _this.switchoverForm.nextStep();
                    _this.player.resume();
                    break;
                }
                case 3: {
                    _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsOperationExecutionInterruptedMsg'), result.failedCommand.name, result.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml);
                    break;
                }
            }
        })
            .catch(function (error) {
            operation.isProcessed = false;
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsOperationExecutionFailedMsg'), error);
        });
    };
    SwitchoverFormController.prototype.cancelConfirmationOperationExecution = function (operation) {
        var _this = this;
        operation.isProcessed = true;
        this.switchoverFormProviderService
            .cancelManualOperationExecution(this.switchoverForm.name, this.switchoverForm.serialNumber, operation.id, operation.uiOrderNumber)
            .then(function (result) {
            operation.status = result.status;
            operation.executionDate = result.executionDate;
            operation.remoteControlKeyPosition = result.remoteControlKeyPosition;
            _this.switchoverForm.prevStep();
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsOperationExecutionCancelFailedMsg'), error);
        })
            .finally(function () {
            operation.isProcessed = false;
        });
    };
    SwitchoverFormController.prototype.getRemoteControlKeyPosition = function (remoteControlKeyPosition) {
        switch (remoteControlKeyPosition) {
            case 1:
                return this.language.getElementValue('switchoverFormsRemoteControlKeyPositionHppMsg');
            case 2:
                return this.language.getElementValue('switchoverFormsRemoteControlKeyPositionJscMsg');
            case 0:
                return this.language.getElementValue('switchoverFormsRemoteControlKeyPositionReleasedMsg');
            default:
                return '';
        }
    };
    SwitchoverFormController.prototype.isManualOperation = function (operation) {
        return operation.type === 0;
    };
    SwitchoverFormController.prototype.isAutomaticOperation = function (operation) {
        return operation.type === 1;
    };
    SwitchoverFormController.prototype.isExecutedManually = function (operation) {
        return operation.status === 1;
    };
    SwitchoverFormController.prototype.isExecutedAutomatically = function (operation) {
        return operation.status === 2;
    };
    SwitchoverFormController.prototype.isTextOperation = function (operation) {
        return operation.type === 2;
    };
    SwitchoverFormController.prototype.canExecuteOperation = function (operation) {
        return (this.canEditSwitchoverForm() &&
            this.switchoverForm.currentStepOrderNumber === this.switchoverForm.conditions.length + operation.orderNumber);
    };
    SwitchoverFormController.prototype.canOpenOperationActions = function (operation) {
        if (this.canEditSwitchoverForm()) {
            var failedStep = _.find(this.switchoverForm.steps, function (s) {
                return s.status === 3 ||
                    s.status === 3;
            });
            if (failedStep) {
                return failedStep === operation;
            }
            return (this.isLastSuccessStep(operation) ||
                this.switchoverForm.currentStepOrderNumber === this.switchoverForm.conditions.length + operation.orderNumber);
        }
        else {
            return false;
        }
    };
    SwitchoverFormController.prototype.isOperationExecuted = function (operation) {
        return operation.status !== 0 && !operation.isProcessed;
    };
    SwitchoverFormController.prototype.isOperationExecutionSuccess = function (operation) {
        return (operation.status === 1 ||
            operation.status === 2);
    };
    SwitchoverFormController.prototype.hasOperations = function () {
        return !_.isEmpty(this.switchoverForm.operations);
    };
    SwitchoverFormController.prototype.verifyCondition = function (condition) {
        var _this = this;
        condition.isProcessed = true;
        this.switchoverFormProviderService
            .verifyCondition(this.switchoverForm.id, this.switchoverForm.name, this.switchoverForm.serialNumber, condition.id, condition.orderNumber)
            .then(function (result) {
            condition.status = result.status;
            condition.executionDate = result.verificationDate;
            condition.remoteControlKeyPosition = result.remoteControlKeyPosition;
            condition.isProcessed = false;
            switch (result.status) {
                case 2:
                case 1: {
                    _this.switchoverForm.nextStep();
                    _this.player.resume();
                    break;
                }
                case 3: {
                    _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsConditionVerificationInterruptedMsg'), result.failedCommand.name, result.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml);
                    break;
                }
            }
        })
            .catch(function (error) {
            condition.isProcessed = false;
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsConditionVerificationFailedMsg'), error);
        });
    };
    SwitchoverFormController.prototype.confirmConditionVerification = function (condition, isNeedCheckAlarms) {
        var _this = this;
        condition.isProcessed = true;
        this.switchoverFormProviderService
            .verifyConditionManual(this.switchoverForm.id, this.switchoverForm.name, this.switchoverForm.serialNumber, condition.id, condition.uiOrderNumber, isNeedCheckAlarms)
            .then(function (result) {
            condition.status = result.status;
            condition.executionDate = result.verificationDate;
            condition.remoteControlKeyPosition = result.remoteControlKeyPosition;
            condition.isProcessed = false;
            switch (result.status) {
                case 1: {
                    if (_this.isRemoteControlKeyVerificationEnabled &&
                        result.remoteControlKeyPosition === 3 &&
                        !_.isEmpty(result.errorMessage)) {
                        _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsCommandWarningConditionExecutionMsg'), result.failedCommand.name, result.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml);
                    }
                    _this.switchoverForm.nextStep();
                    _this.player.resume();
                    break;
                }
                case 3: {
                    _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsConditionVerificationInterruptedMsg'), result.failedCommand.name, result.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml);
                    break;
                }
            }
        })
            .catch(function (error) {
            condition.isProcessed = false;
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsConditionVerificationFailedMsg'), error);
        });
    };
    SwitchoverFormController.prototype.cancelConditionVerification = function (condition) {
        var _this = this;
        condition.isProcessed = true;
        this.switchoverFormProviderService
            .cancelManualConditionVerification(this.switchoverForm.name, this.switchoverForm.serialNumber, condition.id, condition.uiOrderNumber)
            .then(function (result) {
            condition.status = result.status;
            condition.executionDate = result.verificationDate;
            condition.remoteControlKeyPosition = result.remoteControlKeyPosition;
            _this.switchoverForm.prevStep();
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsConditionVerificationCancelFailedMsg'), error);
        })
            .finally(function () {
            condition.isProcessed = false;
        });
    };
    SwitchoverFormController.prototype.isManualCondition = function (condition) {
        return condition.type === 0;
    };
    SwitchoverFormController.prototype.isAutomaticCondition = function (condition) {
        return condition.type === 1;
    };
    SwitchoverFormController.prototype.isVerifiedManually = function (condition) {
        return condition.status === 1;
    };
    SwitchoverFormController.prototype.isVerifiedAutomatically = function (condition) {
        return condition.status === 2;
    };
    SwitchoverFormController.prototype.isTextCondition = function (condition) {
        return condition.type === 2;
    };
    SwitchoverFormController.prototype.canVerifyCondition = function (condition) {
        return this.canEditSwitchoverForm() && this.switchoverForm.currentStepOrderNumber === condition.orderNumber;
    };
    SwitchoverFormController.prototype.canOpenConditionActions = function (condition) {
        if (this.canEditSwitchoverForm()) {
            var failedStep = _.find(this.switchoverForm.steps, function (s) {
                return s.status === 3 ||
                    s.status === 3;
            });
            if (failedStep) {
                return failedStep === condition;
            }
            return (this.isLastSuccessStep(condition) ||
                this.switchoverForm.currentStepOrderNumber === condition.orderNumber);
        }
        else {
            return false;
        }
    };
    SwitchoverFormController.prototype.isLastSuccessStep = function (step) {
        var lastSucessStep = this.switchoverForm.getLastSuccessStep();
        return lastSucessStep && lastSucessStep === step;
    };
    SwitchoverFormController.prototype.isConditionVerificationSuccess = function (condition) {
        return (condition.status === 1 ||
            condition.status === 2);
    };
    SwitchoverFormController.prototype.isConditionVerified = function (condition) {
        return condition.status !== 0 && !condition.isProcessed;
    };
    SwitchoverFormController.prototype.hasConditions = function () {
        return !_.isEmpty(this.switchoverForm.conditions);
    };
    SwitchoverFormController.prototype.print = function () {
        this.printService.printPdf('/SwitchoverFormPrint/GetPdf?id=' + this.switchoverForm.id);
    };
    SwitchoverFormController.prototype.scrollToStep = function (stepOrderNumber) {
        if (stepOrderNumber > this.switchoverForm.conditions.length + this.switchoverForm.operations.length ||
            stepOrderNumber < 1) {
            return;
        }
        var page = angular.element('.page');
        var step = angular.element('#step' + stepOrderNumber);
        var toolbar = angular.element('.toolbar');
        page.animate({
            scrollTop: page.scrollTop() - page.height() / 2 + step.offset().top - page.offset().top - toolbar.outerHeight(),
        });
    };
    SwitchoverFormController.prototype.compileSwitchoverForm = function (switchoverForm) {
        var _this = this;
        var header = switchoverForm.headerHtml
            .replace(this.language.getElementValue('switchoverFormsOpeningDateWithProcentHdr'), '{{ switchoverForm.switchoverForm.creationDate | formatTimezone: switchoverForm.dateFormat: switchoverForm.currentTimezone.timezoneOffsetMinutes }}')
            .replace(this.language.getElementValue('switchoverFormsClosingDateWithProcentHdr'), '{{ switchoverForm.switchoverForm.closeDate | formatTimezone: switchoverForm.dateFormat: switchoverForm.currentTimezone.timezoneOffsetMinutes }}');
        var footer = switchoverForm.footerHtml
            .replace(this.language.getElementValue('switchoverFormsOpeningDateWithProcentHdr'), '{{ switchoverForm.switchoverForm.creationDate | formatTimezone: switchoverForm.dateFormat: switchoverForm.currentTimezone.timezoneOffsetMinutes }}')
            .replace(this.language.getElementValue('switchoverFormsClosingDateWithProcentHdr'), '{{ switchoverForm.switchoverForm.closeDate | formatTimezone: switchoverForm.dateFormat: switchoverForm.currentTimezone.timezoneOffsetMinutes }}');
        this.timeout(function () {
            var compiledHeader = _this.compile(header)(_this.scope);
            angular.element('#switchoverFormHeader').html(compiledHeader);
            var compiledBottom = _this.compile(footer)(_this.scope);
            angular.element('#switchoverFormBottom').html(compiledBottom);
        });
    };
    SwitchoverFormController.prototype.getAppointments = function (switchoverFormHtml) {
        var divHtml = document.createElement('div');
        divHtml.innerHTML = switchoverFormHtml;
        return _.uniq(_.map(divHtml.querySelectorAll('[data-appointment]'), function (a) { return a.getAttribute('data-appointment'); }));
    };
    SwitchoverFormController.prototype.copyTemplate = function (copyInfo) {
        var _this = this;
        this.switchoverFormTemplateProviderService
            .copy(copyInfo.templateName, this.switchoverForm.templateId, copyInfo.operationNumber)
            .then(function (templateId) {
            _this.location.url('/switchover-form-templates/' + templateId).search({ openTemplatesList: false });
        })
            .catch(function (data) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorCopyTemplateMsg'), data);
        });
    };
    SwitchoverFormController.prototype.getStopReasonMessage = function (switchoverForm) {
        var currentStep = switchoverForm.currentStepOrderNumber;
        if (currentStep <= switchoverForm.conditions.length) {
            return String.Format(this.language.getElementValue('switchoverFormsStopReasonMsg'), switchoverForm.conditions[currentStep - 1].uiOrderNumber.toString());
        }
        else if (currentStep <= switchoverForm.steps.length) {
            return String.Format(this.language.getElementValue('switchoverFormsStopReasonMsg'), switchoverForm.operations[currentStep - switchoverForm.conditions.length - 1].uiOrderNumber.toString());
        }
        return this.language.getElementValue('switchoverFormsStopReasonAllStepsDoneMsg');
    };
    SwitchoverFormController.$inject = [
        '$rootScope',
        '$scope',
        '$location',
        '$modal',
        '$compile',
        '$routeParams',
        'switchoverFormProvider',
        'switchoverFormTemplateProvider',
        'switchoverFormAlarmsProvider',
        'switchoverFormPlayerProvider',
        'switchoverFormConfigurationProvider',
        '$timeout',
        'notificationService',
        'language',
        'authentication',
        'userProvider',
        'timezoneProvider',
        'mailProvider',
        'formatTimezoneFilter',
        'removeHtmlFilter',
        'exportService',
        'printService',
    ];
    return SwitchoverFormController;
}());
angular.module('kamhpp').controller('SwitchoverFormCtrl', SwitchoverFormController);
