var SwitchoverFormPlayerState;
(function (SwitchoverFormPlayerState) {
    SwitchoverFormPlayerState[SwitchoverFormPlayerState["Stopped"] = 0] = "Stopped";
    SwitchoverFormPlayerState[SwitchoverFormPlayerState["Paused"] = 1] = "Paused";
    SwitchoverFormPlayerState[SwitchoverFormPlayerState["Running"] = 2] = "Running";
})(SwitchoverFormPlayerState || (SwitchoverFormPlayerState = {}));
var SwitchoverFormPlayer = (function () {
    function SwitchoverFormPlayer($timeout, switchoverFormProviderService, notificationService, language, switchoverForm, delayBetweenSteps, isWriteCommandAutomaticExecutionAllowed) {
        this.$timeout = $timeout;
        this.switchoverFormProviderService = switchoverFormProviderService;
        this.notificationService = notificationService;
        this.language = language;
        this.switchoverForm = switchoverForm;
        this.isWriteCommandAutomaticExecutionAllowed = isWriteCommandAutomaticExecutionAllowed;
        this.state = SwitchoverFormPlayerState.Stopped;
        this.delayBetweenSteps = 1000;
        this.delayBetweenSteps = delayBetweenSteps;
    }
    SwitchoverFormPlayer.prototype.run = function () {
        if (this.switchoverForm.isProcessed()) {
            return;
        }
        this.state = SwitchoverFormPlayerState.Running;
        this.processStep();
    };
    SwitchoverFormPlayer.prototype.resume = function () {
        if (this.state !== SwitchoverFormPlayerState.Paused) {
            return;
        }
        this.run();
    };
    SwitchoverFormPlayer.prototype.pause = function () {
        this.state = SwitchoverFormPlayerState.Paused;
    };
    SwitchoverFormPlayer.prototype.stop = function () {
        this.state = SwitchoverFormPlayerState.Stopped;
    };
    SwitchoverFormPlayer.prototype.isRunning = function () {
        return this.state === SwitchoverFormPlayerState.Running;
    };
    SwitchoverFormPlayer.prototype.isPaused = function () {
        return this.state === SwitchoverFormPlayerState.Paused;
    };
    SwitchoverFormPlayer.prototype.isStopped = function () {
        return this.state === SwitchoverFormPlayerState.Stopped;
    };
    SwitchoverFormPlayer.prototype.processStep = function () {
        var _this = this;
        if (this.state !== SwitchoverFormPlayerState.Running) {
            return;
        }
        if (this.switchoverForm.isCompleted()) {
            this.stop();
            return;
        }
        if (this.switchoverForm.currentStepOrderNumber - 1 < this.switchoverForm.conditions.length) {
            switch (this.switchoverForm.currentStep.type) {
                case 2: {
                    this.switchoverForm.nextStep();
                    if (this.afterStepChange) {
                        this.afterStepChange();
                    }
                    this.processStep();
                    break;
                }
                case 0: {
                    this.pause();
                    break;
                }
                case 1: {
                    if (this.switchoverForm.currentStep.hasWriteCommand &&
                        !this.isWriteCommandAutomaticExecutionAllowed) {
                        this.pause();
                    }
                    else {
                        this.switchoverForm.currentStep.isProcessed = true;
                        this.switchoverFormProviderService
                            .verifyCondition(this.switchoverForm.id, this.switchoverForm.name, this.switchoverForm.serialNumber, this.switchoverForm.currentStep.id, this.switchoverForm.currentStep.uiOrderNumber)
                            .then(function (result) {
                            _this.switchoverForm.currentStep.status = result.status;
                            _this.switchoverForm.currentStep.executionDate = result.verificationDate;
                            _this.switchoverForm.currentStep.remoteControlKeyPosition =
                                result.remoteControlKeyPosition;
                            _this.$timeout(function () {
                                if (result.status === 2) {
                                    _this.switchoverForm.nextStep();
                                    if (_this.afterStepChange) {
                                        _this.afterStepChange();
                                    }
                                    _this.processStep();
                                }
                                else {
                                    _this.pause();
                                    _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsConditionVerificationInterruptedMsg'), result.failedCommand.name, result.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml, 0);
                                }
                            }, _this.delayBetweenSteps);
                        })
                            .catch(function (error) {
                            _this.pause();
                            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsConditionVerificationFailedMsg'), error);
                        })
                            .finally(function () {
                            _this.switchoverForm.currentStep.isProcessed = false;
                        });
                    }
                    break;
                }
            }
        }
        else {
            switch (this.switchoverForm.currentStep.type) {
                case 2: {
                    this.switchoverForm.nextStep();
                    if (this.afterStepChange) {
                        this.afterStepChange();
                    }
                    this.processStep();
                    break;
                }
                case 0: {
                    this.pause();
                    break;
                }
                case 1: {
                    if (this.switchoverForm.currentStep.hasWriteCommand &&
                        !this.isWriteCommandAutomaticExecutionAllowed) {
                        this.pause();
                    }
                    else {
                        this.switchoverForm.currentStep.isProcessed = true;
                        this.switchoverFormProviderService
                            .executeOperation(this.switchoverForm.id, this.switchoverForm.name, this.switchoverForm.serialNumber, this.switchoverForm.currentStep.id, this.switchoverForm.currentStep.uiOrderNumber)
                            .then(function (result) {
                            _this.switchoverForm.currentStep.status = result.status;
                            _this.switchoverForm.currentStep.executionDate = result.executionDate;
                            _this.switchoverForm.currentStep.remoteControlKeyPosition =
                                result.remoteControlKeyPosition;
                            _this.$timeout(function () {
                                if (result.status === 2) {
                                    _this.switchoverForm.nextStep();
                                    if (_this.afterStepChange) {
                                        _this.afterStepChange();
                                    }
                                    _this.processStep();
                                }
                                else {
                                    _this.pause();
                                    _this.notificationService.warnMessage(String.Format(_this.language.getElementValue('switchoverFormsOperationExecutionInterruptedMsg'), result.failedCommand.name, result.errorMessage), undefined, NotificationBodyOutputType.TrustedHtml, 0);
                                }
                            }, _this.delayBetweenSteps);
                        })
                            .catch(function (error) {
                            _this.pause();
                            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsOperationExecutionFailedMsg'), error);
                        })
                            .finally(function () {
                            _this.switchoverForm.currentStep.isProcessed = false;
                        });
                    }
                    break;
                }
            }
        }
    };
    return SwitchoverFormPlayer;
}());
