var SwitchoverFormTemplateExportModalCtrl = (function () {
    function SwitchoverFormTemplateExportModalCtrl(scope, $modalInstance, templates) {
        this.scope = scope;
        this.$modalInstance = $modalInstance;
        this.templates = templates;
        this.formats = [
            new UiSelectItem(6, 'DOCX'),
            new UiSelectItem(7, 'JSON'),
            new UiSelectItem(1, 'PDF'),
        ];
        this.selectedFormat = this.formats[0];
        this.isAllTemplatesSelected = true;
        this.isNoneTemplatesSelected = false;
        this.scope.ctrl = this;
        this.templateOptions = _.map(templates, function (t) {
            return {
                description: t.name,
                id: t.id,
                isSelected: true,
            };
        });
    }
    SwitchoverFormTemplateExportModalCtrl.prototype.changeAllTemplateOptionsStatus = function () {
        var currentStatus = this.isAllTemplatesSelected;
        _.forEach(this.templateOptions, function (t) {
            t.isSelected = !currentStatus;
        });
        this.isAllTemplatesSelected = !currentStatus;
        this.isNoneTemplatesSelected = currentStatus;
    };
    SwitchoverFormTemplateExportModalCtrl.prototype.changeOptionSelectStatus = function (option) {
        if (_.isDefined(option)) {
            option.isSelected = !option.isSelected;
        }
        this.isAllTemplatesSelected = _.all(this.templateOptions, function (t) { return t.isSelected; });
        this.isNoneTemplatesSelected = _.all(this.templateOptions, function (t) { return !t.isSelected; });
    };
    SwitchoverFormTemplateExportModalCtrl.prototype.ok = function () {
        this.$modalInstance.close({
            ids: _.map(_.where(this.templateOptions, function (t) { return t.isSelected; }), function (t) { return t.id; }),
            format: this.selectedFormat.ident,
        });
    };
    SwitchoverFormTemplateExportModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    SwitchoverFormTemplateExportModalCtrl.$inject = ['$scope', '$modalInstance', 'templates'];
    return SwitchoverFormTemplateExportModalCtrl;
}());
angular.module('kamhpp').controller('switchoverFormTemplateExportModalCtrl', SwitchoverFormTemplateExportModalCtrl);
