var SwitchoverFormOperationImportModalCtrl = (function () {
    function SwitchoverFormOperationImportModalCtrl($scope, $modalInstance, languageService, $upload, clientSettings, contentFiles, fileType) {
        var _this = this;
        this.$scope = $scope;
        this.$modalInstance = $modalInstance;
        this.languageService = languageService;
        this.$upload = $upload;
        this.clientSettings = clientSettings;
        this.contentFiles = contentFiles;
        this.fileType = fileType;
        this.isAllOperationsSelected = true;
        this.isNoneOpetionsSelected = false;
        this.getOptionImportStatus = function (status) {
            switch (status) {
                case 1:
                    return _this.languageService.getElementValue('importStatusAddedHdr');
                case 2:
                    return _this.languageService.getElementValue('importStatusUpdatedHdr');
                default:
                    return _this.languageService.getElementValue('importStatusNonHdr');
            }
        };
        this.$scope.ctrl = this;
        switch (fileType) {
            case 6: {
                this.importProvider = new SwitchoverFormImportProviderJson(this.clientSettings.getServerInstance(), '/SwitchoverFormTypicalOperationsImport/GetDocxImportInfo', '/SwitchoverFormTypicalOperationsImport/ImportFromDocx');
                break;
            }
            case 7: {
                this.importProvider = new SwitchoverFormImportProviderJson(this.clientSettings.getServerInstance(), '/SwitchoverFormTypicalOperationsImport/GetJsonImportInfo', '/SwitchoverFormTypicalOperationsImport/ImportFromJson');
                break;
            }
        }
        this.importProvider.files = contentFiles;
        $upload
            .upload($scope.ctrl.importProvider.getImportInfoForSelect())
            .then(function (result) {
            $scope.ctrl.importProvider.importOptions = _.map(result.data, function (i) {
                return {
                    info: i,
                    isSelected: true,
                };
            });
        });
    }
    SwitchoverFormOperationImportModalCtrl.prototype.changeAllOperationOptionsStatus = function () {
        var currentStatus = this.isAllOperationsSelected;
        _.forEach(this.importProvider.importOptions, function (t) {
            t.isSelected = !currentStatus;
        });
        this.isAllOperationsSelected = !currentStatus;
        this.isNoneOpetionsSelected = currentStatus;
    };
    SwitchoverFormOperationImportModalCtrl.prototype.changeOptionSelectStatus = function (option) {
        if (_.isDefined(option)) {
            option.isSelected = !option.isSelected;
        }
        this.isAllOperationsSelected = _.all(this.importProvider.importOptions, function (o) { return o.isSelected; });
        this.isNoneOpetionsSelected = _.all(this.importProvider.importOptions, function (o) { return !o.isSelected; });
    };
    SwitchoverFormOperationImportModalCtrl.prototype.isAnyFileSelected = function () {
        return !_.isUndefined(this.importProvider.files) && _.any(this.importProvider.files);
    };
    SwitchoverFormOperationImportModalCtrl.prototype.ok = function () {
        this.$modalInstance.close(this.importProvider.getImportInfoForImport());
    };
    SwitchoverFormOperationImportModalCtrl.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    SwitchoverFormOperationImportModalCtrl.$inject = ['$scope', '$modalInstance', 'language', '$upload', 'clientSettings', 'contentFiles', 'fileType'];
    return SwitchoverFormOperationImportModalCtrl;
}());
angular.module('kamhpp').controller('switchoverFormOperationImportModalCtrl', SwitchoverFormOperationImportModalCtrl);
