var TypicalConditionsCtrl = (function () {
    function TypicalConditionsCtrl(scope, $modal, switchoverFormTypicalConditionsProvider, notificationService, language, $upload, clientSettings, removeHtmlFilter, removeLineBreakFilter, removeDuplicateSpacesFilter, exportService) {
        var _this = this;
        this.scope = scope;
        this.$modal = $modal;
        this.switchoverFormTypicalConditionsProvider = switchoverFormTypicalConditionsProvider;
        this.notificationService = notificationService;
        this.language = language;
        this.$upload = $upload;
        this.clientSettings = clientSettings;
        this.removeHtmlFilter = removeHtmlFilter;
        this.removeLineBreakFilter = removeLineBreakFilter;
        this.removeDuplicateSpacesFilter = removeDuplicateSpacesFilter;
        this.exportService = exportService;
        this.conditions = [];
        this.unknownTypeId = -1;
        this.docxFileType = 6;
        this.jsonFileType = 7;
        this.exportConditions = function () {
            _this.$modal
                .open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Conditions/ExportConditionModal/SwitchoverFormConditionExportModal.html',
                controller: 'switchoverFormConditionExportModalCtrl',
                backdrop: 'static',
                resolve: {
                    conditions: function () {
                        return _.map(_this.conditions, function (c) {
                            return {
                                description: c.description,
                                id: c.id,
                            };
                        });
                    },
                },
            })
                .result.then(function (result) {
                var url = '/SwitchoverFormTypicalConditionsExport/ExportToJson?conditionIds=' + result.ids.toString();
                _this.exportService.export(url);
            }, function () { });
        };
        this.scope.ctrl = this;
        this.condtionsFilter = {
            name: '',
            command: '',
            selectedType: this.unknownTypeId,
            types: [
                { id: this.unknownTypeId, name: language.getElementValue('allTypesHdr') },
                {
                    id: 0,
                    name: this.getTypeName(0),
                },
                {
                    id: 1,
                    name: this.getTypeName(1),
                },
                {
                    id: 2,
                    name: this.getTypeName(2),
                },
            ],
        };
        this.switchoverFormTypicalConditionsProvider
            .getAllTypicalConditions()
            .then(function (conditions) {
            _this.conditions = conditions;
            _.forEach(_this.conditions, function (condition) {
                condition.textDescription = _this.removeDuplicateSpacesFilter(_this.removeLineBreakFilter(_this.removeHtmlFilter(condition.description)));
            });
        })
            .catch(function (data) {
            notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), data);
        });
    }
    TypicalConditionsCtrl.prototype.createCondition = function () {
        var _this = this;
        var conditions = this.conditions;
        var modalInstance = this.$modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Conditions/EditConditionModal/SwitchoverFormEditConditionModal.html',
            controller: 'SwitchoverFormTemplateEditConditionModalCtrl',
            windowClass: 'app-modal-window modal-width-100',
            backdrop: 'static',
            resolve: {
                condition: function () {
                    return undefined;
                },
                conditions: function () {
                    return conditions;
                },
                isEditable: function () {
                    return true;
                },
                isTypical: function () {
                    return true;
                }
            },
        });
        modalInstance.result.then(function (newCondition) {
            if (_.any(conditions, function (op) { return op.id === newCondition.id; })) {
                _this.updateCondition(newCondition);
            }
            else {
                _this.addCondition(newCondition);
            }
        }, function () { });
    };
    TypicalConditionsCtrl.prototype.deleteCondition = function (condition) {
        var _this = this;
        var selectedCondition = condition;
        this.switchoverFormTypicalConditionsProvider
            .getTemplateNames(selectedCondition.id)
            .then(function (templateNames) {
            var modalInstance = _this.$modal.open({
                templateUrl: 'ng1/dist/src/SwitchoverForms/Conditions/DeleteTypicalConditionModal/DeleteTypicalConditionModal.html',
                controller: 'deleteTypicalConditionModalCtrl',
                backdrop: 'static',
                resolve: {
                    condition: function () {
                        return selectedCondition;
                    },
                    templateNames: function () {
                        return templateNames;
                    },
                },
            });
            modalInstance.result.then(function () {
                _this.switchoverFormTypicalConditionsProvider
                    .deleteTypicalCondition(selectedCondition.id)
                    .then(function () {
                    _this.conditions = _.filter(_this.conditions, function (condition) { return condition.id !== selectedCondition.id; });
                    _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessDeleteConditionMsg'));
                })
                    .catch(function (data) {
                    _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorDeleteConditionMsg'), data);
                });
            }, function () { });
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorLoadTemplatesMsg'), result);
        });
    };
    TypicalConditionsCtrl.prototype.copyCondition = function (condition) {
        var copiedCondition = angular.copy(condition);
        copiedCondition.id = 0;
        _.forEach(copiedCondition.commands, function (command) {
            command.id = 0;
            command.switchoverFormCommonConditionId = 0;
        });
        this.addCondition(copiedCondition);
    };
    TypicalConditionsCtrl.prototype.editCondition = function (condition) {
        var _this = this;
        var conditions = this.conditions;
        var modalInstance = this.$modal.open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Conditions/EditConditionModal/SwitchoverFormEditConditionModal.html',
            controller: 'SwitchoverFormTemplateEditConditionModalCtrl',
            windowClass: 'app-modal-window modal-width-100',
            backdrop: 'static',
            resolve: {
                condition: function () {
                    return condition;
                },
                conditions: function () {
                    return _.filter(conditions, function (c) { return c.description !== condition.description; });
                },
                isEditable: function () {
                    return true;
                },
                isTypical: function () {
                    return true;
                }
            },
        });
        modalInstance.result.then(function (editedCondition) {
            _this.updateCondition(editedCondition);
        }, function () { });
    };
    TypicalConditionsCtrl.prototype.filesForImportSelected = function (files, fileType) {
        var _this = this;
        if (!files || !_.any(files)) {
            return;
        }
        if (_.isUndefined(files) || !_.any(files)) {
            return;
        }
        this.$modal
            .open({
            templateUrl: 'ng1/dist/src/SwitchoverForms/Conditions/ImportConditionModal/SwitchoverFormConditionImportModal.html',
            controller: 'switchoverFormConditionImportModalCtrl',
            backdrop: 'static',
            resolve: {
                contentFiles: function () { return files; },
                fileType: function () { return fileType; },
            },
        })
            .result.then(function (uploadData) {
            _this.$upload.upload(uploadData).then(function (response) {
                _.forEach(response.data, function (c) {
                    c.textDescription = _this.removeDuplicateSpacesFilter(_this.removeLineBreakFilter(_this.removeHtmlFilter(c.description)));
                    var index = _.findIndex(_this.conditions, function (scopeCondition) { return scopeCondition.id === c.id; });
                    if (index === -1) {
                        _this.conditions.push(c);
                    }
                    else {
                        _this.conditions[index] = c;
                    }
                });
                _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessConditionsImportMsg'));
            }, function (response) {
                _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorConditionsImportMsg'), response.errorInfo);
            });
        });
    };
    TypicalConditionsCtrl.prototype.getTypeName = function (type) {
        switch (type) {
            case 1: {
                return this.language.getElementValue('switchoverFormsAutomaticTypeMsg');
            }
            case 0: {
                return this.language.getElementValue('switchoverFormsManualTypeMsg');
            }
            case 2: {
                return this.language.getElementValue('switchoverFormsTextTypeMsg');
            }
            default: {
                return this.language.getElementValue('switchoverFormsNotSelectedEntryHdr');
            }
        }
    };
    TypicalConditionsCtrl.prototype.filterConditions = function () {
        var _this = this;
        return function (condition) {
            return ((!_this.condtionsFilter.name ||
                condition.textDescription.toLowerCase().contains(_this.condtionsFilter.name.toLowerCase())) &&
                (!_this.condtionsFilter.command ||
                    _.any(condition.commands, function (command) {
                        return command.name.toLowerCase().contains(_this.condtionsFilter.command.toLowerCase());
                    })) &&
                (_this.condtionsFilter.selectedType === _this.unknownTypeId ||
                    condition.type === _this.condtionsFilter.selectedType));
        };
    };
    TypicalConditionsCtrl.prototype.getCommandsDescription = function (condition) {
        var _this = this;
        var commands = _.sortBy(condition.commands, function (c) { return c.orderNumber; });
        return _.map(commands, function (c) {
            return _this.getSourceDescription(c.source) +
                ': ' +
                c.tagAddress +
                ' = ' +
                c.value +
                ' (' +
                _this.getTypeDescription(c.type) +
                ')';
        });
    };
    TypicalConditionsCtrl.prototype.addCondition = function (condition) {
        var _this = this;
        this.switchoverFormTypicalConditionsProvider
            .createTypicalCondition(condition)
            .then(function (conditionId) {
            var newCondition = condition;
            newCondition.id = conditionId;
            newCondition.textDescription = _this.removeDuplicateSpacesFilter(_this.removeLineBreakFilter(_this.removeHtmlFilter(newCondition.description)));
            _this.conditions.push(newCondition);
            _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessCreateConditionMsg'));
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorCreateConditionMsg'), result);
        });
    };
    TypicalConditionsCtrl.prototype.getSourceDescription = function (source) {
        switch (source) {
            case 0:
                return this.language.getElementValue('opcSourceHdr');
            case 1:
                return this.language.getElementValue('winccoaHdr');
            default:
                return '';
        }
    };
    TypicalConditionsCtrl.prototype.getTypeDescription = function (type) {
        switch (type) {
            case 0:
                return this.language.getElementValue('switchoverFormsCommandTypeVerifyMsg');
            case 1:
                return this.language.getElementValue('switchoverFormsCommandTypeWriteMsg');
            case 2:
                return this.language.getElementValue('switchoverFormsCommandTypeVerifyBitMsg');
            case 3:
                return this.language.getElementValue('switchoverFormsCommandTypeWriteBitMsg');
            default:
                return '';
        }
    };
    TypicalConditionsCtrl.prototype.updateCondition = function (editedCondition) {
        var _this = this;
        this.switchoverFormTypicalConditionsProvider
            .updateTypicalCondition(editedCondition)
            .then(function () {
            var newCondition = _.find(_this.conditions, function (o) { return o.id === editedCondition.id; });
            newCondition.description = editedCondition.description;
            newCondition.commands = editedCondition.commands;
            newCondition.type = editedCondition.type;
            newCondition.textDescription = _this.removeDuplicateSpacesFilter(_this.removeLineBreakFilter(_this.removeHtmlFilter(newCondition.description)));
            _this.notificationService.showMessage(_this.language.getElementValue('switchoverFormsSuccessEditConditionMsg'));
        })
            .catch(function (result) {
            _this.notificationService.errorMessage(_this.language.getElementValue('switchoverFormsErrorEditConditionMsg'), result);
        });
    };
    TypicalConditionsCtrl.$inject = [
        '$scope',
        '$modal',
        'switchoverFormTypicalConditionsProvider',
        'notificationService',
        'language',
        '$upload',
        'clientSettings',
        'removeHtmlFilter',
        'removeLineBreakFilter',
        'removeDuplicateSpacesFilter',
        'exportService',
    ];
    return TypicalConditionsCtrl;
}());
angular.module('kamhpp').controller('TypicalConditionsCtrl', TypicalConditionsCtrl);
