var DateTimePickerCtrl = (function () {
    function DateTimePickerCtrl($rootScope, $scope, $element, language) {
        this.$rootScope = $rootScope;
        this.$scope = $scope;
        this.$element = $element;
        this.language = language;
        this.dateTimePickerElementName = 'DateTimePicker';
        this.defaultMaxDate = dateHelper.getMaxTimestamp();
        this.defaultMinDate = new Date(0);
    }
    DateTimePickerCtrl.prototype.setValue = function (value, minDate, maxDate) {
        var date = value;
        if (_.isDefined(maxDate) && date > maxDate) {
            date = maxDate;
        }
        if (_.isDefined(minDate) && date < minDate) {
            date = minDate;
        }
        this.$element.data(this.dateTimePickerElementName).setValue(date);
        this.date = date;
    };
    DateTimePickerCtrl.prototype.$onInit = function () {
        var _this = this;
        var _a, _b, _c, _d;
        this.format = (_a = this.format) !== null && _a !== void 0 ? _a : 'DD.MM.YYYY HH:mm:ss';
        var pickTime = (_b = this.pickTime) !== null && _b !== void 0 ? _b : undefined;
        this.minDate = (_c = this.minDate) !== null && _c !== void 0 ? _c : this.defaultMinDate;
        this.maxDate = (_d = this.maxDate) !== null && _d !== void 0 ? _d : this.defaultMaxDate;
        this.$element
            .datetimepicker({
            language: this.language.language,
            format: this.format,
            pickDate: true,
            pickTime: pickTime,
            useSeconds: pickTime && this.format.contains('ss'),
            minViewMode: this.viewMode,
            minDate: this.minDate,
            maxDate: this.maxDate,
            defaultDate: this.date
        }).on('dp.change', function (e) {
            _.defer(function () {
                _this.$rootScope.$apply(function () {
                    var date = e.date;
                    _this.setValue(date.toDate(), _this.minDate, _this.maxDate);
                });
                _this.$rootScope.$apply(function () {
                    _this.onChange();
                });
            });
        })
            .on('dp.error', function (e) {
            var date = e.date;
            if (!date.isValid()) {
                _this.$element.data(_this.dateTimePickerElementName).setValue(_this.date);
                return;
            }
            _this.setValue(date.toDate(), _this.minDate, _this.maxDate);
        });
        this.$scope.$watch(function () { return _this.date; }, function (after, before) {
            if (after === before) {
                return;
            }
            _this.$element.data(_this.dateTimePickerElementName).setValue(after);
        }, true);
        this.$scope.$watch(function () { return _this.minDate; }, function (after, before) {
            if (after === before) {
                return;
            }
            var value = _.isDefined(after)
                ? after
                : _this.defaultMinDate;
            _this.$element.data(_this.dateTimePickerElementName).setMinDate(value);
        }, true);
        this.$scope.$watch(function () { return _this.maxDate; }, function (after, before) {
            if (after === before) {
                return;
            }
            var value = _.isDefined(after)
                ? after
                : _this.defaultMaxDate;
            _this.$element.data(_this.dateTimePickerElementName).setMaxDate(value);
        }, true);
        this.$scope.$watch(function () { return _this.isDisabled; }, function (after, before) {
            if (after == undefined && after == before) {
                return;
            }
            if (after) {
                _this.$element.data(_this.dateTimePickerElementName).disable();
            }
            else {
                _this.$element.data(_this.dateTimePickerElementName).enable();
            }
        }, true);
    };
    DateTimePickerCtrl.prototype.$onDestroy = function () {
        var _a;
        (_a = this.$element.data(this.dateTimePickerElementName)) === null || _a === void 0 ? void 0 : _a.destroy();
    };
    DateTimePickerCtrl.inject = ['$rootScope', '$scope', '$element', 'language'];
    return DateTimePickerCtrl;
}());
angular.module('kamhpp').controller('DateTimePickerCtrl', DateTimePickerCtrl);
