var CreateRoleNameModalController = (function () {
    function CreateRoleNameModalController($scope, $rootScope, $modalInstance, clientSettings, language, authentication, notificationService, authenticationConfigurationProvider, uniqueNameService, blockUI, roles) {
        var _this = this;
        this.$scope = $scope;
        this.$rootScope = $rootScope;
        this.$modalInstance = $modalInstance;
        this.clientSettings = clientSettings;
        this.language = language;
        this.authentication = authentication;
        this.notificationService = notificationService;
        this.authenticationConfigurationProvider = authenticationConfigurationProvider;
        this.uniqueNameService = uniqueNameService;
        this.blockUI = blockUI;
        this.roles = roles;
        this.tree = new SmsTree();
        this.multiple = false;
        this.plugins = ['types', 'wholerow'];
        this.groupSearch = { fullName: '' };
        this.jsonTree = '';
        this.isDomainGroupButtonClicked = false;
        this.name = '';
        this.unregGroupSearchWatchFunc = function () {
            _this.$scope.$watch(function () { return _this.groupSearch.fullName; }, function (after, before) {
                if (before == after)
                    return;
                _this.tempTree = JSON.parse(_this.jsonTree);
                if (after == '') {
                    _this.tree.element.jstree().settings.core.data = _this.tempTree;
                }
                else {
                    _this.filterTree(_this.tempTree);
                    _this.tree.element.jstree().settings.core.data =
                        _this.tempTree.length != 0
                            ? _this.tempTree
                            : { id: '1', text: _this.language.getElementValue('elementsNotFoundHdr'), type: 'none' };
                }
                _this.tree.element.jstree('refresh');
            });
        };
        this.unregJstreeSelectNodeWatchFunc = function () {
            _this.$scope.$on('jstreeSelectNode', function (event, node) {
                if (node.type == 'folder') {
                    _this.selectedUserGroup = undefined;
                    return;
                }
                var parentNode = _this.tree.element.jstree().get_node(node.parents[0]);
                _this.selectedUserGroup = parentNode.text + '\\' + node.original.text;
                _this.name = _this.selectedUserGroup;
            });
        };
        $scope.ctrl = this;
        this.name = this.uniqueNameService.generate(_.map(roles, function (role) { return role.name; }), this.language.getElementValue('securityRoleUniqueNamePattern'));
        this.authenticationConfigurationProvider.isAdsiAuthenticationAllowed().then(function (result) {
            _this.isAdsiAuthenticationAllowed = result;
        });
        this.startingData = {
            headers: {
                Authorization: this.authentication.getAccessTokenHeader()
            },
            url: this.clientSettings.getServerInstance() + '/Adsi/GetDomainGroupsTree',
            beforeSend: function () {
                _this.blockUI.start();
            },
            success: function (newNodes) {
                _this.$rootScope.$apply(function () {
                    if (_this.jsonTree == '') {
                        _this.jsonTree = JSON.stringify(newNodes);
                    }
                });
            },
            error: function (data) {
                $scope.$apply(function () {
                    notificationService.errorMessage(language.getElementValue('failedLoadDataServerMsg'), data.statusText);
                });
            },
            complete: function () {
                $scope.$apply(function () {
                    blockUI.stop();
                });
            }
        };
        this.unregJstreeSelectNodeWatchFunc();
        this.unregGroupSearchWatchFunc();
    }
    CreateRoleNameModalController.prototype.$onDestroy = function () {
        this.unregJstreeSelectNodeWatchFunc();
        this.unregGroupSearchWatchFunc();
    };
    CreateRoleNameModalController.prototype.filterTree = function (tree) {
        var domainMatched = false;
        var toDelete = [];
        for (var i = 0; i < tree.length; i++) {
            if (tree[i].type == 'folder') {
                domainMatched = !_.isNull(tree[i].text) &&
                    tree[i].text.toLowerCase().indexOf(this.groupSearch.fullName.toLowerCase()) != -1;
                this.filterTree(tree[i].children);
                if (tree[i].children.length === 0) {
                    tree.splice(i, 1);
                    i--;
                }
            }
            else {
                if (!_.isNull(tree[i].text) &&
                    tree[i].text.toLowerCase().indexOf(this.groupSearch.fullName.toLowerCase()) != -1) {
                    continue;
                }
                else {
                    toDelete.push(tree[i].id);
                }
            }
        }
        if (toDelete.length !== tree.length || !domainMatched) {
            _.each(toDelete, function (id) {
                var index = _.findIndex(tree, function (e) {
                    return e.id === id;
                });
                if (index !== -1) {
                    tree.splice(index, 1);
                }
            });
        }
    };
    CreateRoleNameModalController.prototype.openDomainGroupTree = function () {
        this.isDomainGroupButtonClicked = true;
    };
    CreateRoleNameModalController.prototype.ok = function () {
        var _this = this;
        if (_.any(this.roles, function (role) { return role.name === _this.name; })) {
            this.notificationService.errorMessage(String.Format(this.language.getElementValue('securityRoleExistsMsg'), this.name));
            return;
        }
        this.$modalInstance.close(this.name);
    };
    CreateRoleNameModalController.prototype.cancel = function () {
        this.$modalInstance.dismiss();
    };
    CreateRoleNameModalController.$inject = [
        '$scope',
        '$rootScope',
        '$modalInstance',
        'clientSettings',
        'language',
        'authentication',
        'notificationService',
        'authenticationConfigurationProvider',
        'uniqueNameService',
        'blockUI',
        'roles',
    ];
    return CreateRoleNameModalController;
}());
angular.module('kamhpp').controller('CreateRoleNameModalController', CreateRoleNameModalController);
