var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var OperationTimeConfigurationCtrl = (function (_super) {
    __extends(OperationTimeConfigurationCtrl, _super);
    function OperationTimeConfigurationCtrl($scope, operationTimeConfigurationProvider, notificationService, language) {
        var _this = _super.call(this, $scope) || this;
        _this.operationTimeConfigurationProvider = operationTimeConfigurationProvider;
        _this.notificationService = notificationService;
        _this.language = language;
        _this.connectionTypes = [];
        _this.loadConfiguration();
        _this.providerTypes = [
            new UiSelectItem(0, language.getElementValue('serverSettingsOperationTimeNoneHdr')),
            new UiSelectItem(1, language.getElementValue('serverSettingsOperationTimeDemoHdr')),
            new UiSelectItem(2, language.getElementValue('winccoaHdr')),
            new UiSelectItem(3, language.getElementValue('opcSourceHdr')),
        ];
        return _this;
    }
    OperationTimeConfigurationCtrl.prototype.loadConfiguration = function () {
        var _this = this;
        this.operationTimeConfigurationProvider
            .getOperationTimeConfiguration()
            .then(function (configuration) {
            _this.configuration = configuration;
            _this.selectedProviderType = _.find(_this.providerTypes, function (type) { return type.ident === configuration.providerType; });
            _this.setConnectionTypes();
        })
            .catch(function (error) {
            _this.notificationService.errorMessage(_this.language.getElementValue('failedLoadDataServerMsg'), error);
        });
    };
    OperationTimeConfigurationCtrl.prototype.saveConfiguration = function () {
        var _this = this;
        if (_.isUndefined(this.selectedProviderType) ||
            (this.configuration.providerType === 3 &&
                _.isBlank(this.configuration.connectionIdent))) {
            this.notificationService.warnMessage(this.language.getElementValue('allFieldsMustFilledMsg'));
            return;
        }
        return this.operationTimeConfigurationProvider
            .saveOperationTimeConfiguration(this.configuration)
            .then(function () {
            _this.hasChanges = false;
            _this.notificationService.showMessage(_this.language.getElementValue('changesSuccessSaveMsg'));
        })
            .catch(function (error) {
            return _this.notificationService.errorMessage(_this.language.getElementValue('failedSaveChangesMsg'), error);
        });
    };
    OperationTimeConfigurationCtrl.prototype.onConfigurationChanged = function () {
        this.hasChanges = true;
        this.setConnectionTypes();
    };
    OperationTimeConfigurationCtrl.prototype.onProviderTypeChanged = function (providerType) {
        if (this.configuration.providerType === providerType.ident) {
            return;
        }
        this.configuration.providerType = providerType.ident;
        this.onConfigurationChanged();
    };
    OperationTimeConfigurationCtrl.prototype.isOpcProvider = function () {
        return _.isDefined(this.configuration) && this.configuration.providerType === 3;
    };
    OperationTimeConfigurationCtrl.prototype.isWinccOaProvider = function () {
        return (_.isDefined(this.configuration) && this.configuration.providerType === 2);
    };
    OperationTimeConfigurationCtrl.prototype.setConnectionTypes = function () {
        switch (this.configuration.providerType) {
            case 3: {
                this.connectionTypes = [6];
                break;
            }
            case 2: {
                this.connectionTypes = [4];
                break;
            }
            default: {
                this.connectionTypes = [];
            }
        }
    };
    OperationTimeConfigurationCtrl.$inject = ['$scope', 'operationTimeConfigurationProvider', 'notificationService', 'language'];
    return OperationTimeConfigurationCtrl;
}(BaseConfigurationController));
angular.module('kamhpp').controller('OperationTimeConfigurationCtrl', OperationTimeConfigurationCtrl);
