// $License: NOLICENSE
//--------------------------------------------------------------------------------
/**
  Функции выполнения запросов к Технодок на базе netGet и netPost

  @file $relPath
  @copyright $copyright
  @author SMS-Automation
*/

//--------------------------------------------------------------------------------
// Libraries used (#uses)

//--------------------------------------------------------------------------------
// Variables and Constants

// Настройки для для игнорирования ошибок SSL при запросах к ТехноДок
private mapping TECHNODOC_IGNORE_SSL_ERROS_REQUEST_OPTIONS = makeMapping("ignoreSslErrors", "");

// Игнорировать ли ошибки SSL при запросах
// При корректном сертификате ошибок быть не должно
private const bool TECHNODOC_IGNORE_SSL_ERRORS = false;

// Наименование заголовка содержащего статус выполнения
const string TECHNODOC_STATUS_CODE_RESPONSE_HEADER_NAME = "httpStatusCode";

// Наименование заголовка содержащего данные
const string TECHNODOC_CONTENT_RESPONSE_HEADER_NAME = "content";

//--------------------------------------------------------------------------------
//@public members
//--------------------------------------------------------------------------------


/**
  @param url Выполнить GET запрос
  @param result Результат выполнения
  @param options Опции запроса
  @return Возвращает 0 в случае успешного запроса иначе -1
*/
int technodocNetGet(string url, mapping &result, mapping options = makeMapping())
{
  // Добавляем для HTTPS доп. опции
  if (isHttpsProtocol(url))
  {
    configureSslOptions(options);
  }

  return netGet(url, result, options);
}

/** Выполнить POST запрос
  @param url Адрес запроса
  @param data Данные тела запроса
  @param result Результат выполнения
  @return Возвращает 0 в случае успешного запроса иначе -1
*/
int technodocNetPost(string url, mapping data, mapping &result)
{
  // Добавляем для HTTPS доп. опции
  if (isHttpsProtocol(url))
  {
    configureSslOptions(data);
  }

  return netPost(url, data, result);
}

//--------------------------------------------------------------------------------
//@private members
//--------------------------------------------------------------------------------

/** Используется ли в URL HTTPS протокол
  @param options Опции запроса
  @return Возвращает true если протокол HTTPS иначе false
*/
private bool isHttpsProtocol(string url)
{
  return strpos(url, "https://") >= 0;
}

/** Настроить SSL опции
  @param options Опции запроса
*/
private void configureSslOptions(mapping &options)
{
  if (TECHNODOC_IGNORE_SSL_ERRORS)
  {
    disableSslErrors(options);
  }
}

/** Игнорировать ошибки SSL
  @param options Опции запроса
*/
private void disableSslErrors(mapping &options)
{
  // Добавляем опции, если они не содержатся уже
  dyn_anytype defaultRequestOptions = mappingKeys(TECHNODOC_IGNORE_SSL_ERROS_REQUEST_OPTIONS);

  for (int i = 1; i <= dynlen(defaultRequestOptions); i++)
  {
    if (!mappingHasKey(options, defaultRequestOptions[i]))
    {
      options[defaultRequestOptions[i]] = TECHNODOC_IGNORE_SSL_ERROS_REQUEST_OPTIONS[defaultRequestOptions[i]];
    }
  }
}
