﻿START TRANSACTION;

CREATE TABLE "td"."SFTemplates" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Name" text NOT NULL UNIQUE,
    "HeaderHtml" text NULL,
    "FooterHtml" text NULL,
    "IsTypical" boolean NOT NULL,
    "CreationDate" timestamp without time zone NULL,
    "CreatedUserName" text NOT NULL,
    "ParentTemplateId" integer NULL,
    CONSTRAINT "PK_SFTemplates" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFTemplates_SFTemplates_ParentTemplateId" FOREIGN KEY ("ParentTemplateId") REFERENCES "td"."SFTemplates" ("Id") ON DELETE SET NULL
);

CREATE TABLE "td"."SFForms" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "TemplateId" integer NULL,
    "Name" text NOT NULL,
    "SerialNumber" integer NOT NULL CHECK ("SerialNumber" > 0),
    "HeaderHtml" text NULL,
    "FooterHtml" text NULL,
    "Status" integer NOT NULL,
    "CreationDate" timestamp without time zone NOT NULL,
    "CloseDate" timestamp without time zone NULL,
    "StopDate" timestamp without time zone NULL,
    "StopReason" text NULL,
    "StopUserFullName" text NULL,
    UNIQUE("Name", "SerialNumber"),
    CONSTRAINT "PK_SFForms" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFForms_SFTemplates_TemplateId" FOREIGN KEY ("TemplateId") REFERENCES "td"."SFTemplates" ("Id") ON DELETE SET NULL
);

CREATE TABLE "td"."SFFormOperations" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Description" text NOT NULL,
    "Type" integer NOT NULL,
    "OrderNumber" integer NOT NULL,
    "Status" integer NOT NULL,
    "ExecutionDate" timestamp without time zone NULL,
    "RemoteControlKeyPosition" integer NOT NULL,
    "SwitchoverFormId" integer NOT NULL,
    CONSTRAINT "PK_SFFormOperations" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFFormOperations_SFForms_SwitchoverFormId" FOREIGN KEY ("SwitchoverFormId") REFERENCES "td"."SFForms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFFormConditions" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Description" text NOT NULL,
    "Type" integer NOT NULL,
    "OrderNumber" integer NOT NULL,
    "Status" integer NOT NULL,
    "ExecutionDate" timestamp without time zone NULL,
    "RemoteControlKeyPosition" integer NOT NULL,
    "SwitchoverFormId" integer NOT NULL,
    CONSTRAINT "PK_SFFormConditions" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFFormConditions_SFForms_SwitchoverFormId" FOREIGN KEY ("SwitchoverFormId") REFERENCES "td"."SFForms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFFormOperationCommands" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Name" text NULL,
    "Type" integer NOT NULL,
    "Source" integer NOT NULL,
    "OrderNumber" integer NOT NULL,
    "TagAddress" text NOT NULL,
    "Value" text NOT NULL,
    "SwitchoverFormOperationId" integer NOT NULL,
    CONSTRAINT "PK_SFFormOperationCommands" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFFormOperationCommands_SFFormOperations_SwitchoverFormOperationId" FOREIGN KEY ("SwitchoverFormOperationId") REFERENCES "td"."SFFormOperations" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFFormConditionCommands" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Name" text NULL,
    "Type" integer NOT NULL,
    "Source" integer NOT NULL,
    "OrderNumber" integer NOT NULL,
    "TagAddress" text NOT NULL,
    "Value" text NOT NULL,
    "SwitchoverFormConditionId" integer NOT NULL,
    CONSTRAINT "PK_SFFormConditionCommands" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFFormConditionCommands_SFFormConditions_SwitchoverFormConditionId" FOREIGN KEY ("SwitchoverFormConditionId") REFERENCES "td"."SFFormConditions" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFSettings" (
    "Name" text NOT NULL,
    "Value" text NULL,
    CONSTRAINT "PK_SFSettings" PRIMARY KEY ("Name")
);

CREATE TABLE "td"."SFOperations" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Description" text NOT NULL,
    "Type" integer NOT NULL,
    "IsTypical" boolean NOT NULL,
    CONSTRAINT "PK_SFOperations" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."SFConditions" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Description" text NOT NULL,
    "Type" integer NOT NULL,
    "IsTypical" boolean NOT NULL,
    CONSTRAINT "PK_SFConditions" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."SFTemplateOperation" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "SwitchoverFormTemplateId" integer NOT NULL,
    "SwitchoverFormCommonOperationId" integer NOT NULL,
    "OrderNumber" integer NOT NULL,
    CONSTRAINT "PK_SFTemplateOperation" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFTemplateOperation_SFTemplates_SwitchoverFormTemplateId" FOREIGN KEY ("SwitchoverFormTemplateId") REFERENCES "td"."SFTemplates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_SFTemplateOperation_SFOperations_SwitchoverFormCommonOperationId" FOREIGN KEY ("SwitchoverFormCommonOperationId") REFERENCES "td"."SFOperations" ("Id") ON DELETE RESTRICT
);

CREATE TABLE "td"."SFTemplateCondition" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "SwitchoverFormTemplateId" integer NOT NULL,
    "SwitchoverFormCommonConditionId" integer NOT NULL,
    "OrderNumber" integer NOT NULL,
    CONSTRAINT "PK_SFTemplateCondition" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFTemplateCondition_SFTemplates_SwitchoverFormTemplateId" FOREIGN KEY ("SwitchoverFormTemplateId") REFERENCES "td"."SFTemplates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_SFTemplateCondition_SFConditions_SwitchoverFormCommonConditionId" FOREIGN KEY ("SwitchoverFormCommonConditionId") REFERENCES "td"."SFConditions" ("Id") ON DELETE RESTRICT
);

CREATE TABLE "td"."SFOperationCommands" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Name" text NULL,
    "Type" integer NOT NULL,
    "Source" integer NOT NULL,
    "OrderNumber" integer NOT NULL,
    "TagAddress" text NOT NULL,
    "Value" text NOT NULL,
    "SwitchoverFormCommonOperationId" integer NOT NULL,
    CONSTRAINT "PK_SFOperationCommands" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFOperationCommands_SFOperations_SwitchoverFormCommonOperationId" FOREIGN KEY ("SwitchoverFormCommonOperationId") REFERENCES "td"."SFOperations" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFConditionCommands" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Name" text NULL,
    "Type" integer NOT NULL,
    "Source" integer NOT NULL,
    "OrderNumber" integer NOT NULL,
    "TagAddress" text NOT NULL,
    "Value" text NOT NULL,
    "SwitchoverFormCommonConditionId" integer NOT NULL,
    CONSTRAINT "PK_SFConditionCommands" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFConditionCommands_SFConditions_SwitchoverFormConditionId" FOREIGN KEY ("SwitchoverFormCommonConditionId") REFERENCES "td"."SFConditions" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFFormAlarms" (
    "Id" INTEGER GENERATED BY DEFAULT AS IDENTITY,
    "Name" TEXT NOT NULL,
    "SwitchoverFormId" INTEGER NOT NULL,
    CONSTRAINT "PK_SFFormAlarms" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFFormAlarms_SFForms_SwitchoverFormId" FOREIGN KEY ("SwitchoverFormId") REFERENCES "td"."SFForms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFFormAlarmCommands" (
    "Id" INTEGER GENERATED BY DEFAULT AS IDENTITY,
    "Name" TEXT NULL,
    "Source" INTEGER NOT NULL,
    "TagAddress" TEXT NOT NULL,
    "Value" TEXT NOT NULL,
    "SwitchoverFormAlarmId" INTEGER NOT NULL,
    CONSTRAINT "PK_SFFormAlarmCommands" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFFormAlarmCommands_SFFormAlarms_SwitchoverFormAlarmId" FOREIGN KEY ("SwitchoverFormAlarmId") REFERENCES "td"."SFFormAlarms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFFormCommonAlarms" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Name" text NOT NULL,
    CONSTRAINT "PK_SFFormCommonAlarms" PRIMARY KEY ("Id")
);

CREATE TABLE "td"."SFFormCommonAlarmCommands" (
    "Id" integer GENERATED BY DEFAULT AS IDENTITY,
    "Name" text NULL,
    "Source" integer NOT NULL,
    "TagAddress" text NOT NULL,
    "Value" text NOT NULL,
    "SwitchoverFormCommonAlarmId" integer NOT NULL,
    CONSTRAINT "PK_SFFormCommonAlarmCommands" PRIMARY KEY ("Id"),
    CONSTRAINT "FK_SFFormCommonAlarmCommands_SFFormCommonAlarms_SwitchoverFormCommonAlarmId" FOREIGN KEY ("SwitchoverFormCommonAlarmId") REFERENCES "td"."SFFormCommonAlarms" ("Id") ON DELETE CASCADE
);

CREATE TABLE "td"."SFFormTemplateAlarms" (
    "SwitchoverFormTemplateId" integer NOT NULL,
    "SwitchoverFormCommonAlarmId" integer NOT NULL,
    CONSTRAINT "PK_SFFormTemplateAlarms" PRIMARY KEY ("SwitchoverFormTemplateId", "SwitchoverFormCommonAlarmId"),
    CONSTRAINT "FK_SFFormTemplateAlarms_SFTemplates_SwitchoverFormTemplateId" FOREIGN KEY ("SwitchoverFormTemplateId") REFERENCES "td"."SFTemplates" ("Id") ON DELETE CASCADE,
    CONSTRAINT "FK_SFFormTemplateAlarms_SFFormCommonAlarms_SwitchoverFormCommonAlarmId" FOREIGN KEY ("SwitchoverFormCommonAlarmId") REFERENCES "td"."SFFormCommonAlarms" ("Id") ON DELETE RESTRICT
);

CREATE INDEX "IX_SFFormOperations_SwitchoverFormId" ON "td"."SFFormOperations" ("SwitchoverFormId");

CREATE INDEX "IX_SFFormConditions_SwitchoverFormId" ON "td"."SFFormConditions" ("SwitchoverFormId");

CREATE INDEX "IX_SFFormOperationCommands_SwitchoverFormOperationId" ON "td"."SFFormOperationCommands" ("SwitchoverFormOperationId");

CREATE INDEX "IX_SFFormConditionCommands_SwitchoverFormConditionId" ON "td"."SFFormConditionCommands" ("SwitchoverFormConditionId");

CREATE INDEX "IX_SFTemplates_ParentTemplateId" ON "td"."SFTemplates" ("ParentTemplateId");

CREATE INDEX "IX_SFTemplateOperation_SwitchoverFormTemplateId" ON "td"."SFTemplateOperation" ("SwitchoverFormTemplateId");

CREATE INDEX "IX_SFTemplateOperation_SwitchoverFormCommonOperationId" ON "td"."SFTemplateOperation" ("SwitchoverFormCommonOperationId");

CREATE INDEX "IX_SFTemplateCondition_SwitchoverFormTemplateId" ON "td"."SFTemplateCondition" ("SwitchoverFormTemplateId");

CREATE INDEX "IX_SFTemplateCondition_SwitchoverFormCommonConditionId" ON "td"."SFTemplateCondition" ("SwitchoverFormCommonConditionId");

CREATE INDEX "IX_SFOperationCommands_SwitchoverFormCommonOperationId" ON "td"."SFOperationCommands" ("SwitchoverFormCommonOperationId");

CREATE INDEX "IX_SFConditionCommands_SwitchoverFormCommonConditionId" ON "td"."SFConditionCommands" ("SwitchoverFormCommonConditionId");

CREATE INDEX "IX_SFFormAlarms_SwitchoverFormId" ON "td"."SFFormAlarms" ("SwitchoverFormId");

CREATE INDEX "IX_SFFormAlarmCommands_SwitchoverFormAlarmId" ON "td"."SFFormAlarmCommands" ("SwitchoverFormAlarmId");

CREATE INDEX "IX_SFFormTemplateAlarms_SwitchoverFormTemplateId" ON "td"."SFFormTemplateAlarms" ("SwitchoverFormTemplateId");

CREATE INDEX "IX_SFFormTemplateAlarms_SwitchoverFormCommonAlarmId" ON "td"."SFFormTemplateAlarms" ("SwitchoverFormCommonAlarmId");

CREATE INDEX "IX_SFFormCommonAlarmCommands_SwitchoverFormCommonAlarmId" ON "td"."SFFormCommonAlarmCommands" ("SwitchoverFormCommonAlarmId");

COMMIT;

