var UserSessionService = (function () {
    function UserSessionService($window, $rootScope, $location, userSessionProvider, authentication) {
        this.$window = $window;
        this.$rootScope = $rootScope;
        this.$location = $location;
        this.userSessionProvider = userSessionProvider;
        this.authentication = authentication;
    }
    UserSessionService.prototype.run = function () {
        var _this = this;
        this.$window.addEventListener("beforeunload", function () {
            if (!_this.authentication.isLoggedIn()) {
                return;
            }
            fetch('/api/UserSession/RemoveUserSession', {
                keepalive: true,
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': _this.authentication.getAccessTokenHeader(),
                },
                body: JSON.stringify({
                    url: "".concat(_this.$location.url())
                }),
            });
        });
        this.$rootScope.$on('$locationChangeSuccess', function (event, newUrl, oldUrl) {
            if (!_this.authentication.isLoggedIn()) {
                return;
            }
            var newPath = newUrl.split("/#")[1];
            var oldPath = oldUrl.split("/#")[1];
            if (_.isUndefined(newPath) && _.isUndefined(oldPath)) {
                return;
            }
            if (newPath === "/logout" || newPath === "/login") {
                _this.userSessionProvider.removeAllUserSessions();
                return;
            }
            _this.userSessionProvider.updateUserSession(newPath, oldPath);
        });
    };
    UserSessionService.prototype.getUsersOnPage = function (url) {
        return this.userSessionProvider.getUsers(url);
    };
    UserSessionService.$inject = [
        '$window',
        '$rootScope',
        '$location',
        'userSessionProvider',
        'authentication'
    ];
    return UserSessionService;
}());
angular.module('kamhpp').service('userSessionService', UserSessionService);
