app.factory('guid', function () {
    return {
        new: function (separator) {
            if (separator === void 0) { separator = '-'; }
            var s = [];
            var hexDigits = '0123456789abcdef';
            for (var i = 0; i < 36; i++) {
                s[i] = hexDigits.substr(Math.floor(Math.random() * 0x10), 1);
            }
            s[14] = '4';
            s[19] = hexDigits.substr((s[19] & 0x3) | 0x8, 1);
            s[8] = s[13] = s[18] = s[23] = separator;
            return s.join('');
        },
        fromString: function (str) {
            var parts = [];
            parts.push(str.slice(0, 8));
            parts.push(str.slice(9, 13));
            parts.push(str.slice(14, 18));
            parts.push(str.slice(19, 23));
            parts.push(str.slice(24, 36));
            return parts.join('-');
        },
    };
});
