app.directive('smsTimespan', function ($compile, language) {
    return {
        restrict: 'E',
        scope: {
            value: '=value',
            onChange: '&?',
            periods: '=periods',
            canNegative: '=?cannegative',
            defaultValue: '=?defaultvalue',
            isDisabled: '=',
            min: '=?min'
        },
        link: function (scope, element) {
            var inputChildIndex = 0;
            var defaultPeriods = [
                {
                    periodValue: 's',
                    periodName: language.getElementValue('smsTimespanSecondHdr'),
                },
                {
                    periodValue: 'm',
                    periodName: language.getElementValue('smsTimespanMinuteHdr'),
                },
                {
                    periodValue: 'h',
                    periodName: language.getElementValue('smsTimespanHourHdr'),
                },
                {
                    periodValue: 'd',
                    periodName: language.getElementValue('smsTimespanDayHdr'),
                },
                {
                    periodValue: 'w',
                    periodName: language.getElementValue('smsTimespanWeekHdr'),
                },
                {
                    periodValue: 'M',
                    periodName: language.getElementValue('smsTimespanMonthHdr'),
                },
                {
                    periodValue: 'y',
                    periodName: language.getElementValue('smsTimespanYearHdr'),
                },
            ];
            scope.periodTypes = _.isUndefined(scope.periods)
                ? defaultPeriods
                : scope.periods;
            scope.periodtype = {};
            scope.parseValue = function () {
                if (scope.value == undefined)
                    return;
                if (_.isNaN(scope.value))
                    return;
                scope.periodtype.value = scope.value[scope.value.length - 1];
                scope.periodval = +scope.value.substr(0, scope.value.length - 1);
            };
            scope.parseValue();
            var template = '<div class="input-group sms-timespan">'
                + '<input ng-disabled="isDisabled" placeholder="0"'
                + (scope.canNegative === true
                    ? ' input-integer'
                    : ' input-number')
                + ' type="number" class="form-control" ng-model="periodval">'
                + '<ui-select ng-disabled="isDisabled"'
                + ' class="sms-timespan-select" ng-model="periodtype.value">'
                + '<ui-select-match placeholder="{{ \'smsTimespanChangePch\' | lng }}">{{$select.selected.periodName | smsTailTo:15:"…"}}</ui-select-match>'
                + '<ui-select-choices repeat="item.periodValue as item in periodTypes" style=" position: absolute;">'
                + '<small ng-bind-html="item.periodName  | highlight: $select.search"></small>'
                + '</ui-select-choices>'
                + '</ui-select>'
                + '</div>';
            var el = angular.element($compile(template)(scope));
            element.empty();
            element.append(el);
            var e = el[0].children[inputChildIndex];
            var onFocusOut = function () {
                if (!scope.periodval || (scope.periodval === 0 && scope.defaultValue !== 0)) {
                    scope.periodval = !_.isNumber(scope.defaultValue)
                        ? 0
                        : parseInt(scope.defaultValue);
                }
                scope.$apply();
            };
            if (e.addEventListener) {
                e.addEventListener('blur', onFocusOut, true);
            }
            else {
                e.attachEvent('onfocusout', onFocusOut);
            }
            var watchPeriodValUnreg = scope.$watch('periodval', function (newVal, oldVal) {
                if (newVal === oldVal) {
                    return;
                }
                scope.periodval = _.isNumber(scope.periodval)
                    ? scope.periodval
                    : parseInt(scope.defaultValue);
                scope.value = scope.periodval + scope.periodtype.value;
                if (_.isDefined(scope.min)) {
                    if (parseInt(scope.periodval) < scope.min) {
                        scope.value = scope.min + scope.periodtype.value;
                    }
                }
                if (_.isDefined(scope.onChange)) {
                    scope.onChange();
                }
            });
            var watchPeriodTypeUnreg = scope.$watch('periodtype.value', function (newVal, oldVal) {
                if (newVal === oldVal) {
                    return;
                }
                scope.value = scope.periodval + scope.periodtype.value;
                if (_.isDefined(scope.min)) {
                    if (parseInt(scope.periodval) < scope.min) {
                        scope.value = scope.min + scope.periodtype.value;
                    }
                }
                if (_.isDefined(scope.onChange)) {
                    scope.onChange();
                }
            });
            var watchValueUnreg = scope.$watch('value', function () {
                scope.parseValue();
            });
            var watchDisable = scope.$watch("isDisabled", function (newValue) {
                scope.isDisabled = newValue;
            });
            var unregistrationDestroyFunc = scope.$on('$destroy', function () {
                watchValueUnreg();
                watchPeriodValUnreg();
                watchPeriodTypeUnreg();
                unregistrationDestroyFunc();
                watchDisable();
            });
        },
    };
});
