app.directive('smsTabset', [
    '$timeout',
    function ($timeout) {
        return {
            restrict: 'E',
            scope: {
                tabs: '=',
                index: '=?',
                reset: '&?',
                onSelectTab: '&?',
                onAddTab: '&?',
                onDeleteTab: '&?',
                onEditTab: '&?',
                onMoveLeftTab: '&?',
                onMoveRightTab: '&?',
            },
            templateUrl: 'ng1/dist/src/_angular/_directives/smsTabset/SmsTabset.html',
            link: function (scope, element) {
                var _a;
                (_a = scope.index) !== null && _a !== void 0 ? _a : (scope.index = 0);
                scope.select = function (index) {
                    if (scope.index === index) {
                        return;
                    }
                    scope.index = index;
                    scope.onSelectTab({ index: index });
                    $timeout(function () { return scrollToTab(index); }, 0);
                };
                scope.isLastTab = function () {
                    return scope.index >= scope.tabs.length - 1;
                };
                scope.onEditClick = function (event, index) {
                    scope.onEditTab({ index: index });
                };
                scope.onDeleteClick = function (event, index) {
                    scope.onDeleteTab({ index: index });
                };
                scope.canMoveLeft = function (index) {
                    return (index > 0);
                };
                scope.onMoveLeftClick = function (event, index) {
                    scope.onMoveLeftTab({ index: index });
                };
                scope.canMoveRight = function (index) {
                    return index < scope.tabs.length - 1;
                };
                scope.onMoveRightClick = function (event, index) {
                    scope.onMoveRightTab({ index: index });
                };
                var watchIndex = scope.$watch('index', function (newIndex, oldIdex) {
                    if (newIndex && oldIdex !== newIndex) {
                        scope.index = newIndex;
                        $timeout(function () { return scrollToTab(newIndex); }, 0);
                    }
                });
                var unregistrationDestroyFunc = scope.$on('$destroy', function () {
                    watchIndex();
                    unregistrationDestroyFunc();
                });
                var scrollToTab = function (index) {
                    var tabContainer = element[0].querySelector('.sms-tabset-items-wrapper');
                    var tabItems = element[0].querySelectorAll('.nav-item');
                    var activeTab = tabItems[index];
                    if (activeTab) {
                        var previousTab = tabItems[index - 1];
                        var nextTab = tabItems[index + 1];
                        var containerRect = tabContainer.getBoundingClientRect();
                        var activeTabRect = activeTab.getBoundingClientRect();
                        if (previousTab) {
                            var previousTabRect = previousTab.getBoundingClientRect();
                            if (previousTabRect.left < containerRect.left) {
                                tabContainer.scrollLeft -= containerRect.left - previousTabRect.left;
                            }
                        }
                        if (nextTab) {
                            var nextTabRect = nextTab.getBoundingClientRect();
                            if (nextTabRect.right > containerRect.right) {
                                tabContainer.scrollLeft += nextTabRect.right - containerRect.right;
                            }
                        }
                        if (activeTabRect.left < containerRect.left) {
                            tabContainer.scrollLeft -= containerRect.left - activeTabRect.left;
                        }
                        else if (activeTabRect.right > containerRect.right) {
                            tabContainer.scrollLeft += activeTabRect.right - containerRect.right;
                        }
                    }
                };
                var tabContainer = element[0].querySelector('.sms-tabset-items-wrapper');
                tabContainer.addEventListener('wheel', function (event) {
                    if (event.deltaY !== 0) {
                        event.preventDefault();
                        tabContainer.scrollLeft += event.deltaY;
                    }
                });
            },
        };
    },
]);
