angular.module('kamhpp').directive('smsSortable', [
    function () {
        return {
            restrict: 'A',
            scope: {
                items: '=',
                isDisabled: '=',
                beforeSort: '&',
                afterSort: '&',
            },
            link: function (scope, element) {
                var draggedItemIndex = 0;
                element.sortable({
                    disabled: scope.isDisabled,
                    start: function (event, ui) {
                        if (scope.beforeSort) {
                            scope.beforeSort();
                        }
                        ui.item.addClass('cursor-grabbing');
                        draggedItemIndex = ui.item.index();
                        scope.$apply();
                    },
                    stop: function (event, ui) {
                        var item = scope.items[draggedItemIndex];
                        ui.item.removeClass('cursor-grabbing');
                        scope.items.splice(draggedItemIndex, 1);
                        scope.items.splice(ui.item.index(), 0, item);
                        if (scope.afterSort) {
                            scope.afterSort();
                        }
                        scope.$apply();
                    },
                    helper: function (e, tr) {
                        var element = angular.element(tr);
                        var cells = element.find('td');
                        if (!cells) {
                            return element;
                        }
                        _.forEach(cells, function (cell) {
                            var cellElement = angular.element(cell);
                            cellElement.width(cellElement.width());
                        });
                        return element;
                    },
                });
            },
        };
    },
]);
