app.directive('smsSelectableInput', function () {
    return {
        restrict: 'E',
        require: 'ngModel',
        scope: {
            options: '=',
            ngModel: '=',
            isDisabled: '=',
            placeholder: '@',
        },
        template: "<input type='text' placeholder='{{ placeholder }}' class='form-control' ng-class='isDisabled === true ? \"disabled\" : \"\"' ng-if='options.length === 0' ng-model='modelController.$viewValue' ng-change='setOption(modelController.$viewValue)'/>" +
            "<div ng-if='options.length > 0' class='input-group input-group-select' ng-class='isDisabled === true ? \"disabled\" : \"\"'>" +
            "<input type='text' placeholder='{{ placeholder }}' class='form-control' ng-model='modelController.$viewValue' ng-change='setOption(modelController.$viewValue)' typeahead='option for option in options | filter: $viewValue' typeahead-on-select='setOption($model)'/>" +
            "<div class='input-group-btn' style='position: static'>" +
            "<button ng-if='options.length > 0' type='button' class='btn btn-default dropdown-toggle'>" +
            "<span class='caret'> </span>" +
            '</button>' +
            "<ul class='dropdown-menu pull-right'>" +
            "<li ng-repeat='option in options' ng-click='setOption(option)'>" +
            '<a><span>{{ option }}</span></a>' +
            '</li>' +
            '</ul>' +
            '</div>' +
            '</div>',
        link: function (scope, element, attrs, ngModel) {
            scope.modelController = ngModel;
            scope.setOption = function (value) {
                ngModel.$setViewValue(value);
            };
        },
    };
});
